var wtageinf_male_3rd = [
    [0, 5.181992169],
    [0.5, 6.15900701],
    [1.5, 7.952313758],
    [2.5, 9.55315119],
    [3.5, 10.98437537],
    [4.5, 12.26537195],
    [5.5, 13.4129056],
    [6.5, 14.44174676],
    [7.5, 15.36507134],
    [8.5, 16.19471946],
    [9.5, 16.94137369],
    [10.5, 17.61469038],
    [11.5, 18.22340268],
    [12.5, 18.77540506],
    [13.5, 19.27782688],
    [14.5, 19.73709603],
    [15.5, 20.1589967],
    [16.5, 20.54872175],
    [17.5, 20.91092083],
    [18.5, 21.24974453],
    [19.5, 21.56888604],
    [20.5, 21.87161873],
    [21.5, 22.16083208],
    [22.5, 22.43906474],
    [23.5, 22.70853563],
    [24.5, 22.97117284],
    [25.5, 23.2286408],
    [26.5, 23.48236574],
    [27.5, 23.73355943],
    [28.5, 23.98324161],
    [29.5, 24.23226069],
    [30.5, 24.48131338],
    [31.5, 24.73096454],
    [32.5, 24.98165604],
    [33.5, 25.23373549],
    [34.5, 25.4874611],
    [35.5, 25.74301715],
    [36, 25.87152451]
];
var wtageinf_male_5th = [
    [0, 5.559188844],
    [0.5, 6.522242441],
    [1.5, 8.304667496],
    [2.5, 9.907161759],
    [3.5, 11.34630564],
    [4.5, 12.63845345],
    [5.5, 13.79878566],
    [6.5, 14.84118386],
    [7.5, 15.77829526],
    [8.5, 16.62163085],
    [9.5, 17.38166135],
    [10.5, 18.06790378],
    [11.5, 18.68899902],
    [12.5, 19.25278135],
    [13.5, 19.76634244],
    [14.5, 20.23608934],
    [15.5, 20.66779843],
    [16.5, 21.06666533],
    [17.5, 21.43735138],
    [18.5, 21.78402675],
    [19.5, 22.11041109],
    [20.5, 22.41981078],
    [21.5, 22.71515409],
    [22.5, 22.99902398],
    [23.5, 23.27368835],
    [24.5, 23.54112856],
    [25.5, 23.80306579],
    [26.5, 24.06098576],
    [27.5, 24.31616147],
    [28.5, 24.5696748],
    [29.5, 24.82243621],
    [30.5, 25.07520334],
    [31.5, 25.32859925],
    [32.5, 25.58312346],
    [33.5, 25.83917483],
    [34.5, 26.09705936],
    [35.5, 26.35700417],
    [36, 26.48780306]

];

var wtageinf_male_10th = [
    [0, 6.102364066],
    [0.5, 7.060922037],
    [1.5, 8.845235181],
    [2.5, 10.45985458],
    [3.5, 11.91696628],
    [4.5, 13.23017573],
    [5.5, 14.41303434],
    [6.5, 15.47844409],
    [7.5, 16.43844716],
    [8.5, 17.30417243],
    [9.5, 18.08584626],
    [10.5, 18.79283006],
    [11.5, 19.43366837],
    [12.5, 20.01614056],
    [13.5, 20.54731288],
    [14.5, 21.03358921],
    [15.5, 21.48075985],
    [16.5, 21.894048],
    [17.5, 22.27815374],
    [18.5, 22.6372956],
    [19.5, 22.97524953],
    [20.5, 23.29538541],
    [21.5, 23.60070143],
    [22.5, 23.89385577],
    [23.5, 24.17719647],
    [24.5, 24.45278893],
    [25.5, 24.7224415],
    [26.5, 24.98772927],
    [27.5, 25.25001587],
    [28.5, 25.51047387],
    [29.5, 25.77010348],
    [30.5, 26.0297499],
    [31.5, 26.29011957],
    [32.5, 26.55179437],
    [33.5, 26.81524637],
    [34.5, 27.08084991],
    [35.5, 27.34889346]
];

var wtageinf_male_25th = [
    [0, 6.93134438],
    [0.5, 7.914270261],
    [1.5, 9.743520494],
    [2.5, 11.4034306],
    [3.5, 12.90697376],
    [4.5, 14.26693217],
    [5.5, 15.49597922],
    [6.5, 16.60636058],
    [7.5, 17.60967731],
    [8.5, 18.51678131],
    [9.5, 19.33774016],
    [10.5, 20.08184095],
    [11.5, 20.7576147],
    [12.5, 21.37287196],
    [13.5, 21.93474271],
    [14.5, 22.44971912],
    [15.5, 22.92369807],
    [16.5, 23.36202304],
    [17.5, 23.76952444],
    [18.5, 24.15055856],
    [19.5, 24.50904405],
    [20.5, 24.84849708],
    [21.5, 25.17206399],
    [22.5, 25.48255211],
    [23.5, 25.78245846],
    [24.5, 26.07399665],
    [25.5, 26.35912162],
    [26.5, 26.6395527],
    [27.5, 26.91679476],
    [28.5, 27.19215785],
    [29.5, 27.46677498],
    [30.5, 27.74161876],
    [31.5, 28.01751517],
    [32.5, 28.29516307],
    [33.5, 28.57513791],
    [34.5, 28.85791011],
    [35.5, 29.14385445],
    [36, 29.28810793]

];

var wtageinf_male_50th = [
    [0, 7.76644697],
    [0.5, 8.806834133],
    [1.5, 10.73495518],
    [2.5, 12.48035528],
    [3.5, 14.06106236],
    [4.5, 15.49204015],
    [5.5, 16.7869354],
    [6.5, 17.95849228],
    [7.5, 19.01863145],
    [8.5, 19.9784636],
    [9.5, 20.84830067],
    [10.5, 21.63767694],
    [11.5, 22.35537847],
    [12.5, 23.00947878],
    [13.5, 23.60737632],
    [14.5, 24.1558346],
    [15.5, 24.66102164],
    [16.5, 25.12854894],
    [17.5, 25.56350936],
    [18.5, 25.97051384],
    [19.5, 26.35372586],
    [20.5, 26.71689535],
    [21.5, 27.06339027],
    [22.5, 27.39622662],
    [23.5, 27.71809687],
    [24.5, 28.03139671],
    [25.5, 28.33825007],
    [26.5, 28.6405324],
    [27.5, 28.93989252],
    [28.5, 29.23777267],
    [29.5, 29.53542698],
    [30.5, 29.83393849],
    [31.5, 30.13423288],
    [32.5, 30.43710168],
    [33.5, 30.74320038],
    [34.5, 31.05307128],
    [35.5, 31.3671516],
    [36, 31.52587777]
];

var wtageinf_male_75th = [
    [0, 8.53396843],
    [0.5, 9.652329643],
    [1.5, 11.72012065],
    [2.5, 13.58631595],
    [3.5, 15.27287763],
    [4.5, 16.7977106],
    [5.5, 18.17647258],
    [6.5, 19.42332955],
    [7.5, 20.55127884],
    [8.5, 21.5723054],
    [9.5, 22.49747269],
    [10.5, 23.33698732],
    [11.5, 24.10025266],
    [12.5, 24.79591723],
    [13.5, 25.4319193],
    [14.5, 26.01553018],
    [15.5, 26.55339533],
    [16.5, 27.0515738],
    [17.5, 27.51557618],
    [18.5, 27.95040114],
    [19.5, 28.36056971],
    [20.5, 28.75015937],
    [21.5, 29.12283568],
    [22.5, 29.4818828],
    [23.5, 29.83023267],
    [24.5, 30.17049264],
    [25.5, 30.50497175],
    [26.5, 30.83570556],
    [27.5, 31.1644795],
    [28.5, 31.49285071],
    [29.5, 31.82216853],
    [30.5, 32.15359341],
    [31.5, 32.48811251],
    [32.5, 32.82656454],
    [33.5, 33.16964015],
    [34.5, 33.51790594],
    [35.5, 33.87181402],
    [36, 34.05099383]
];

var wtageinf_male_90th = [
    [0, 9.179485458],
    [0.5, 10.37995482],
    [1.5, 12.60193605],
    [2.5, 14.60575409],
    [3.5, 16.41354521],
    [4.5, 18.04482504],
    [5.5, 19.51704505],
    [6.5, 20.84602555],
    [7.5, 22.04623023],
    [8.5, 23.13094126],
    [9.5, 24.11237895],
    [10.5, 25.00179099],
    [11.5, 25.80952405],
    [12.5, 26.54508542],
    [13.5, 27.21719728],
    [14.5, 27.83384701],
    [15.5, 28.40233361],
    [16.5, 28.92931155],
    [17.5, 29.42083228],
    [18.5, 29.88238363],
    [19.5, 30.31892728],
    [20.5, 30.73493478],
    [21.5, 31.1344216],
    [22.5, 31.52097982],
    [23.5, 31.8978092],
    [24.5, 32.26774694],
    [25.5, 32.6332959],
    [26.5, 32.99665147],
    [27.5, 33.35972708],
    [28.5, 33.72417831],
    [29.5, 34.09142574],
    [30.5, 34.46267629],
    [31.5, 34.83894278],
    [32.5, 35.22106557],
    [33.5, 35.60972521],
    [34.5, 36.00546217],
    [35.5, 36.40869087],
    [36, 36.61321202]
];

var wtageinf_male_95th = [
    [0, 9.548644028],
    [0.5, 10.80228624],
    [1.5, 13.12762355],
    [2.5, 15.22646216],
    [3.5, 17.11908252],
    [4.5, 18.82498938],
    [5.5, 20.362352],
    [6.5, 21.74795863],
    [7.5, 22.99729153],
    [8.5, 24.1246199],
    [9.5, 25.14308771],
    [10.5, 26.0647922],
    [11.5, 26.90085464],
    [12.5, 27.66148425],
    [13.5, 28.3560378],
    [14.5, 28.99307442],
    [15.5, 29.58040719],
    [16.5, 30.12515176],
    [17.5, 30.63377225],
    [18.5, 31.11212458],
    [19.5, 31.56549788],
    [20.5, 31.99865313],
    [21.5, 32.41586027],
    [22.5, 32.82093329],
    [23.5, 33.21726333],
    [24.5, 33.60785036],
    [25.5, 33.99533291],
    [26.5, 34.38201659],
    [27.5, 34.76990095],
    [28.5, 35.16070505],
    [29.5, 35.55589171],
    [30.5, 35.95669053],
    [31.5, 36.36412036],
    [32.5, 36.77900637],
    [33.5, 37.2020053],
    [34.5, 37.63361945],
    [35.5, 38.0742149],
    [36, 38.2979628]
];

var wtageinf_male_97th = [
    [0, 9.782274278],
    [0.5, 11.07177496],
    [1.5, 13.46824403],
    [2.5, 15.63375029],
    [3.5, 17.58653171],
    [4.5, 19.34557606],
    [5.5, 20.92927443],
    [6.5, 22.35497042],
    [7.5, 23.63883227],
    [8.5, 24.79584455],
    [9.5, 25.83984623],
    [10.5, 26.78358604],
    [11.5, 27.63878363],
    [12.5, 28.41619095],
    [13.5, 29.12565344],
    [14.5, 29.77616776],
    [15.5, 30.37593748],
    [16.5, 30.9324257],
    [17.5, 31.45240503],
    [18.5, 31.94200456],
    [19.5, 32.40675486],
    [20.5, 32.85162932],
    [21.5, 33.28108392],
    [22.5, 33.69909451],
    [23.5, 34.10919167],
    [24.5, 34.51449388],
    [25.5, 34.9177387],
    [26.5, 35.32131214],
    [27.5, 35.72727651],
    [28.5, 36.13739705],
    [29.5, 36.55316685],
    [30.5, 36.9758308],
    [31.5, 37.40641049],
    [32.5, 37.84571648],
    [33.5, 38.29438437],
    [34.5, 38.75288336],
    [35.5, 39.22153774],
    [36, 39.45974237]
];

$(function chartSetup() {
$('#container').highcharts({
    chart: {
        type: 'areaspline'
    },
    title: {
        text: 'Infant Weight Growth Chart (Males)'
    },
    legend: {
        layout: 'horizontal',
        align: 'center',
        verticalAlign: 'bottom',
        borderWidth: 1,
        backgroundColor: '#FFFFFF',
        itemStyle: {
        	cursor: 'pointer',
        	color: '#274b6d',
        	fontSize: '12px'
        }
    },
    plotOptions: {
        areaspline: {
            fillOpacity: 0.2
        },
        series: {
            minPointLength: 1,
            shadow: false,
            events: {
                legendItemClick: function () {
                    if (this.name == 'Percentiles') {
                        toggleBands(chart);
                    }
                }
            }
        }
    },
    xAxis: {
        title: {
            text: 'Age (months)'
        },
        labels: {
            rotation: -90
        }
    },
    yAxis: {
        title: {
            text: 'Weight (pounds)'
        }
    },
    tooltip: {
        shared: true,
        valueSuffix: ' pounds',
        valueDecimals: 2
    },
    credits: {
        enabled: false
    },
    series: [{
        name: '3rd Percentile',
        data: wtageinf_male_3rd,
        marker: {
            enabled: false
        }
    }, {
        name: '5th Percentile',
        data: wtageinf_male_5th,
        marker: {
            enabled: false
        }
    }, {
        name: '10th Percentile',
        data: wtageinf_male_10th,
        marker: {
            enabled: false
        }
    }, {
        name: '25th Percentile',
        data: wtageinf_male_25th,
        marker: {
            enabled: false
        }
    }, {
        name: '50th Percentile',
        data: wtageinf_male_50th,
        marker: {
            enabled: false
        }
    }, {
        name: '75th Percentile',
        data: wtageinf_male_75th,
        marker: {
            enabled: false
        }
    }, {
        name: '90th Percentile',
        data: wtageinf_male_90th,
        marker: {
            enabled: false
        }
    }, {
        name: '95th Percentile',
        data: wtageinf_male_95th,
        marker: {
            enabled: false
        }
    }, {
        name: '97th Percentile',
        data: wtageinf_male_97th,
        marker: {
            enabled: false
        }
    }]
});
});

function toggleBands(chart) {
    $.each(chart.xAxis, function (index, elX) {
        $.each(elX.plotLinesAndBands, function (index, el) {
            if (el.svgElem !== undefined) {
                el.svgElem[el.visible ? 'show' : 'hide']();
                el.visible = !el.visible;
            }
        });
    });
}

$('.toggle-trigger').click(function () {
    var target = $(this).attr('data-target');

    $('#' + target).slideToggle('slow');

    if ($(this).hasClass('plus')) {
        $(this).addClass('minus').removeClass('plus');
    } else {
        $(this).addClass('plus').removeClass('minus');
    }
});