var wtageinf_female_3rd = [
    [0, 5.311046363],
    [0.5, 6.065217365],
    [1.5, 7.485045256],
    [2.5, 8.795172338],
    [3.5, 10.00424333],
    [4.5, 11.1199852],
    [5.5, 12.1495005],
    [6.5, 13.09939949],
    [7.5, 13.97587021],
    [8.5, 14.78472101],
    [9.5, 15.53140978],
    [10.5, 16.22106618],
    [11.5, 16.85850994],
    [12.5, 17.44826668],
    [13.5, 17.99458221],
    [14.5, 18.50143582],
    [15.5, 18.97255195],
    [16.5, 19.41141305],
    [17.5, 19.82126986],
    [18.5, 20.20515237],
    [19.5, 20.56588011],
    [20.5, 20.90607216],
    [21.5, 21.22815672],
    [22.5, 21.53438039],
    [23.5, 21.8268172],
    [24.5, 22.10737734],
    [25.5, 22.37781548],
    [26.5, 22.63973914],
    [27.5, 22.89461643],
    [28.5, 23.14378376],
    [29.5, 23.38845335],
    [30.5, 23.62972027],
    [31.5, 23.86856945],
    [32.5, 24.10588239],
    [33.5, 24.34244289],
    [34.5, 24.57894512],
    [35.5, 24.81599765],
    [36, 24.93489874]

];
var wtageinf_female_5th = [
    [0, 5.605391396],
    [0.5, 6.367773012],
    [1.5, 7.804742671],
    [2.5, 9.131404713],
    [3.5, 10.35566952],
    [4.5, 11.48507259],
    [5.5, 12.52674319],
    [6.5, 13.48741085],
    [7.5, 14.3734204],
    [8.5, 15.19074827],
    [9.5, 15.94501869],
    [10.5, 16.64151919],
    [11.5, 17.28521557],
    [12.5, 17.88076623],
    [13.5, 18.43253593],
    [14.5, 18.94460923],
    [15.5, 19.42080287],
    [16.5, 19.86467886],
    [17.5, 20.27955595],
    [18.5, 20.66852134],
    [19.5, 21.03444189],
    [20.5, 21.37997493],
    [21.5, 21.7075788],
    [22.5, 22.01952291],
    [23.5, 22.3178976],
    [24.5, 22.6046236],
    [25.5, 22.88146111],
    [26.5, 23.15001878],
    [27.5, 23.41176215],
    [28.5, 23.66802196],
    [29.5, 23.92000204],
    [30.5, 24.16878702],
    [31.5, 24.41534975],
    [32.5, 24.66055834],
    [33.5, 24.90518263],
    [34.5, 25.14990185],
    [35.5, 25.39530979],
    [36, 25.51843587]

];

var wtageinf_female_10th = [
    [0, 6.043888965],
    [0.5, 6.823887547],
    [1.5, 8.294346438],
    [2.5, 9.65149236],
    [3.5, 10.90303788],
    [4.5, 12.05664945],
    [5.5, 13.11972294],
    [6.5, 14.09930521],
    [7.5, 15.00206902],
    [8.5, 15.83430977],
    [9.5, 16.60195193],
    [10.5, 17.31056001],
    [11.5, 17.96535157],
    [12.5, 18.57121126],
    [13.5, 19.13270512],
    [14.5, 19.65409498],
    [15.5, 20.13935251],
    [16.5, 20.59217322],
    [17.5, 21.0159899],
    [18.5, 21.41398579],
    [19.5, 21.78910736],
    [20.5, 22.14407661],
    [21.5, 22.48140303],
    [22.5, 22.80339512],
    [23.5, 23.11217152],
    [24.5, 23.40967171],
    [25.5, 23.69766639],
    [26.5, 23.97776733],
    [27.5, 24.25143703],
    [28.5, 24.51999788],
    [29.5, 24.784641],
    [30.5, 25.04643467],
    [31.5, 25.30633252],
    [32.5, 25.56518133],
    [33.5, 25.82372835],
    [34.5, 26.0826287],
    [35.5, 26.34245196],
    [36, 26.47286591]

];

var wtageinf_female_25th = [
    [0, 6.74270223],
    [0.5, 7.562782179],
    [1.5, 9.105786272],
    [2.5, 10.52660494],
    [3.5, 11.83411027],
    [4.5, 13.03695428],
    [5.5, 14.14342206],
    [6.5, 15.16137281],
    [7.5, 16.0982208],
    [8.5, 16.96093545],
    [9.5, 17.75605076],
    [10.5, 18.48967948],
    [11.5, 19.16752955],
    [12.5, 19.79492167],
    [13.5, 20.3768072],
    [14.5, 20.91778599],
    [15.5, 21.4221245],
    [16.5, 21.89377231],
    [17.5, 22.33637954],
    [18.5, 22.75331296],
    [19.5, 23.14767189],
    [20.5, 23.52230322],
    [21.5, 23.87981629],
    [22.5, 24.22259682],
    [23.5, 24.55282053],
    [24.5, 24.87246619],
    [25.5, 25.18332802],
    [26.5, 25.48702763],
    [27.5, 25.78502553],
    [28.5, 26.07863192],
    [29.5, 26.36901722],
    [30.5, 26.65722204],
    [31.5, 26.94416655],
    [32.5, 27.23065963],
    [33.5, 27.51740792],
    [34.5, 27.80502278],
    [35.5, 28.09402946],
    [36, 28.2391969]

];

var wtageinf_female_50th = [
    [0, 7.47821019],
    [0.5, 8.354562612],
    [1.5, 9.998508329],
    [2.5, 11.50728527],
    [3.5, 12.89191376],
    [4.5, 14.16269305],
    [5.5, 15.32927101],
    [6.5, 16.40067904],
    [7.5, 17.38535961],
    [8.5, 18.29119243],
    [9.5, 19.12552053],
    [10.5, 19.89517608],
    [11.5, 20.60650586],
    [12.5, 21.26539621],
    [13.5, 21.87729734],
    [14.5, 22.44724673],
    [15.5, 22.97989276],
    [16.5, 23.47951536],
    [17.5, 23.95004828],
    [18.5, 24.39509932],
    [19.5, 24.81796981],
    [20.5, 25.22167358],
    [21.5, 25.60895484],
    [22.5, 25.98230569],
    [23.5, 26.34398246],
    [24.5, 26.69602162],
    [25.5, 27.04025478],
    [26.5, 27.37832321],
    [27.5, 27.71169137],
    [28.5, 28.04166004],
    [29.5, 28.3693788],
    [30.5, 28.69585761],
    [31.5, 29.02197819],
    [32.5, 29.34850455],
    [33.5, 29.67609385],
    [34.5, 30.00530381],
    [35.5, 30.33660403],
    [36, 30.5031624]

];

var wtageinf_female_75th = [
    [0, 8.178542645],
    [0.5, 9.12030607],
    [1.5, 10.88288411],
    [2.5, 12.49618303],
    [3.5, 13.97332636],
    [4.5, 15.32635234],
    [5.5, 16.56639699],
    [6.5, 17.70379214],
    [7.5, 18.74812997],
    [8.5, 19.70831294],
    [9.5, 20.59259616],
    [10.5, 21.40862548],
    [11.5, 22.16347258],
    [12.5, 22.86366799],
    [13.5, 23.51523242],
    [14.5, 24.12370631],
    [15.5, 24.69417896],
    [16.5, 25.23131461],
    [17.5, 25.73937923],
    [18.5, 26.22226517],
    [19.5, 26.68351488],
    [20.5, 27.12634364],
    [21.5, 27.55366126],
    [22.5, 27.96809272],
    [23.5, 28.37199798],
    [24.5, 28.76749066],
    [25.5, 29.1564561],
    [26.5, 29.54056824],
    [27.5, 29.92130588],
    [28.5, 30.29996803],
    [29.5, 30.67768843],
    [30.5, 31.05544941],
    [31.5, 31.43409491],
    [32.5, 31.81434282],
    [33.5, 32.1967976],
    [34.5, 32.58195897],
    [35.5, 32.97023475],
    [36, 33.16564493]

];

var wtageinf_female_90th = [
    [0, 8.783658908],
    [0.5, 9.790276327],
    [1.5, 11.67239149],
    [2.5, 13.39280969],
    [3.5, 14.96609362],
    [4.5, 16.40566134],
    [5.5, 17.72392821],
    [6.5, 18.9323982],
    [7.5, 20.04173181],
    [8.5, 21.06180186],
    [9.5, 22.00174227],
    [10.5, 22.86999242],
    [11.5, 23.67433825],
    [12.5, 24.42195092],
    [13.5, 25.11942334],
    [14.5, 25.77280486],
    [15.5, 26.38763464],
    [16.5, 26.9689728],
    [17.5, 27.52143093],
    [18.5, 28.04920067],
    [19.5, 28.55608127],
    [20.5, 29.04550579],
    [21.5, 29.52056609],
    [22.5, 29.98403661],
    [23.5, 30.43839722],
    [24.5, 30.88585465],
    [25.5, 31.32836313],
    [26.5, 31.76764397],
    [27.5, 32.20520393],
    [28.5, 32.64235291],
    [29.5, 33.08022065],
    [30.5, 33.51977229],
    [31.5, 33.96182346],
    [32.5, 34.40705426],
    [33.5, 34.85602289],
    [34.5, 35.30917722],
    [35.5, 35.76686753],
    [36, 35.99749903]

];

var wtageinf_female_95th = [
    [0, 9.135800507],
    [0.5, 10.18344004],
    [1.5, 12.14217235],
    [2.5, 13.93224152],
    [3.5, 15.56878955],
    [4.5, 17.06591469],
    [5.5, 18.43672547],
    [6.5, 19.69339611],
    [7.5, 20.8472192],
    [8.5, 21.90865542],
    [9.5, 22.88738045],
    [10.5, 23.79232962],
    [11.5, 24.63174043],
    [12.5, 25.41319308],
    [13.5, 26.14364933],
    [14.5, 26.82948957],
    [15.5, 27.476548],
    [16.5, 28.09014707],
    [17.5, 28.67512952],
    [18.5, 29.23588934],
    [19.5, 29.77640153],
    [20.5, 30.30025024],
    [21.5, 30.81065572],
    [22.5, 31.31050003],
    [23.5, 31.80235153],
    [24.5, 32.28848808],
    [25.5, 32.77091932],
    [26.5, 33.2514076],
    [27.5, 33.73148805],
    [28.5, 34.21248743],
    [29.5, 34.6955422],
    [30.5, 35.18161539],
    [31.5, 35.67151265],
    [32.5, 36.16589744],
    [33.5, 36.66530498],
    [34.5, 37.17015641],
    [35.5, 37.68077053],
    [36, 37.93831331]

];

var wtageinf_female_97th = [
    [0, 9.360828409],
    [0.5, 10.43587994],
    [1.5, 12.44623404],
    [2.5, 14.28366371],
    [3.5, 15.96356425],
    [4.5, 17.50040613],
    [5.5, 18.90770966],
    [6.5, 20.1980645],
    [7.5, 21.38316552],
    [8.5, 22.47385426],
    [9.5, 23.48016202],
    [10.5, 24.41135312],
    [11.5, 25.27596713],
    [12.5, 26.08186009],
    [13.5, 26.83624414],
    [14.5, 27.54572592],
    [15.5, 28.21634273],
    [16.5, 28.85359882],
    [17.5, 29.4624983],
    [18.5, 30.04757767],
    [19.5, 30.61293673],
    [20.5, 31.16226806],
    [21.5, 31.69888522],
    [22.5, 32.22574956],
    [23.5, 32.7454959],
    [24.5, 33.26045679],
    [25.5, 33.77268583],
    [26.5, 34.28397962],
    [27.5, 34.79589872],
    [28.5, 35.30978748],
    [29.5, 35.82679289],
    [30.5, 36.34788232],
    [31.5, 36.87386032],
    [32.5, 37.40538448],
    [33.5, 37.94297945],
    [34.5, 38.48705331],
    [35.5, 39.03790818],
    [36, 39.31594733]

];

$(function chartSetup() {
    $('#container').highcharts({
        chart: {
            type: 'areaspline'
        },
        title: {
            text: 'Infant Weight Growth Chart (Females)'
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 1,
            backgroundColor: '#FFFFFF',
            itemStyle: {
                cursor: 'pointer',
                color: '#274b6d',
                fontSize: '12px'
            }
        },
        plotOptions: {
            areaspline: {
                fillOpacity: 0.2
            },
            series: {
                minPointLength: 1,
                shadow: false,
                events: {
                    legendItemClick: function () {
                        if (this.name == 'Percentiles') {
                            toggleBands(chart);
                        }
                    }
                }
            }
        },
        xAxis: {
            title: {
                text: 'Age (months)'
            },
            labels: {
                rotation: -90
            }
        },
        yAxis: {
            title: {
                text: 'Weight (pounds)'
            }
        },
        tooltip: {
            shared: true,
            valueSuffix: ' pounds',
            valueDecimals: 2
        },
        credits: {
            enabled: false
        },
        series: [{
            name: '3rd Percentile',
            data: wtageinf_female_3rd,
            marker: {
                enabled: false
            }
        }, {
            name: '5th Percentile',
            data: wtageinf_female_5th,
            marker: {
                enabled: false
            }
        }, {
            name: '10th Percentile',
            data: wtageinf_female_10th,
            marker: {
                enabled: false
            }
        }, {
            name: '25th Percentile',
            data: wtageinf_female_25th,
            marker: {
                enabled: false
            }
        }, {
            name: '50th Percentile',
            data: wtageinf_female_50th,
            marker: {
                enabled: false
            }
        }, {
            name: '75th Percentile',
            data: wtageinf_female_75th,
            marker: {
                enabled: false
            }
        }, {
            name: '90th Percentile',
            data: wtageinf_female_90th,
            marker: {
                enabled: false
            }
        }, {
            name: '95th Percentile',
            data: wtageinf_female_95th,
            marker: {
                enabled: false
            }
        }, {
            name: '97th Percentile',
            data: wtageinf_female_97th,
            marker: {
                enabled: false
            }
        }]
    });
});

function toggleBands(chart) {
    $.each(chart.xAxis, function (index, elX) {
        $.each(elX.plotLinesAndBands, function (index, el) {
            if (el.svgElem !== undefined) {
                el.svgElem[el.visible ? 'show' : 'hide']();
                el.visible = !el.visible;
            }
        });
    });
}

$('.toggle-trigger').click(function () {
    var target = $(this).attr('data-target');

    $('#' + target).slideToggle('slow');

    if ($(this).hasClass('plus')) {
        $(this).addClass('minus').removeClass('plus');
    } else {
        $(this).addClass('plus').removeClass('minus');
    }
});