var hcageinf_female_3rd = [
    [0, 12.57095036],
    [0.5, 13.14201704],
    [1.5, 13.97098035],
    [2.5, 14.56122843],
    [3.5, 15.01226918],
    [4.5, 15.37252482],
    [5.5, 15.66914064],
    [6.5, 15.9188255],
    [7.5, 16.13257377],
    [8.5, 16.31799203],
    [9.5, 16.4805534],
    [10.5, 16.6243212],
    [11.5, 16.7523918],
    [12.5, 16.86717586],
    [13.5, 16.97058504],
    [14.5, 17.06415939],
    [15.5, 17.14915674],
    [16.5, 17.22661684],
    [17.5, 17.2974084],
    [18.5, 17.36226413],
    [19.5, 17.4218073],
    [20.5, 17.47657222],
    [21.5, 17.52702011],
    [22.5, 17.57355162],
    [23.5, 17.61651686],
    [24.5, 17.65622335],
    [25.5, 17.69294259],
    [26.5, 17.72691534],
    [27.5, 17.758356],
    [28.5, 17.78745627],
    [29.5, 17.81438815],
    [30.5, 17.83930653],
    [31.5, 17.86235131],
    [32.5, 17.88364924],
    [33.5, 17.90331542],
    [34.5, 17.92145494],
    [35.5, 17.93816352],
    [36, 17.94600891]

];
var hcageinf_female_5th = [
    [0, 12.69721103],
    [0.5, 13.26277687],
    [1.5, 14.08489094],
    [2.5, 14.67135431],
    [3.5, 15.12032701],
    [4.5, 15.47959019],
    [5.5, 15.77593734],
    [6.5, 16.02586479],
    [7.5, 16.24022959],
    [8.5, 16.42654499],
    [9.5, 16.59021805],
    [10.5, 16.73526415],
    [11.5, 16.86474363],
    [12.5, 16.98103974],
    [13.5, 17.0860429],
    [14.5, 17.18127642],
    [15.5, 17.26798486],
    [16.5, 17.34719727],
    [17.5, 17.41977371],
    [18.5, 17.48643984],
    [19.5, 17.54781314],
    [20.5, 17.60442315],
    [21.5, 17.65672712],
    [22.5, 17.70512243],
    [23.5, 17.74995644],
    [24.5, 17.79153438],
    [25.5, 17.83012583],
    [26.5, 17.86596994],
    [27.5, 17.89927977],
    [28.5, 17.93024588],
    [29.5, 17.95903934],
    [30.5, 17.98581422],
    [31.5, 18.01070978],
    [32.5, 18.03385221],
    [33.5, 18.05535618],
    [34.5, 18.07532632],
    [35.5, 18.0938581],
    [36, 18.10261222]

];

var hcageinf_female_10th = [
    [0, 12.89744211],
    [0.5, 13.45412483],
    [1.5, 14.26506948],
    [2.5, 14.84522649],
    [3.5, 15.29061332],
    [4.5, 15.64799301],
    [5.5, 15.94360083],
    [6.5, 16.19359635],
    [7.5, 16.40861946],
    [8.5, 16.59603602],
    [9.5, 16.76114906],
    [10.5, 16.90789857],
    [11.5, 17.03928846],
    [12.5, 17.15765912],
    [13.5, 17.26486777],
    [14.5, 17.36241174],
    [15.5, 17.4515149],
    [16.5, 17.53318975],
    [17.5, 17.60828294],
    [18.5, 17.67750918],
    [19.5, 17.74147701],
    [20.5, 17.80070855],
    [21.5, 17.85565492],
    [22.5, 17.90670839],
    [23.5, 17.95421204],
    [24.5, 17.99846753],
    [25.5, 18.03974142],
    [26.5, 18.07827033],
    [27.5, 18.11426516],
    [28.5, 18.14791466],
    [29.5, 18.17938838],
    [30.5, 18.2088391],
    [31.5, 18.23640495],
    [32.5, 18.26221122],
    [33.5, 18.28637185],
    [34.5, 18.30899069],
    [35.5, 18.3301627],
    [36, 18.34023363]

];

var hcageinf_female_25th = [
    [0, 13.24877311],
    [0.5, 13.78941058],
    [1.5, 14.57985656],
    [2.5, 15.14805209],
    [3.5, 15.58624856],
    [4.5, 15.93942132],
    [5.5, 16.23282663],
    [6.5, 16.48203455],
    [7.5, 16.69730547],
    [8.5, 16.88574848],
    [9.5, 17.05248581],
    [10.5, 17.20132663],
    [11.5, 17.33517731],
    [12.5, 17.45630424],
    [13.5, 17.56650754],
    [14.5, 17.66723973],
    [15.5, 17.75968915],
    [16.5, 17.84483981],
    [17.5, 17.92351525],
    [18.5, 17.99641132],
    [19.5, 18.06412104],
    [20.5, 18.12715366],
    [21.5, 18.1859496],
    [22.5, 18.24089212],
    [23.5, 18.29231674],
    [24.5, 18.34051873],
    [25.5, 18.38575921],
    [26.5, 18.42827015],
    [27.5, 18.46825851],
    [28.5, 18.50590965],
    [29.5, 18.54139017],
    [30.5, 18.57485034],
    [31.5, 18.60642614],
    [32.5, 18.63624095],
    [33.5, 18.66440715],
    [34.5, 18.69102705],
    [35.5, 18.71619447],
    [36, 18.72826063]

];

var hcageinf_female_50th = [
    [0, 13.66597655],
    [0.5, 14.18683394],
    [1.5, 14.95147259],
    [2.5, 15.5039951],
    [3.5, 15.93218865],
    [4.5, 16.2789104],
    [5.5, 16.56825725],
    [6.5, 16.81510201],
    [7.5, 17.02925676],
    [8.5, 17.21752759],
    [9.5, 17.38482371],
    [10.5, 17.5348],
    [11.5, 17.67024797],
    [12.5, 17.79334682],
    [13.5, 17.90582915],
    [14.5, 18.00909448],
    [15.5, 18.10428891],
    [16.5, 18.19236241],
    [17.5, 18.27411079],
    [18.5, 18.35020709],
    [19.5, 18.42122539],
    [20.5, 18.48765912],
    [21.5, 18.54993537],
    [22.5, 18.60842612],
    [23.5, 18.66345726],
    [24.5, 18.71531581],
    [25.5, 18.76425579],
    [26.5, 18.81050302],
    [27.5, 18.85425912],
    [28.5, 18.89570478],
    [29.5, 18.93500254],
    [30.5, 18.97229908],
    [31.5, 19.00772723],
    [32.5, 19.04140759],
    [33.5, 19.07345008],
    [34.5, 19.10395478],
    [35.5, 19.13301359],
    [36, 19.14702738]

];

var hcageinf_female_75th = [
    [0, 14.11466921],
    [0.5, 14.61342031],
    [1.5, 15.34856356],
    [2.5, 15.88247116],
    [3.5, 16.29816666],
    [4.5, 16.63624422],
    [5.5, 16.91956058],
    [6.5, 17.16224183],
    [7.5, 17.37361926],
    [8.5, 17.56017326],
    [9.5, 17.72658359],
    [10.5, 17.87633809],
    [11.5, 18.0121036],
    [12.5, 18.13596402],
    [13.5, 18.24957781],
    [14.5, 18.3542858],
    [15.5, 18.45118699],
    [16.5, 18.54119302],
    [17.5, 18.62506821],
    [18.5, 18.70345943],
    [19.5, 18.77691882],
    [20.5, 18.84592131],
    [21.5, 18.91087818],
    [22.5, 18.97214793],
    [23.5, 19.03004476],
    [24.5, 19.08484562],
    [25.5, 19.1367957],
    [26.5, 19.18611314],
    [27.5, 19.23299278],
    [28.5, 19.27760934],
    [29.5, 19.32012006],
    [30.5, 19.36066694],
    [31.5, 19.39937861],
    [32.5, 19.43637191],
    [33.5, 19.4717534],
    [34.5, 19.5056202],
    [35.5, 19.53806146],
    [36, 19.55377334]

];

var hcageinf_female_90th = [
    [0, 14.54862923],
    [0.5, 15.025225],
    [1.5, 15.73016016],
    [2.5, 16.24435141],
    [3.5, 16.64628028],
    [4.5, 16.97437572],
    [5.5, 17.25030318],
    [6.5, 17.48746849],
    [7.5, 17.69473676],
    [8.5, 17.87827074],
    [9.5, 18.04252502],
    [10.5, 18.19082207],
    [11.5, 18.32570444],
    [12.5, 18.44916025],
    [13.5, 18.56277273],
    [14.5, 18.66782265],
    [15.5, 18.76536031],
    [16.5, 18.85625744],
    [17.5, 18.9412452],
    [18.5, 19.02094272],
    [19.5, 19.09587868],
    [20.5, 19.16650798],
    [21.5, 19.2332248],
    [22.5, 19.2963728],
    [23.5, 19.35625336],
    [24.5, 19.41313217],
    [25.5, 19.46724461],
    [26.5, 19.51880017],
    [27.5, 19.56798601],
    [28.5, 19.61497006],
    [29.5, 19.65990351],
    [30.5, 19.70292296],
    [31.5, 19.74415219],
    [32.5, 19.78370372],
    [33.5, 19.82168012],
    [34.5, 19.85817511],
    [35.5, 19.8932746],
    [36, 19.91032592]

];

var hcageinf_female_95th = [
    [0, 14.82338486],
    [0.5, 15.28557931],
    [1.5, 15.97054858],
    [2.5, 16.47139558],
    [3.5, 16.8637715],
    [4.5, 17.18474976],
    [5.5, 17.45524591],
    [6.5, 17.68820977],
    [7.5, 17.89220929],
    [8.5, 18.07320329],
    [9.5, 18.23550073],
    [10.5, 18.3823162],
    [11.5, 18.51611063],
    [12.5, 18.63880871],
    [13.5, 18.7519435],
    [14.5, 18.85675541],
    [15.5, 18.95426185],
    [16.5, 19.04530736],
    [17.5, 19.13060047],
    [18.5, 19.2107412],
    [19.5, 19.28624206],
    [20.5, 19.35754407],
    [21.5, 19.42502947],
    [22.5, 19.48903159],
    [23.5, 19.54984282],
    [24.5, 19.60772097],
    [25.5, 19.6628945],
    [26.5, 19.71556677],
    [27.5, 19.76591956],
    [28.5, 19.81411598],
    [29.5, 19.86030293],
    [30.5, 19.90461318],
    [31.5, 19.94716707],
    [32.5, 19.98807402],
    [33.5, 20.02743378],
    [34.5, 20.06533766],
    [35.5, 20.10186921],
    [36, 20.1196446]

];

var hcageinf_female_97th = [
    [0, 15.00831626],
    [0.5, 15.4606607],
    [1.5, 16.13182928],
    [2.5, 16.6233218],
    [3.5, 17.00890822],
    [4.5, 17.32475723],
    [5.5, 17.5912815],
    [6.5, 17.82112349],
    [7.5, 18.02264971],
    [8.5, 18.20167998],
    [9.5, 18.3624234],
    [10.5, 18.50802016],
    [11.5, 18.64087462],
    [12.5, 18.76286731],
    [13.5, 18.87549618],
    [14.5, 18.97997329],
    [15.5, 19.07729286],
    [16.5, 19.16828023],
    [17.5, 19.25362787],
    [18.5, 19.33392224],
    [19.5, 19.4096643],
    [20.5, 19.48128521],
    [21.5, 19.54915869],
    [22.5, 19.61361067],
    [23.5, 19.67492711],
    [24.5, 19.73336019],
    [25.5, 19.78913341],
    [26.5, 19.84244575],
    [27.5, 19.89347512],
    [28.5, 19.94238117],
    [29.5, 19.98930774],
    [30.5, 20.03438485],
    [31.5, 20.07773036],
    [32.5, 20.11945149],
    [33.5, 20.15964595],
    [34.5, 20.19840332],
    [35.5, 20.23580548],
    [36, 20.25402213]

];

$(function chartSetup() {
    $('#container').highcharts({
        chart: {
            type: 'areaspline'
        },
        title: {
            text: 'Infant Head Circumference Growth Chart (Females)'
        },
        legend: {
            layout: 'horizontal',
            align: 'center',
            verticalAlign: 'bottom',
            borderWidth: 1,
            backgroundColor: '#FFFFFF',
            itemStyle: {
                cursor: 'pointer',
                color: '#274b6d',
                fontSize: '12px'
            }
        },
        plotOptions: {
            areaspline: {
                fillOpacity: 0.2
            },
            series: {
                minPointLength: 1,
                shadow: false,
                events: {
                    legendItemClick: function () {
                        if (this.name == 'Percentiles') {
                            toggleBands(chart);
                        }
                    }
                }
            }
        },
        xAxis: {
            title: {
                text: 'Age (months)'
            },
            labels: {
                rotation: -90
            }
        },
        yAxis: {
            title: {
                text: 'Head Circumference (inches)'
            },
            min: 12,
            max: 21
        },
        tooltip: {
            shared: true,
            valueSuffix: ' inches',
            valueDecimals: 2
        },
        credits: {
            enabled: false
        },
        series: [{
            name: '3rd Percentile',
            data: hcageinf_female_3rd,
            marker: {
                enabled: false
            }
        }, {
            name: '5th Percentile',
            data: hcageinf_female_5th,
            marker: {
                enabled: false
            }
        }, {
            name: '10th Percentile',
            data: hcageinf_female_10th,
            marker: {
                enabled: false
            }
        }, {
            name: '25th Percentile',
            data: hcageinf_female_25th,
            marker: {
                enabled: false
            }
        }, {
            name: '50th Percentile',
            data: hcageinf_female_50th,
            marker: {
                enabled: false
            }
        }, {
            name: '75th Percentile',
            data: hcageinf_female_75th,
            marker: {
                enabled: false
            }
        }, {
            name: '90th Percentile',
            data: hcageinf_female_90th,
            marker: {
                enabled: false
            }
        }, {
            name: '95th Percentile',
            data: hcageinf_female_95th,
            marker: {
                enabled: false
            }
        }, {
            name: '97th Percentile',
            data: hcageinf_female_97th,
            marker: {
                enabled: false
            }
        }]
    });
});

function toggleBands(chart) {
    $.each(chart.xAxis, function (index, elX) {
        $.each(elX.plotLinesAndBands, function (index, el) {
            if (el.svgElem !== undefined) {
                el.svgElem[el.visible ? 'show' : 'hide']();
                el.visible = !el.visible;
            }
        });
    });
}

$('.toggle-trigger').click(function () {
    var target = $(this).attr('data-target');

    $('#' + target).slideToggle('slow');

    if ($(this).hasClass('plus')) {
        $(this).addClass('minus').removeClass('plus');
    } else {
        $(this).addClass('plus').removeClass('minus');
    }
});