<%@page errorPage="/auth/exceptionHandler.jsp"%>

<%@page import="java.util.List"%>

<%@page import="edu.ncsu.csc.itrust.action.ViewMyMessagesAction"%>
<%@page import="edu.ncsu.csc.itrust.beans.MessageBean"%>
<%@page import="edu.ncsu.csc.itrust.dao.DAOFactory"%>
<%@ page import="edu.ncsu.csc.itrust.action.EditPersonnelAction" %>
<%@ page import="edu.ncsu.csc.itrust.dao.mysql.*" %>

<%@include file="/global.jsp" %>

<%
pageTitle = "iTrust - View My Message ";
session.setAttribute("outbox",false);
session.setAttribute("isHCP",userRole.equals("hcp"));
loggingAction.logEvent(TransactionType.INBOX_VIEW, loggedInMID.longValue(), 0L, "");
%>

<%@include file="/header.jsp" %>

<div align=center>
	<h2>My Messages</h2>

	<%
		loggingAction.logEvent(TransactionType.INBOX_VIEW, loggedInMID.longValue(), 0, "");
		ViewMyMessagesAction action = new ViewMyMessagesAction(prodDAO, loggedInMID.longValue());
		MessageFilterDAO messageFilterDAO = new MessageFilterDAO(prodDAO);
		boolean outbox=(Boolean)session.getAttribute("outbox");
		List<MessageBean> messages = outbox?action.getAllMySentMessages():action.getAllMyMessages();


		//Edit Filter backend
		boolean editing = false;
		String headerMessage = "";
		String[] fields = new String[6];
		if(request.getParameter("edit") != null && request.getParameter("edit").equals("true")) {
			editing = true;

			int i;
			for(i=0; i<6; i++) {
				fields[i] = "";
			}

			if(request.getParameter("cancel") != null)
				response.sendRedirect("messageInbox.jsp");
			else if(request.getParameter("test") != null || request.getParameter("save") != null) {
				boolean error = false;
				String nf = "";
				nf += request.getParameter("sender").replace(",","")+",";
				nf += request.getParameter("subject").replace(",","")+",";
				nf += request.getParameter("hasWords").replace(",","")+",";
				nf += request.getParameter("notWords").replace(",","")+",";
				nf += request.getParameter("startDate").replace(",","")+",";
				nf += request.getParameter("endDate");
				System.out.println(nf);
				//Validate Filter
				nf = action.validateAndCreateFilter(nf);
				if(nf.startsWith("Error")) {
					error = true;
					headerMessage = nf;
				}

				if(!error) {
					if(request.getParameter("test") != null) {
						response.sendRedirect("messageInbox.jsp?edit=true&testFilter="+nf);
					} else if(request.getParameter("save") != null) {
						messageFilterDAO.editMessageFilter(loggedInMID, nf);
						response.sendRedirect("messageInbox.jsp?filter=true");
					}
				}
			}

			if(request.getParameter("testFilter") != null) {
				String filter = request.getParameter("testFilter");
				String[] f = filter.split(",", -1);
				for(i=0; i<6; i++) {
					try {
						fields[i] = f[i];
					} catch(ArrayIndexOutOfBoundsException e) {
						//do nothing
					}
				}
			} else {
				String filter = messageFilterDAO.getMessageFilter(loggedInMID);
				if(!filter.equals("")) {
					String[] f = filter.split(",", -1);
					for(i=0; i<6; i++) {
						try {
							fields[i] = f[i];
						} catch(ArrayIndexOutOfBoundsException e) {
							//do nothing
						}
					}
				}
			}
		}

		//Filters Messages
		boolean is_filtered = false;
		if((request.getParameter("filter") != null && request.getParameter("filter").equals("true")) || request.getParameter("testFilter") != null) {
			String filter = "";
			if(request.getParameter("testFilter") != null) {
				filter = request.getParameter("testFilter");
			} else {
				filter = messageFilterDAO.getMessageFilter(loggedInMID);
			}
			if(!filter.equals("") && !filter.equals(",,,,,")) {
				List<MessageBean> filtered = action.filterMessages(messages, filter);
				messages = filtered;
				is_filtered = true;
			}
		}

		session.setAttribute("messages", messages);
	%>

	<%

		if(editing) {
	%>
	<div class="filterEdit">
		<div align="center">
			<span style="font-size: 13pt; font-weight: bold;">Edit Message Filter</span>
			<%= headerMessage.equals("") ? "" : "<br /><span class=\"iTrustMessage\">"+headerMessage+"</span><br /><br />" %>
			<form method="post" action="messageInbox.jsp?edit=true">
				<table>
					<tr style="text-align: right;">
						<td>
							<label for="sender">Sender: </label>
							<input type="text" name="sender" id="sender" value="<%= StringEscapeUtils.escapeHtml("" + (fields[0] )) %>" />
						</td>
						<td style="padding-left: 10px; padding-right: 10px;">
							<label for="hasWords">Has the words: </label>
							<input type="text" name="hasWords" id="hasWords" value="<%= StringEscapeUtils.escapeHtml("" + (fields[2] )) %>" />
						</td>
						<td>
							<label for="startDate">Start Date: </label>
							<input type="text" name="startDate" id="startDate" value="<%= StringEscapeUtils.escapeHtml("" + (fields[4] )) %>" />
							<input type="button" value="Select Date" onclick="displayDatePicker('startDate');" />
						</td>
					</tr>
					<tr style="text-align: right;">
						<td>
							<label for="subject">Subject: </label>
							<input type="text" name="subject" id="subject" value="<%= StringEscapeUtils.escapeHtml("" + (fields[1] )) %>" />
						</td>
						<td style="padding-left: 10px; padding-right: 10px;">
							<label for="notWords">Does not have the words: </label>
							<input type="text" name="notWords" id="notWords" value="<%= StringEscapeUtils.escapeHtml("" + (fields[3] )) %>" />
						</td>
						<td>
							<label for="endDate">End Date: </label>
							<input type="text" name="endDate" id="endDate" value="<%= StringEscapeUtils.escapeHtml("" + (fields[5] )) %>" />
							<input type="button" value="Select Date" onclick="displayDatePicker('endDate');" />
						</td>
					</tr>
					<tr style="text-align: center;">
						<td colspan="3">
							<input type="submit" name="test" value="Test Search" />
							<input type="submit" name="save" value="Save" />
							<input type="submit" name="cancel" value="Cancel" />
						</td>
					</tr>
				</table>
			</form>
		</div>
	</div>
	<br />
	<%
		}

	%>

	<form method="post" action="messageInbox.jsp<%= StringEscapeUtils.escapeHtml("" + (is_filtered?"?filter=true":"" )) %>">
		<table>
			<tr>
				<td><a href="messageInbox.jsp?edit=true" >Edit Filter</a></td>
				<td><a href="messageInbox.jsp?filter=true" >Apply Filter</a></td>
			</tr>
		</table>
	</form>
	<br />
	<%if(messages.size() > 0) { %>
	<table class="fancyTable">
		<tr>
			<th>Sender</th>
			<th>Subject</th>
			<th>Received</th>
			<th></th>
		</tr>
		<%		int index = 0;
			for(MessageBean message : messages) {
				if(message.getRead() == 0) {%>
		<tr style="font-weight: bold;" <%=(index%2 == 1)?"class=\"alt\"":"" %>>
			<td><%= StringEscapeUtils.escapeHtml("" + ( action.getName(message.getFrom()) )) %></td>
			<td><%= StringEscapeUtils.escapeHtml("" + ( message.getSubject() )) %></td>
			<td><%= StringEscapeUtils.escapeHtml("" + ( message.getSentDate() )) %></td>
			<td><a href="viewMessageInbox.jsp?msg=<%= StringEscapeUtils.escapeHtml("" + ( index )) %>">Read</a></td>
		</tr>
		<% 			   } else { %>
		<tr <%=(index%2 == 1)?"class=\"alt\"":"" %>>
			<td><%= StringEscapeUtils.escapeHtml("" + ( action.getName(message.getFrom()) )) %></td>
			<td><%= StringEscapeUtils.escapeHtml("" + ( message.getSubject() )) %></td>
			<td><%= StringEscapeUtils.escapeHtml("" + ( message.getSentDate() )) %></td>
			<td><a href="viewMessageInbox.jsp?msg=<%= StringEscapeUtils.escapeHtml("" + ( index )) %>">Read</a></td>
		</tr>
		<% 			  } %>
		<%			index ++; %>
		<%		} %>
	</table>
	<%	} else { %>
	<div>
		<i>You have no messages</i>
	</div>
	<%	} %>
	<br />
</div>

<%@include file="/footer.jsp" %>
