<%@page import="java.net.URLEncoder" %>
<%@page import="java.util.List"%>
<%@page import="edu.ncsu.csc.itrust.dao.DAOFactory"%>
<%@page import="edu.ncsu.csc.itrust.beans.DiagnosisBean"%>
<%@page import="edu.ncsu.csc.itrust.action.UpdateICDCodeListAction"%>
<%@page import="edu.ncsu.csc.itrust.exception.FormValidationException"%>
<%@page errorPage="/auth/exceptionHandler.jsp" %>

<%@include file="/global.jsp" %>

<%
pageTitle = "iTrust - Maintain ICD Codes";
%>

<%@include file="/header.jsp" %>

<%
String headerMessage = "Viewing Current ICD Codes";
	
UpdateICDCodeListAction icdUpdater = new UpdateICDCodeListAction(prodDAO, loggedInMID.longValue());

if (request.getParameter("add") != null || request.getParameter("update") != null) {
	try {
		DiagnosisBean diag = 
			new DiagnosisBean(request.getParameter("code"), request.getParameter("description"), request.getParameter("classification"),"", request.getParameter("ophthalmology"));
		headerMessage = (request.getParameter("add") != null)?icdUpdater.addICDCode(diag):icdUpdater.updateInformation(diag);
		
		if(!headerMessage.contains("Error")) {
			if (request.getParameter("add") != null) {
				loggingAction.logEvent(TransactionType.DIAGNOSIS_CODE_ADD, loggedInMID, 0, request.getParameter("code"));
				
			} else if (request.getParameter("update") != null) {
				loggingAction.logEvent(TransactionType.DIAGNOSIS_CODE_EDIT, loggedInMID, 0, request.getParameter("code"));
			}
		}
	} catch(FormValidationException e) {
%>
		<div align=center>
			<span class="iTrustError"><%=StringEscapeUtils.escapeHtml(e.getMessage()) %></span>
		</div>
<%
		headerMessage = "Validation Errors";
	}
	
} else {
	loggingAction.logEvent(TransactionType.DIAGNOSIS_CODE_VIEW, loggedInMID, 0, "");
}
String headerColor = (headerMessage.indexOf("Error") > -1) ? "#ffcccc" : "#00CCCC";
%>

<div align=center>
<form name="mainForm" method="post">
<input type="hidden" id="updateID" name="updateID" value="" />
<input type="hidden" id="oldDescrip" name="oldDescrip" value="" />
<script type="text/javascript">
	function fillUpdate(code) {
		document.getElementById("code").value = code;
		document.getElementById("description").value = unescape(document.getElementById("UPD" + code).value);
		if ("yes" == document.getElementById("CLASS"+code).value) {
			document.getElementById("classification").checked = "checked";
		}
		else {
			document.getElementById("classification").checked = "";
		}
		
	}
</script>

<br />

<span class="iTrustMessage"><%= StringEscapeUtils.escapeHtml("" + (headerMessage )) %></span>

<br />
<br />

<table class="fTable" align="center">
<tr>
	<th colspan="4">Update ICD Code List</th>
</tr>
<tr class="subHeader">
		<th>Code</th>
		<th>Chronic?</th>
		<th>Ophthalmology?</th>
		<th>Description</th>
</tr>
	<tr>
		<td><input type="text" name="code" id="code" size="8" maxlength="8" /></td>
		<td><input type="checkbox" name="classification" id="classification" value="yes" /></td>
		<td><input type="checkbox" name="ophthalmology" id="ophthalmology" value="yes" /></td>
		<td><input type="text" name="description" id="description" size="40" maxlength="100" /></td>
	</tr>
</table>
<br />
<input type="submit" name="add" value="Add Code" />
<input type="submit" name="update" value="Update Code" />
<br />
<br />

<table class="fTable" align="center">
	<tr>
		<th colspan="4">Current ICD Codes</th>
	</tr>
	<tr class="subHeader">
		<th>Code</th>
		<th>Chronic?</th>
		<th>Ophthalmology?</th>
		<th>Description</th>
	</tr>
<%
	List<DiagnosisBean> codeList = prodDAO.getICDCodesDAO().getAllCodes();
	String tempCode = "";
	String tempDescrip = "";
	String tempClass = "";
	String escapedDescrip = "";
	String opth = "no";
	for (DiagnosisBean codeEntry : codeList) {
		tempCode = codeEntry.getICDCode() + "";
		tempDescrip = codeEntry.getDescription();
		tempClass = codeEntry.getClassification();
		opth = codeEntry.getOphthalmology();
		escapedDescrip = URLEncoder.encode(tempDescrip, "UTF-8").replaceAll("\\+", "%20");
%>
<tr>
	<td align="center"><%= StringEscapeUtils.escapeHtml("" + (tempCode)) %></td>
	<td align="center"><%= StringEscapeUtils.escapeHtml("" + (tempClass)) %></td>
	<td align="center"><%= StringEscapeUtils.escapeHtml("" + (opth)) %></td>
	<td align="center">
		<a href="javascript:void(0)" onclick="fillUpdate('<%= StringEscapeUtils.escapeHtml("" + (tempCode )) %>')"><%= StringEscapeUtils.escapeHtml("" + (tempDescrip)) %></a>
		<input type="hidden" id="UPD<%= StringEscapeUtils.escapeHtml("" + (tempCode)) %>" name="UPD<%= StringEscapeUtils.escapeHtml("" + (tempCode)) %>" value="<%=escapedDescrip%>" />
		<input type="hidden" id="CLASS<%= StringEscapeUtils.escapeHtml("" + (tempCode)) %>" name="CLASS<%= StringEscapeUtils.escapeHtml("" + (tempCode)) %>" value="<%=tempClass%>" />
	</td>
</tr>

<% } %>

</table>
</form>
</div>
<br />


<%@include file="/footer.jsp" %>
