/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;

public class ImageHelper {
    private static final Component comp = new Component(){};
    private static final MediaTracker tracker = new MediaTracker(comp);

    private ImageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image loadImage(String fileName) {
        Image image = Toolkit.getDefaultToolkit().getImage(fileName);
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.err.println("ImageHelper.loadImage: INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return image;
    }

    public static BufferedImage loadBufferedImage(String fileName) {
        Image image = ImageHelper.loadImage(fileName);
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int width = (int)Math.max(1.0, (double)image.getWidth(null));
        int height = (int)Math.max(1.0, (double)image.getHeight(null));
        BufferedImage bimage = new BufferedImage(width, height, 1);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ColorModel cm = pg.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.hasAlpha();
    }

    public static BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }
}

