/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.util;

import java.util.HashMap;
import java.util.Map;

public class Expr {
    static final int MULT = 1;
    static final int DIVIDED = 2;
    static final int PLUS = 3;
    static final int MINUS = 4;
    static final int LBRAK = 5;
    static final int RBRAK = 6;
    static final int POW = 7;
    static final int NUMBER = 8;
    static final int SIN = 9;
    static final int COS = 10;
    static final int EXP = 11;
    static final int LN = 12;
    static final int ATAN = 13;
    static final int SQRT = 14;
    static final int LAST = 15;
    static final int COND = 16;
    static final int COMMA = 17;
    static final int LT = 18;
    static final int GT = 19;
    static final int EQ = 20;
    static final int NE = 21;
    static final int LE = 22;
    static final int GE = 23;
    static final int MOD = 24;
    static final int MIN = 25;
    static final int MAX = 26;
    static final int ASIN = 27;
    static final int ACOS = 28;
    static final int TAN = 29;
    static final int AND = 30;
    static final int OR = 31;
    static final int NOT = 32;
    char c;
    String str;
    String ident;
    Map vars;
    double num;
    int i;
    int token;
    static String[] tests = new String[]{"not(0.0)", "1.0", "not(1.0)", "0.0", "and(0.0,0.0)", "0.0", "and(0.0,1.0)", "0.0", "and(1.0,0.0)", "0.0", "and(1.0,0.0,1.0)", "0.0", "and(1.0,1.0)", "1.0", "and(1.0,1.0,1.0)", "1.0", "or(0.0,0.0)", "0.0", "or(0.0,0.0,0.0)", "0.0", "or(0.0,1.0)", "1.0", "or(1.0,0.0)", "1.0", "or(1.0,1.0)", "1.0", "or(1.0,1.0,0.0)", "1.0", "cond(1.0<0.0,37,85)", "85.0", "cond(1.0>=0.0,37,85)", "37.0", "and(5>3,6>2)", "1.0", "and(5>3,6<2)", "0.0"};

    void getIdent() {
        this.ident = "";
        do {
            this.ident = this.ident + String.valueOf(this.c);
            if (++this.i >= this.str.length()) continue;
            this.c = this.str.charAt(this.i);
        } while (this.i < this.str.length() && Character.isLetter(this.c));
    }

    int getCompOp() {
        char c1 = this.c;
        char c2 = ' ';
        if (++this.i < this.str.length()) {
            this.c = this.str.charAt(this.i);
        }
        c2 = this.c;
        if ((this.c == '=' || this.c == '<' || this.c == '>') && ++this.i < this.str.length()) {
            this.c = this.str.charAt(this.i);
        }
        if (c1 == '<' && c2 == '=') {
            return 22;
        }
        if (c1 == '>' && c2 == '=') {
            return 23;
        }
        if (c1 == '=') {
            return 20;
        }
        if (c1 == '<' && c2 == '>') {
            return 21;
        }
        if (c1 == '<') {
            return 18;
        }
        if (c1 == '>') {
            return 19;
        }
        throw new RuntimeException("unknown operator: " + c1 + c2);
    }

    double getNum() throws NumberFormatException {
        StringBuffer s = new StringBuffer("");
        do {
            s.append(String.valueOf(this.c));
            if (++this.i >= this.str.length()) continue;
            this.c = this.str.charAt(this.i);
        } while (this.i < this.str.length() && (Character.isDigit(this.c) || this.c == '.'));
        return Double.valueOf(s.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getTok() {
        while (this.i < this.str.length() && this.c == ' ') {
            if (++this.i >= this.str.length()) continue;
            this.c = this.str.charAt(this.i);
        }
        if (this.i == this.str.length()) {
            return 15;
        }
        if (Character.isDigit(this.c) || this.c == '.') {
            this.num = this.getNum();
            return 8;
        }
        if (this.c == '<') return this.getCompOp();
        if (this.c == '=') return this.getCompOp();
        if (this.c == '>') {
            return this.getCompOp();
        }
        if (Character.isLetter(Character.toUpperCase(this.c))) {
            this.getIdent();
            Double obj = (Double)this.vars.get(this.ident.toLowerCase());
            if (obj != null) {
                this.num = obj;
                return 8;
            }
            if (this.ident.equalsIgnoreCase("PI")) {
                this.num = Math.PI;
                return 8;
            }
            if (this.ident.equalsIgnoreCase("E")) {
                this.num = Math.E;
                return 8;
            }
            if (this.ident.equalsIgnoreCase("SIN")) {
                return 9;
            }
            if (this.ident.equalsIgnoreCase("COS")) {
                return 10;
            }
            if (this.ident.equalsIgnoreCase("TAN")) {
                return 29;
            }
            if (this.ident.equalsIgnoreCase("EXP")) {
                return 11;
            }
            if (this.ident.equalsIgnoreCase("LN")) {
                return 12;
            }
            if (this.ident.equalsIgnoreCase("ASIN")) {
                return 27;
            }
            if (this.ident.equalsIgnoreCase("ACOS")) {
                return 28;
            }
            if (this.ident.equalsIgnoreCase("ATAN")) {
                return 13;
            }
            if (this.ident.equalsIgnoreCase("SQRT")) {
                return 14;
            }
            if (this.ident.equalsIgnoreCase("COND")) {
                return 16;
            }
            if (this.ident.equalsIgnoreCase("MIN")) {
                return 25;
            }
            if (this.ident.equalsIgnoreCase("MAX")) {
                return 26;
            }
            if (this.ident.equalsIgnoreCase("AND")) {
                return 30;
            }
            if (this.ident.equalsIgnoreCase("OR")) {
                return 31;
            }
            if (!this.ident.equalsIgnoreCase("NOT")) throw new RuntimeException("unknown ident: " + this.ident);
            return 32;
        }
        switch (this.c) {
            case '*': {
                int t = 1;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case '/': {
                int t = 2;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case '%': {
                int t = 24;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case '+': {
                int t = 3;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case '-': {
                int t = 4;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case '(': {
                int t = 5;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case ')': {
                int t = 6;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case ',': {
                int t = 17;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            case '^': {
                int t = 7;
                if (++this.i >= this.str.length()) return t;
                this.c = this.str.charAt(this.i);
                return t;
            }
            default: {
                throw new RuntimeException("unknown char: " + this.c);
            }
        }
    }

    void eat(int expectedToken) {
        if (this.token != expectedToken) {
            throw new RuntimeException("expected: " + expectedToken + " but got: " + this.token);
        }
        this.token = this.getTok();
    }

    double primary() {
        double p = 0.0;
        double first = 0.0;
        double second = 0.0;
        double cond = 0.0;
        switch (this.token) {
            case 8: {
                p = this.num;
                this.token = this.getTok();
                break;
            }
            case 9: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.sin(this.expr());
                this.eat(6);
                break;
            }
            case 10: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.cos(this.expr());
                this.eat(6);
                break;
            }
            case 29: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.tan(this.expr());
                this.eat(6);
                break;
            }
            case 11: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.exp(this.expr());
                this.eat(6);
                break;
            }
            case 12: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.log(this.expr());
                this.eat(6);
                break;
            }
            case 27: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.asin(this.expr());
                this.eat(6);
                break;
            }
            case 28: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.acos(this.expr());
                this.eat(6);
                break;
            }
            case 13: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.atan(this.expr());
                this.eat(6);
                break;
            }
            case 14: {
                this.token = this.getTok();
                this.eat(5);
                p = Math.sqrt(this.expr());
                this.eat(6);
                break;
            }
            case 32: {
                this.token = this.getTok();
                this.eat(5);
                p = this.notFalse(this.compExpr()) ? 0.0 : 1.0;
                this.eat(6);
                break;
            }
            case 30: {
                this.token = this.getTok();
                this.eat(5);
                double d = first = this.notFalse(this.compExpr()) ? 1.0 : 0.0;
                while (this.token == 17) {
                    this.eat(17);
                    if (this.notFalse(this.compExpr())) continue;
                    first = 0.0;
                }
                this.eat(6);
                p = this.notFalse(first) ? 1.0 : 0.0;
                break;
            }
            case 31: {
                this.token = this.getTok();
                this.eat(5);
                double d = first = this.notFalse(this.compExpr()) ? 1.0 : 0.0;
                while (this.token == 17) {
                    this.eat(17);
                    if (!this.notFalse(this.compExpr())) continue;
                    first = 1.0;
                }
                this.eat(6);
                p = this.notFalse(first) ? 1.0 : 0.0;
                break;
            }
            case 16: {
                this.token = this.getTok();
                this.eat(5);
                cond = this.compExpr();
                this.eat(17);
                first = this.expr();
                this.eat(17);
                second = this.expr();
                this.eat(6);
                p = this.notFalse(cond) ? first : second;
                break;
            }
            case 25: {
                this.token = this.getTok();
                this.eat(5);
                first = second = this.expr();
                while (this.token == 17) {
                    this.eat(17);
                    second = this.expr();
                    if (!(second < first)) continue;
                    first = second;
                }
                this.eat(6);
                p = first < second ? first : second;
                break;
            }
            case 26: {
                this.token = this.getTok();
                this.eat(5);
                first = second = this.expr();
                while (this.token == 17) {
                    this.eat(17);
                    second = this.expr();
                    if (!(second > first)) continue;
                    first = second;
                }
                this.eat(6);
                p = first > second ? first : second;
                break;
            }
            case 5: {
                this.token = this.getTok();
                p = this.expr();
                this.eat(6);
                break;
            }
            default: {
                throw new RuntimeException("unexpected token: " + this.token);
            }
        }
        return p;
    }

    boolean notFalse(double arg) {
        return Math.abs(arg) >= 1.0E-6;
    }

    double factor() {
        double f = this.primary();
        while (this.token == 7) {
            this.token = this.getTok();
            f = Math.exp(this.factor() * Math.log(f));
        }
        return f;
    }

    double term() {
        double f = this.factor();
        while (this.token == 1 || this.token == 2 || this.token == 24) {
            if (this.token == 1) {
                this.token = this.getTok();
                f *= this.factor();
                continue;
            }
            if (this.token == 2) {
                this.token = this.getTok();
                f /= this.factor();
                continue;
            }
            this.token = this.getTok();
            f %= this.factor();
        }
        return f;
    }

    double expr() {
        double t;
        if (this.token == 3) {
            this.token = this.getTok();
            t = this.term();
        } else if (this.token == 4) {
            this.token = this.getTok();
            t = -this.term();
        } else {
            t = this.term();
        }
        while (this.token == 3 || this.token == 4) {
            if (this.token == 3) {
                this.token = this.getTok();
                t += this.term();
                continue;
            }
            this.token = this.getTok();
            t -= this.term();
        }
        return t;
    }

    double compExpr() {
        double t1 = this.expr();
        int compToken = this.token;
        switch (compToken) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return t1;
            }
        }
        this.token = this.getTok();
        double t2 = this.expr();
        switch (compToken) {
            case 22: {
                return t1 <= t2 ? 1.0 : 0.0;
            }
            case 18: {
                return t1 < t2 ? 1.0 : 0.0;
            }
            case 20: {
                return t1 == t2 ? 1.0 : 0.0;
            }
            case 21: {
                return t1 != t2 ? 1.0 : 0.0;
            }
            case 23: {
                return t1 >= t2 ? 1.0 : 0.0;
            }
            case 19: {
                return t1 > t2 ? 1.0 : 0.0;
            }
        }
        return t1;
    }

    public static double eval(String s, Map vars) {
        Expr self = new Expr();
        self.str = s;
        self.ident = "";
        self.i = -1;
        self.c = (char)32;
        self.vars = vars == null ? new HashMap() : vars;
        self.token = self.getTok();
        if (self.token != 15) {
            return self.expr();
        }
        return 0.0;
    }

    public static void main(String[] args) {
        int narg = args.length;
        if (narg == 0) {
            for (int i = 0; i < tests.length; i += 2) {
                if (!tests[i + 1].equals(new Double(Expr.eval(tests[i], null)).toString())) {
                    System.out.println(tests[i] + " should be " + tests[i + 1] + " but is " + new Double(Expr.eval(tests[i], null)).toString());
                    continue;
                }
                System.out.println(tests[i] + " : OK");
            }
            System.out.println("Usage: java Expr expression var-name var-value ...");
        } else {
            HashMap<String, Double> vars = new HashMap<String, Double>();
            try {
                for (int i = 1; i < narg; i += 2) {
                    vars.put(args[i].toLowerCase(), Double.valueOf(args[i + 1]));
                }
            }
            catch (Exception ex) {
                System.out.println("Problem reading the input parameters");
            }
            System.out.print(args[0] + " (" + ((Object)vars).toString() + ") = " + Expr.eval(args[0], vars));
        }
    }
}

