/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.util;

import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.jfree.data.general.Dataset;

public class PageUtils {
    private static final String TOOLTIPS_ENABLED_ATTR = PageUtils.class.getName() + ".ttenabled";

    private PageUtils() {
    }

    public static ChartHolder getChartHolder(String chartId, PageContext ctx) {
        return (ChartHolder)ctx.getAttribute(chartId, 1);
    }

    public static final ChartHolder getChartHolder(Tag tag, PageContext ctx) {
        CewolfRootTag root = PageUtils.findRoot(tag, ctx);
        if (root instanceof ChartHolder) {
            return (ChartHolder)((Object)root);
        }
        return PageUtils.getChartHolder(root.getChartId(), ctx);
    }

    public static final Dataset getDataset(String chartId, PageContext ctx) throws DatasetProduceException {
        return PageUtils.getChartHolder(chartId, ctx).getDataset();
    }

    public static final CewolfRootTag findRoot(Tag t, PageContext ctx) {
        Tag res = t;
        while (!(res instanceof CewolfRootTag)) {
            res = res.getParent();
        }
        return (CewolfRootTag)res;
    }

    public static final void setToolTipsEnabled(PageContext ctx) {
        if (!PageUtils.isToolTipsEnabled(ctx)) {
            ctx.setAttribute(TOOLTIPS_ENABLED_ATTR, (Object)"true", 1);
        }
    }

    public static final boolean isToolTipsEnabled(PageContext ctx) {
        return ctx.getAttribute(TOOLTIPS_ENABLED_ATTR, 1) != null;
    }
}

