/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.util.ImageHelper;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Serializable;

public class SerializableTexturePaint
implements Paint,
Serializable {
    static final long serialVersionUID = 3377875007493302352L;
    private String image;
    private int width;
    private int height;
    private transient Paint paint = null;

    public SerializableTexturePaint() {
    }

    public SerializableTexturePaint(String image, int width, int height) {
        this.image = image;
        this.width = width;
        this.height = height;
    }

    private Paint getPaint() {
        if (this.paint == null) {
            this.createPaint();
        }
        return this.paint;
    }

    private void createPaint() {
        BufferedImage bim = ImageHelper.loadBufferedImage(this.image);
        Rectangle rect = new Rectangle(this.width, this.height);
        this.paint = new TexturePaint(bim, rect);
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        return this.getPaint().createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    public int getTransparency() {
        return this.getPaint().getTransparency();
    }
}

