/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.NonSerializableChartPostProcessor;
import de.laures.cewolf.taglib.tags.CewolfBodyTag;
import de.laures.cewolf.taglib.tags.Painted;
import de.laures.cewolf.taglib.util.ColorHelper;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;

public class ColorTag
extends CewolfBodyTag
implements ChartPostProcessor,
NonSerializableChartPostProcessor {
    static final long serialVersionUID = -4882939573657296673L;
    private SerializableColorTag serTag = new SerializableColorTag();

    public int doEndTag() {
        ((Painted)this.getParent()).setPaint(this.serTag.getColor());
        return this.doAfterEndTag(6);
    }

    protected void reset() {
    }

    public void setColor(String s) {
        this.serTag.setColor(s);
    }

    protected Color getColor() {
        return this.serTag.getColor();
    }

    public void processChart(Object chart, Map args) {
        this.serTag.processChart((JFreeChart)chart, args);
    }

    public ChartPostProcessor getSerializablePostProcessor() {
        return this.serTag;
    }

    private class SerializableColorTag
    implements ChartPostProcessor,
    Serializable {
        static final long serialVersionUID = -7400971583172945660L;
        private Color color = Color.white;

        private SerializableColorTag() {
        }

        public void setColor(String s) {
            this.color = ColorHelper.getColor(s);
        }

        protected Color getColor() {
            return this.color;
        }

        public void processChart(Object chart, Map args) {
            ((JFreeChart)chart).setBackgroundPaint((Paint)this.color);
        }
    }
}

