/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.links.CategoryItemLinkGenerator;
import de.laures.cewolf.links.LinkGenerator;
import de.laures.cewolf.links.PieSectionLinkGenerator;
import de.laures.cewolf.links.XYItemLinkGenerator;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import de.laures.cewolf.taglib.tags.CewolfTag;
import de.laures.cewolf.taglib.tags.ChartImgTag;
import de.laures.cewolf.taglib.tags.Mapped;
import de.laures.cewolf.taglib.util.BrowserDetection;
import de.laures.cewolf.taglib.util.PageUtils;
import de.laures.cewolf.tooltips.CategoryToolTipGenerator;
import de.laures.cewolf.tooltips.PieToolTipGenerator;
import de.laures.cewolf.tooltips.ToolTipGenerator;
import de.laures.cewolf.tooltips.XYToolTipGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class ChartMapTag
extends CewolfTag {
    private static final long serialVersionUID = -3742340487378471159L;
    private static final String MAP_TAGNAME = "map";
    private static final String AREA_TAGNAME = "area";
    private static final String COORD_ATTRIBUTE = "coords";
    private static final String SHAPE_ATTRIBUTE = "shape";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TARGET_ATTRIBUTE = "target";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String MOUSEOVER_METHOD = "onmouseover";
    private static final String MOUSEOUT_METHOD = "onmouseout";
    private static final String ALT_ATTRIBUTE = "alt";
    private static final String TITLE_ATTRIBUTE = "title";
    ToolTipGenerator toolTipGenerator = null;
    LinkGenerator linkGenerator = null;
    String target = null;
    boolean useJFreeChartLinkGenerator = false;
    boolean useJFreeChartTooltipGenerator = false;

    public int doStartTag() throws JspException {
        Mapped root = (Mapped)((Object)PageUtils.findRoot((Tag)this, this.pageContext));
        root.enableMapping();
        String chartId = ((CewolfRootTag)((Object)root)).getChartId();
        try {
            Dataset dataset = PageUtils.getDataset(chartId, this.pageContext);
            JspWriter out = this.pageContext.getOut();
            boolean isIE = BrowserDetection.isIE((HttpServletRequest)this.pageContext.getRequest());
            if (this.hasToolTips()) {
                this.enableToolTips((Writer)out, isIE);
            }
            String mapTagContent = "<map";
            mapTagContent = mapTagContent + " name=\"" + chartId + "\"";
            mapTagContent = mapTagContent + " id=\"" + chartId + "\"";
            mapTagContent = mapTagContent + " >";
            out.write(mapTagContent);
            ChartRenderingInfo info = root.getRenderingInfo();
            Iterator entities = info.getEntityCollection().iterator();
            StringBuffer sb = new StringBuffer(200);
            while (entities.hasNext()) {
                boolean altAttrbInserted = false;
                boolean hasContent = false;
                ChartEntity ce = (ChartEntity)entities.next();
                sb.append("\n<area shape=\"" + ce.getShapeType() + "\" ");
                sb.append("coords=\"" + ce.getShapeCoords() + "\" ");
                if (ce instanceof XYItemEntity) {
                    dataset = ((XYItemEntity)ce).getDataset();
                }
                if (!(ce instanceof LegendItemEntity)) {
                    if (this.hasToolTips()) {
                        if (this.writeOutToolTip(dataset, sb, isIE, ce)) {
                            hasContent = true;
                        }
                        altAttrbInserted = true;
                    }
                    if (this.hasLinks() && this.writeOutLink(this.linkGenerator, dataset, sb, ce)) {
                        hasContent = true;
                    }
                }
                if (!altAttrbInserted) {
                    sb.append(" alt=\"\"");
                }
                sb.append(" />");
                if (hasContent) {
                    out.write(sb.toString());
                }
                sb.setLength(0);
            }
        }
        catch (IOException ioex) {
            System.err.println("ChartMapTag.doStartTag: " + ioex.getMessage());
            throw new JspException(ioex.getMessage());
        }
        catch (CewolfException cwex) {
            System.err.println("ChartMapTag.doStartTag: " + cwex.getMessage());
            throw new JspException(cwex.getMessage());
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("\n</map>");
        }
        catch (IOException ioex) {
            System.err.println("ChartMapTag.doEndTag: " + ioex.getMessage());
            throw new JspException(ioex.getMessage());
        }
        return this.doAfterEndTag(6);
    }

    public void reset() {
        this.toolTipGenerator = null;
        this.linkGenerator = null;
    }

    private boolean writeOutLink(Object linkGen, Dataset dataset, StringBuffer sb, ChartEntity ce) throws IOException {
        String link = this.generateLink(dataset, ce);
        if (null != link) {
            String href = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(link);
            sb.append("href=\"" + href + "\"");
            if (this.target != null) {
                sb.append(" target=\"" + this.target + "\"");
            }
            return true;
        }
        return false;
    }

    private boolean writeOutToolTip(Dataset dataset, StringBuffer sb, boolean isIE, ChartEntity ce) throws IOException, JspException {
        String toolTip = this.generateToolTip(dataset, ce);
        boolean altAttributeInserted = false;
        boolean hasContent = false;
        if (null != toolTip) {
            hasContent = true;
            if (!isIE) {
                sb.append(" onmouseover=\"return overlib('" + toolTip + "', width, '20');\" " + MOUSEOUT_METHOD + "=\"return nd();\" ");
            } else {
                sb.append("alt=\"" + toolTip + "\" ");
                sb.append("title=\"" + toolTip + "\" ");
                altAttributeInserted = true;
            }
        }
        if (!altAttributeInserted) {
            sb.append(" alt=\"\" ");
        }
        return hasContent;
    }

    public void enableToolTips(Writer out, boolean isIE) throws IOException {
        if (!PageUtils.isToolTipsEnabled(this.pageContext) && !isIE) {
            Configuration config = Configuration.getInstance(this.pageContext.getServletContext());
            String overLibURL = ChartImgTag.fixAbsolutURL(config.getOverlibURL(), this.pageContext);
            out.write("<script type=\"text/javascript\" language=\"JavaScript\" src=\"");
            out.write(overLibURL + "\"></script>\n");
            out.write("<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>\n");
            PageUtils.setToolTipsEnabled(this.pageContext);
        }
    }

    private String generateLink(Dataset dataset, ChartEntity ce) {
        String link = null;
        if (this.useJFreeChartLinkGenerator) {
            link = ce.getURLText();
        } else if (this.linkGenerator instanceof CategoryItemLinkGenerator || this.linkGenerator instanceof XYItemLinkGenerator || this.linkGenerator instanceof PieSectionLinkGenerator) {
            if (this.linkGenerator instanceof CategoryItemLinkGenerator && ce instanceof CategoryItemEntity) {
                CategoryItemEntity catEnt = (CategoryItemEntity)ce;
                link = ((CategoryItemLinkGenerator)this.linkGenerator).generateLink(dataset, catEnt.getSeries(), catEnt.getCategory());
            }
            if (this.linkGenerator instanceof XYItemLinkGenerator && ce instanceof XYItemEntity) {
                XYItemEntity xyEnt = (XYItemEntity)ce;
                link = ((XYItemLinkGenerator)this.linkGenerator).generateLink(dataset, xyEnt.getSeriesIndex(), xyEnt.getItem());
            }
            if (this.linkGenerator instanceof PieSectionLinkGenerator && ce instanceof PieSectionEntity) {
                PieSectionEntity pieEnt = (PieSectionEntity)ce;
                link = ((PieSectionLinkGenerator)this.linkGenerator).generateLink(dataset, pieEnt.getSectionKey());
            }
        }
        return link;
    }

    private String generateToolTip(Dataset dataset, ChartEntity ce) throws JspException {
        String tooltip = null;
        if (this.useJFreeChartTooltipGenerator) {
            tooltip = ce.getToolTipText();
        } else if (this.toolTipGenerator instanceof CategoryToolTipGenerator || this.toolTipGenerator instanceof XYToolTipGenerator || this.toolTipGenerator instanceof PieToolTipGenerator) {
            if (this.toolTipGenerator instanceof CategoryToolTipGenerator && ce instanceof CategoryItemEntity) {
                CategoryItemEntity catEnt = (CategoryItemEntity)ce;
                tooltip = ((CategoryToolTipGenerator)this.toolTipGenerator).generateToolTip((CategoryDataset)dataset, catEnt.getSeries(), catEnt.getCategoryIndex());
            }
            if (this.toolTipGenerator instanceof XYToolTipGenerator && ce instanceof XYItemEntity) {
                XYItemEntity xyEnt = (XYItemEntity)ce;
                tooltip = ((XYToolTipGenerator)this.toolTipGenerator).generateToolTip((XYDataset)dataset, xyEnt.getSeriesIndex(), xyEnt.getItem());
            }
            if (this.toolTipGenerator instanceof PieToolTipGenerator && ce instanceof PieSectionEntity) {
                PieSectionEntity pieEnt = (PieSectionEntity)ce;
                PieDataset ds = (PieDataset)dataset;
                int index = pieEnt.getSectionIndex();
                tooltip = ((PieToolTipGenerator)this.toolTipGenerator).generateToolTip(ds, ds.getKey(index), index);
            }
        } else {
            throw new JspException("TooltipgGenerator of class " + this.toolTipGenerator.getClass().getName() + " does not implement the appropriate TooltipGenerator interface for entity type " + ce.getClass().getName());
        }
        return tooltip;
    }

    private boolean hasToolTips() throws JspException {
        if (this.toolTipGenerator != null && this.useJFreeChartTooltipGenerator) {
            throw new JspException("Can't have both tooltipGenerator and useJFreeChartTooltipGenerator parameters specified!");
        }
        return this.toolTipGenerator != null || this.useJFreeChartTooltipGenerator;
    }

    public void setTooltipgeneratorid(String id) {
        this.toolTipGenerator = (ToolTipGenerator)this.pageContext.findAttribute(id);
    }

    private boolean hasLinks() throws JspException {
        if (this.linkGenerator != null && this.useJFreeChartLinkGenerator) {
            throw new JspException("Can't have both linkGenerator and useJFreeChartLinkGenerator parameters specified!");
        }
        return this.linkGenerator != null || this.useJFreeChartLinkGenerator;
    }

    public void setLinkgeneratorid(String id) {
        this.linkGenerator = (LinkGenerator)this.pageContext.findAttribute(id);
    }

    public void setUseJFreeChartLinkGenerator(boolean useJFreeChartLinkGenerator) {
        this.useJFreeChartLinkGenerator = useJFreeChartLinkGenerator;
    }

    public void setUseJFreeChartTooltipGenerator(boolean useJFreeChartTooltipGenerator) {
        this.useJFreeChartTooltipGenerator = useJFreeChartTooltipGenerator;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

