/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.html;

import de.laures.cewolf.taglib.tags.CewolfBodyTag;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public abstract class AbstractHTMLBaseTag
extends CewolfBodyTag {
    protected static final int UNDEFINED_INT = -1;
    protected static final float UNDEFINED_FLOAT = -1.0f;
    protected static final String UNDEFINED_STR = null;
    protected String clazz = UNDEFINED_STR;
    protected String style = UNDEFINED_STR;
    protected String title = UNDEFINED_STR;
    protected String lang = UNDEFINED_STR;
    protected String dir = UNDEFINED_STR;
    protected String onclick = UNDEFINED_STR;
    protected String ondblclick = UNDEFINED_STR;
    protected String onmousedown = UNDEFINED_STR;
    protected String onmouseup = UNDEFINED_STR;
    protected String onmouseover = UNDEFINED_STR;
    protected String onmousemove = UNDEFINED_STR;
    protected String onmouseout = UNDEFINED_STR;
    protected String onkeypress = UNDEFINED_STR;
    protected String onkeydown = UNDEFINED_STR;
    protected String onkeyup = UNDEFINED_STR;

    public AbstractHTMLBaseTag() {
        this.setId(UNDEFINED_STR);
    }

    protected abstract String getTagName();

    protected abstract boolean hasBody();

    protected abstract boolean isWellFormed();

    protected void reset() {
        this.clazz = UNDEFINED_STR;
        this.dir = UNDEFINED_STR;
        this.id = UNDEFINED_STR;
        this.lang = UNDEFINED_STR;
        this.onclick = UNDEFINED_STR;
        this.ondblclick = UNDEFINED_STR;
        this.onkeydown = UNDEFINED_STR;
        this.onkeypress = UNDEFINED_STR;
        this.onkeyup = UNDEFINED_STR;
        this.onmousedown = UNDEFINED_STR;
        this.onmousemove = UNDEFINED_STR;
        this.onmouseout = UNDEFINED_STR;
        this.onmouseover = UNDEFINED_STR;
        this.onmouseup = UNDEFINED_STR;
        this.style = UNDEFINED_STR;
        this.title = UNDEFINED_STR;
    }

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.write("<" + this.getTagName().toLowerCase());
            this.writeAttributes((Writer)writer);
            if (this.hasBody()) {
                writer.write(">");
                return 6;
            }
            return 0;
        }
        catch (IOException ioe) {
            this.pageContext.getServletContext().log("", (Throwable)ioe);
            throw new JspException(ioe.getMessage());
        }
    }

    public int doEndTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            if (this.hasBody()) {
                writer.write("</" + this.getTagName().toLowerCase() + ">");
            } else {
                if (this.isWellFormed()) {
                    writer.write(" /");
                }
                writer.write(">");
            }
            return this.doAfterEndTag(6);
        }
        catch (IOException ioe) {
            this.pageContext.getServletContext().log("", (Throwable)ioe);
            throw new JspException(ioe.getMessage());
        }
    }

    public void writeAttributes(Writer wr) {
        try {
            this.appendAttributeDeclaration(wr, this.getId(), "id");
            this.appendAttributeDeclaration(wr, this.clazz, "class");
            this.appendAttributeDeclaration(wr, this.style, "style");
            this.appendAttributeDeclaration(wr, this.onclick, "onclick");
            this.appendAttributeDeclaration(wr, this.ondblclick, "ondblclick");
            this.appendAttributeDeclaration(wr, this.onkeydown, "onkeydown");
            this.appendAttributeDeclaration(wr, this.onkeypress, "onkeypress");
            this.appendAttributeDeclaration(wr, this.onkeyup, "onkeyup");
            this.appendAttributeDeclaration(wr, this.onmousedown, "onmousedown");
            this.appendAttributeDeclaration(wr, this.onmousemove, "onmousemove");
            this.appendAttributeDeclaration(wr, this.onmouseout, "onmouseout");
            this.appendAttributeDeclaration(wr, this.onmouseover, "onmouseover");
            this.appendAttributeDeclaration(wr, this.onmouseup, "onmouseup");
            this.appendAttributeDeclaration(wr, this.title, "title");
            this.appendAttributeDeclaration(wr, this.lang, "lang");
            this.appendAttributeDeclaration(wr, this.dir, "dir");
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    protected void appendAttributeDeclaration(Writer wr, String attr, String name) throws IOException {
        if (attr != null) {
            wr.write(" " + name.toLowerCase() + "=\"" + attr + "\"");
        }
    }

    protected void appendAttributeDeclaration(Writer wr, int attr, String name) throws IOException {
        if (attr != -1) {
            wr.write(" " + name.toLowerCase() + "=\"" + attr + "\"");
        }
    }

    protected void appendAttributeDeclaration(Writer wr, float attr, String name) throws IOException {
        if (attr != -1.0f) {
            wr.write(" " + name.toLowerCase() + "=\"" + attr + "\"");
        }
    }

    public void setClass(String clazz) {
        this.clazz = clazz;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setHtmltitle(String title) {
        this.title = title;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }
}

