/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.jfree.XYSplineRenderer;
import de.laures.cewolf.taglib.AttributeValidationException;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class PlotTypes {
    private static final String[] typeNames = new String[]{"xyarea", "xyline", "xyshapesandlines", "scatter", "xyverticalbar", "step", "candlestick", "highlow", "verticalbar", "area", "line", "shapesandlines", "spline", "spiderweb", "stackedxyarea", "stackedxyarea2"};
    public static final List typeList = Arrays.asList(typeNames);

    private PlotTypes() {
    }

    public static AbstractRenderer getRenderer(int idx) {
        switch (idx) {
            case 0: {
                return new XYAreaRenderer();
            }
            case 1: {
                return new StandardXYItemRenderer();
            }
            case 2: {
                return new StandardXYItemRenderer(3);
            }
            case 3: {
                return new StandardXYItemRenderer(1);
            }
            case 4: {
                return new XYBarRenderer();
            }
            case 5: {
                return new XYStepRenderer();
            }
            case 6: {
                return new CandlestickRenderer();
            }
            case 7: {
                return new HighLowRenderer();
            }
            case 8: {
                return new BarRenderer();
            }
            case 9: {
                return new AreaRenderer();
            }
            case 10: {
                return new LineAndShapeRenderer(true, false);
            }
            case 11: {
                return new LineAndShapeRenderer(true, true);
            }
            case 12: {
                return new XYSplineRenderer();
            }
            case 13: {
                return new DefaultCategoryItemRenderer();
            }
            case 14: {
                return new StackedXYAreaRenderer();
            }
            case 15: {
                return new StackedXYAreaRenderer2();
            }
        }
        throw new RuntimeException("Invalid renderer index:" + idx);
    }

    public static int getRendererIndex(String plotType) throws AttributeValidationException {
        int rendererIndex = typeList.indexOf(plotType.toLowerCase());
        if (rendererIndex < 0) {
            throw new AttributeValidationException("plot.type", plotType);
        }
        return rendererIndex;
    }
}

