/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.taglib.AttributeValidationException;
import de.laures.cewolf.taglib.DataAware;
import de.laures.cewolf.taglib.DataContainer;
import de.laures.cewolf.taglib.IncompatibleDatasetException;
import de.laures.cewolf.taglib.PlotTypes;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;

public class PlotDefinition
implements DataAware,
Serializable {
    static final long serialVersionUID = 1789401987855998576L;
    private String type;
    private String xAxisLabel;
    private String yAxisLabel;
    private boolean xAxisInteger = false;
    private boolean yAxisInteger = false;
    private DataContainer dataAware = new DataContainer();
    private transient Plot plot;
    private transient DrawingSupplier drawingSupplier = null;

    public Plot getPlot(int chartType) throws DatasetProduceException, ChartValidationException {
        block9: {
            AbstractRenderer rend;
            Dataset data;
            int rendererIndex;
            block10: {
                if (this.plot != null) break block9;
                rendererIndex = PlotTypes.getRendererIndex(this.type);
                data = this.getDataset();
                rend = PlotTypes.getRenderer(rendererIndex);
                if (chartType != 20 && chartType != 22) break block10;
                switch (rendererIndex) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 12: 
                    case 14: 
                    case 15: {
                        this.check(data, XYDataset.class, rendererIndex);
                        this.plot = new XYPlot((XYDataset)data, null, null, (XYItemRenderer)rend);
                        break block9;
                    }
                    case 4: {
                        this.check(data, IntervalXYDataset.class, rendererIndex);
                        this.plot = new XYPlot((XYDataset)((IntervalXYDataset)data), null, null, (XYItemRenderer)rend);
                        break block9;
                    }
                    case 6: 
                    case 7: {
                        this.check(data, OHLCDataset.class, rendererIndex);
                        this.plot = new XYPlot((XYDataset)((OHLCDataset)data), null, null, (XYItemRenderer)rend);
                        break block9;
                    }
                    default: {
                        throw new AttributeValidationException(chartType + ".type", this.type);
                    }
                }
            }
            if (chartType == 21) {
                switch (rendererIndex) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.check(data, CategoryDataset.class, rendererIndex);
                        this.plot = new CategoryPlot((CategoryDataset)data, null, null, (CategoryItemRenderer)rend);
                        break;
                    }
                    default: {
                        throw new AttributeValidationException(chartType + ".type", this.type);
                    }
                }
            }
        }
        this.plot.setDrawingSupplier(this.drawingSupplier);
        return this.plot;
    }

    public Dataset getDataset() throws DatasetProduceException {
        return this.dataAware.getDataset();
    }

    public String getXaxislabel() {
        return this.xAxisLabel;
    }

    public String getYaxislabel() {
        return this.yAxisLabel;
    }

    public void setXaxislabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public void setYaxislabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public void setXaxisinteger(boolean xAxisInteger) {
        this.xAxisInteger = xAxisInteger;
    }

    public boolean isXaxisinteger() {
        return this.xAxisInteger;
    }

    public void setYaxisinteger(boolean yAxisInteger) {
        this.yAxisInteger = yAxisInteger;
    }

    public boolean isYaxisinteger() {
        return this.yAxisInteger;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void check(Dataset data, Class clazz, int plotType) throws IncompatibleDatasetException {
        if (!clazz.isInstance(data)) {
            throw new IncompatibleDatasetException("Plots of type " + PlotTypes.typeList.get(plotType) + " need a dataset of type " + clazz.getName());
        }
    }

    public void setDataProductionConfig(DatasetProducer dsp, Map params, boolean useCache) {
        this.dataAware.setDataProductionConfig(dsp, params, useCache);
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.drawingSupplier = drawingSupplier;
    }
}

