/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.taglib.AbstractChartDefinition;
import de.laures.cewolf.taglib.CewolfChartFactory;
import de.laures.cewolf.taglib.PlotDefinition;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.data.general.Dataset;

public class OverlaidChartDefinition
extends AbstractChartDefinition {
    static final long serialVersionUID = 2620349751116074174L;
    private int xAxisType = 0;
    private int yAxisType = 0;
    private List plotDefinitions = new ArrayList();
    private transient DrawingSupplier drawingSupplier;

    public Dataset getDataset() throws DatasetProduceException {
        return ((PlotDefinition)this.plotDefinitions.get(0)).getDataset();
    }

    public void addPlot(PlotDefinition pd) {
        pd.setDrawingSupplier(this.getDrawingSupplier());
        this.plotDefinitions.add(pd);
    }

    protected JFreeChart produceChart() throws DatasetProduceException, ChartValidationException {
        return CewolfChartFactory.getOverlaidChartInstance(this.type, this.title, this.xAxisLabel, this.yAxisLabel, this.xAxisType, this.yAxisType, this.plotDefinitions, this.showLegend);
    }

    public void setXAxisType(int xAxisType) {
        this.xAxisType = xAxisType;
    }

    public void setYAxisType(int yAxisType) {
        this.yAxisType = yAxisType;
    }

    private DrawingSupplier getDrawingSupplier() {
        if (this.drawingSupplier == null) {
            this.drawingSupplier = new DefaultDrawingSupplier();
        }
        return this.drawingSupplier;
    }
}

