/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.taglib.DataAware;
import de.laures.cewolf.taglib.util.DatasetProductionTimeStore;
import de.laures.cewolf.util.Assert;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.jfree.data.general.Dataset;

public class DataContainer
implements DataAware,
Serializable {
    static final long serialVersionUID = 8018224798228025683L;
    private transient Dataset data;
    private transient DatasetProducer producer;
    private Map datasetProductionParams;
    private long datasetProduceTime;
    private boolean useCache = true;

    public void setDataProductionConfig(DatasetProducer dsp, Map params, boolean useCache) {
        this.producer = dsp;
        this.datasetProductionParams = params;
        this.useCache = useCache;
        this.checkDataProductionNeed();
    }

    public Dataset getDataset() throws DatasetProduceException {
        Assert.check(this.producer != null, "you need to specifiy a producer for the data of the chart.");
        if (this.data == null) {
            this.data = (Dataset)this.producer.produceDataset(this.datasetProductionParams);
            DatasetProductionTimeStore dataCache = DatasetProductionTimeStore.getInstance();
            dataCache.addEntry(this.producer.getProducerId(), this.datasetProductionParams, new Date(this.datasetProduceTime));
        }
        Assert.check(this.data != null, "your producer of type " + this.producer.getClass().getName() + " produced a null dataset.");
        return this.data;
    }

    private void checkDataProductionNeed() {
        String prodId = this.producer.getProducerId();
        DatasetProductionTimeStore dataCache = DatasetProductionTimeStore.getInstance();
        if (this.useCache && dataCache.containsEntry(prodId, this.datasetProductionParams)) {
            Date produceTime = dataCache.getProductionTime(prodId, this.datasetProductionParams);
            if (!this.producer.hasExpired(this.datasetProductionParams, produceTime)) {
                this.datasetProduceTime = produceTime.getTime();
                return;
            }
            dataCache.removeEntry(prodId, this.datasetProductionParams);
        }
        this.datasetProduceTime = System.currentTimeMillis();
    }
}

