/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.jfree.ThermometerPlot;
import de.laures.cewolf.jfree.XYConditionRenderer;
import de.laures.cewolf.jfree.XYSplineRenderer;
import de.laures.cewolf.taglib.AttributeValidationException;
import de.laures.cewolf.taglib.AxisConstants;
import de.laures.cewolf.taglib.AxisFactory;
import de.laures.cewolf.taglib.ChartConstants;
import de.laures.cewolf.taglib.ChartTypes;
import de.laures.cewolf.taglib.IncompatibleDatasetException;
import de.laures.cewolf.taglib.LayoutConstants;
import de.laures.cewolf.taglib.LayoutTypes;
import de.laures.cewolf.taglib.PlotDefinition;
import de.laures.cewolf.taglib.PlotTypes;
import de.laures.cewolf.taglib.UnsupportedChartTypeException;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public abstract class CewolfChartFactory
implements ChartConstants,
AxisConstants,
LayoutConstants {
    protected String chartType;
    private static Map factories = new HashMap();

    protected CewolfChartFactory(String chartType) {
        this.chartType = chartType;
    }

    public abstract JFreeChart getChartInstance(String var1, String var2, String var3, Dataset var4) throws IncompatibleDatasetException;

    public static void registerFactory(CewolfChartFactory factory) {
        factories.put(factory.chartType, factory);
    }

    private static final int getChartTypeConstant(String type) {
        int res = ChartTypes.typeList.indexOf(type.toLowerCase());
        if (res < 0) {
            throw new RuntimeException("unsupported chart type " + type);
        }
        return res;
    }

    private static final int getLayoutConstant(String layout) {
        return LayoutTypes.typeList.indexOf(layout.toLowerCase());
    }

    public static JFreeChart getChartInstance(String chartType, String title, String xAxisLabel, String yAxisLabel, Dataset data, boolean showLegend) throws ChartValidationException {
        CewolfChartFactory factory = (CewolfChartFactory)factories.get(chartType);
        if (factory != null) {
            return factory.getChartInstance(title, xAxisLabel, yAxisLabel, data);
        }
        switch (CewolfChartFactory.getChartTypeConstant(chartType)) {
            case 13: {
                CewolfChartFactory.check(data, XYDataset.class, chartType);
                JFreeChart chart = CewolfChartFactory.createXYLineChart(title, xAxisLabel, yAxisLabel, (XYDataset)data, PlotOrientation.VERTICAL, showLegend, true, true);
                return chart;
            }
            case 5: {
                CewolfChartFactory.check(data, PieDataset.class, chartType);
                JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)((PieDataset)data), (boolean)showLegend, (boolean)true, (boolean)true);
                return chart;
            }
            case 1: {
                CewolfChartFactory.check(data, XYDataset.class, chartType);
                JFreeChart chart = ChartFactory.createXYAreaChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)((XYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 6: {
                CewolfChartFactory.check(data, XYDataset.class, chartType);
                JFreeChart chart = CewolfChartFactory.createScatterPlot(title, xAxisLabel, yAxisLabel, (XYDataset)data, PlotOrientation.VERTICAL, showLegend, false, false);
                return chart;
            }
            case 0: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createAreaChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 2: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 3: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 4: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createLineChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 7: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createStackedBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 32: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createStackedBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 8: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createStackedBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 9: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createStackedBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 11: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createBarChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 12: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createBarChart3D((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 10: {
                CewolfChartFactory.check(data, XYDataset.class, chartType);
                JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)((XYDataset)data), (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 14: {
                CewolfChartFactory.check(data, OHLCDataset.class, chartType);
                JFreeChart chart = ChartFactory.createCandlestickChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (OHLCDataset)((OHLCDataset)data), (boolean)true);
                return chart;
            }
            case 15: {
                CewolfChartFactory.check(data, OHLCDataset.class, chartType);
                JFreeChart chart = ChartFactory.createHighLowChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (OHLCDataset)((OHLCDataset)data), (boolean)true);
                return chart;
            }
            case 16: {
                CewolfChartFactory.check(data, IntervalCategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createGanttChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (IntervalCategoryDataset)((IntervalCategoryDataset)data), (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 17: {
                CewolfChartFactory.check(data, WindDataset.class, chartType);
                JFreeChart chart = ChartFactory.createWindPlot((String)title, (String)xAxisLabel, (String)yAxisLabel, (WindDataset)((WindDataset)data), (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 18: {
                CewolfChartFactory.check(data, IntervalXYDataset.class, chartType);
                JFreeChart chart = ChartFactory.createXYBarChart((String)title, (String)xAxisLabel, (boolean)true, (String)yAxisLabel, (IntervalXYDataset)((IntervalXYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 19: {
                CewolfChartFactory.check(data, PieDataset.class, chartType);
                JFreeChart chart = ChartFactory.createPieChart3D((String)title, (PieDataset)((PieDataset)data), (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 23: {
                CewolfChartFactory.check(data, ValueDataset.class, chartType);
                MeterPlot plot = new MeterPlot((ValueDataset)data);
                JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)plot, showLegend);
                ChartFactory.getChartTheme().apply(chart);
                return chart;
            }
            case 29: {
                CewolfChartFactory.check(data, ValueDataset.class, chartType);
                DialPlot dplot = new DialPlot((ValueDataset)data);
                dplot.addPointer((DialPointer)new DialPointer.Pin());
                StandardDialScale scale = new StandardDialScale();
                scale.setTickLabelFont(new Font("Dialog", 1, 10));
                dplot.addScale(0, (DialScale)scale);
                JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)dplot, showLegend);
                ChartFactory.getChartTheme().apply(chart);
                return chart;
            }
            case 28: {
                CewolfChartFactory.check(data, ValueDataset.class, chartType);
                ThermometerPlot tplot = new ThermometerPlot((ValueDataset)data);
                JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)tplot, showLegend);
                ChartFactory.getChartTheme().apply(chart);
                return chart;
            }
            case 30: {
                CewolfChartFactory.check(data, ValueDataset.class, chartType);
                CompassPlot cplot = new CompassPlot((ValueDataset)data);
                JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)cplot, showLegend);
                ChartFactory.getChartTheme().apply(chart);
                return chart;
            }
            case 24: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (CategoryDataset)((CategoryDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 25: {
                CewolfChartFactory.check(data, XYZDataset.class, chartType);
                JFreeChart chart = ChartFactory.createBubbleChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYZDataset)((XYZDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)showLegend, (boolean)false, (boolean)false);
                return chart;
            }
            case 26: {
                CewolfChartFactory.check(data, XYDataset.class, chartType);
                JFreeChart chart = CewolfChartFactory.createSplineChart(title, xAxisLabel, yAxisLabel, (XYDataset)data, PlotOrientation.VERTICAL, showLegend, true, true);
                return chart;
            }
            case 27: {
                CewolfChartFactory.check(data, IntervalXYDataset.class, chartType);
                JFreeChart chart = ChartFactory.createHistogram((String)title, (String)xAxisLabel, (String)yAxisLabel, (IntervalXYDataset)((IntervalXYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
                return chart;
            }
            case 31: {
                CewolfChartFactory.check(data, CategoryDataset.class, chartType);
                SpiderWebPlot swplot = new SpiderWebPlot((CategoryDataset)data);
                JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)swplot, showLegend);
                ChartFactory.getChartTheme().apply(chart);
                return chart;
            }
        }
        throw new UnsupportedChartTypeException(chartType + " is not supported.");
    }

    public static JFreeChart createSplineChart(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean showLegend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        XYSplineRenderer renderer = new XYSplineRenderer(10);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, showLegend);
        ChartFactory.getChartTheme().apply(chart);
        return chart;
    }

    public static JFreeChart createScatterPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        StandardXYToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        XYConditionRenderer renderer = new XYConditionRenderer(false, true);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        renderer.setURLGenerator((XYURLGenerator)urlGenerator);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        ChartFactory.getChartTheme().apply(chart);
        return chart;
    }

    public static JFreeChart createXYLineChart(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        XYConditionRenderer renderer = new XYConditionRenderer(true, false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        ChartFactory.getChartTheme().apply(chart);
        return chart;
    }

    public static JFreeChart getOverlaidChartInstance(String chartType, String title, String xAxisLabel, String yAxisLabel, int xAxisType, int yAxisType, List plotDefinitions, boolean showLegend) throws ChartValidationException, DatasetProduceException {
        int chartTypeConst = CewolfChartFactory.getChartTypeConstant(chartType);
        AxisFactory axisFactory = AxisFactory.getInstance();
        switch (chartTypeConst) {
            case 20: {
                ValueAxis domainAxis = (ValueAxis)axisFactory.createAxis(0, xAxisType, xAxisLabel);
                PlotDefinition mainPlotDef = (PlotDefinition)plotDefinitions.get(0);
                if (domainAxis instanceof NumberAxis && mainPlotDef.isXaxisinteger()) {
                    ((NumberAxis)domainAxis).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                }
                CewolfChartFactory.check(mainPlotDef.getDataset(), XYDataset.class, chartType);
                XYPlot plot = (XYPlot)mainPlotDef.getPlot(chartTypeConst);
                plot.setDomainAxis(domainAxis);
                ValueAxis rangeAxis = (ValueAxis)axisFactory.createAxis(1, yAxisType, yAxisLabel);
                if (rangeAxis instanceof NumberAxis && mainPlotDef.isYaxisinteger()) {
                    ((NumberAxis)rangeAxis).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                }
                plot.setRangeAxis(rangeAxis);
                for (int plotidx = 1; plotidx < plotDefinitions.size(); ++plotidx) {
                    PlotDefinition subPlotDef = (PlotDefinition)plotDefinitions.get(plotidx);
                    CewolfChartFactory.check(subPlotDef.getDataset(), class$org$jfree$data$xy$XYDataset == null ? CewolfChartFactory.class$("org.jfree.data.xy.XYDataset") : class$org$jfree$data$xy$XYDataset, chartType);
                    plot.setDataset(plotidx, (XYDataset)subPlotDef.getDataset());
                    int rendererIndex = PlotTypes.getRendererIndex(subPlotDef.getType());
                    XYItemRenderer rend = (XYItemRenderer)PlotTypes.getRenderer(rendererIndex);
                    plot.setRenderer(plotidx, rend);
                }
                return new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)plot, showLegend);
            }
            case 21: {
                CategoryAxis domainAxis2 = (CategoryAxis)axisFactory.createAxis(0, xAxisType, xAxisLabel);
                PlotDefinition mainPlotDef = (PlotDefinition)plotDefinitions.get(0);
                CewolfChartFactory.check(mainPlotDef.getDataset(), CategoryDataset.class, chartType);
                CategoryPlot plot2 = (CategoryPlot)mainPlotDef.getPlot(chartTypeConst);
                plot2.setDomainAxis(domainAxis2);
                ValueAxis va = (ValueAxis)axisFactory.createAxis(1, yAxisType, yAxisLabel);
                if (va instanceof NumberAxis && mainPlotDef.isYaxisinteger()) {
                    ((NumberAxis)va).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                }
                plot2.setRangeAxis(va);
                for (int plotidx = 1; plotidx < plotDefinitions.size(); ++plotidx) {
                    PlotDefinition subPlotDef = (PlotDefinition)plotDefinitions.get(plotidx);
                    CewolfChartFactory.check(subPlotDef.getDataset(), class$org$jfree$data$category$CategoryDataset == null ? CewolfChartFactory.class$("org.jfree.data.category.CategoryDataset") : class$org$jfree$data$category$CategoryDataset, chartType);
                    plot2.setDataset(plotidx, (CategoryDataset)subPlotDef.getDataset());
                    int rendererIndex = PlotTypes.getRendererIndex(subPlotDef.getType());
                    CategoryItemRenderer rend2 = (CategoryItemRenderer)PlotTypes.getRenderer(rendererIndex);
                    plot2.setRenderer(plotidx, rend2);
                }
                return new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)plot2, showLegend);
            }
        }
        throw new UnsupportedChartTypeException(chartType + " is not supported.");
    }

    public static JFreeChart getCombinedChartInstance(String chartType, String title, String xAxisLabel, String yAxisLabel, List plotDefinitions, String layout, boolean showLegend) throws ChartValidationException, DatasetProduceException {
        int chartTypeConst = CewolfChartFactory.getChartTypeConstant(chartType);
        switch (chartTypeConst) {
            case 22: {
                int layoutConst = CewolfChartFactory.getLayoutConstant(layout);
                CombinedDomainXYPlot plot = null;
                switch (layoutConst) {
                    case 0: {
                        DateAxis domainAxis = new DateAxis(xAxisLabel);
                        plot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
                        for (int i = 0; i < plotDefinitions.size(); ++i) {
                            PlotDefinition pd = (PlotDefinition)plotDefinitions.get(i);
                            CewolfChartFactory.check(pd.getDataset(), class$org$jfree$data$xy$XYDataset == null ? CewolfChartFactory.class$("org.jfree.data.xy.XYDataset") : class$org$jfree$data$xy$XYDataset, chartType);
                            XYPlot temp = (XYPlot)pd.getPlot(chartTypeConst);
                            NumberAxis na = new NumberAxis(pd.getYaxislabel());
                            if (pd.isYaxisinteger()) {
                                na.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                            }
                            temp.setRangeAxis((ValueAxis)na);
                            plot.add(temp);
                        }
                        return new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)plot, showLegend);
                    }
                    case 1: {
                        NumberAxis rangeAxis = new NumberAxis(yAxisLabel);
                        plot = new CombinedRangeXYPlot((ValueAxis)rangeAxis);
                        boolean allInteger = true;
                        for (int i = 0; i < plotDefinitions.size(); ++i) {
                            PlotDefinition pd = (PlotDefinition)plotDefinitions.get(i);
                            if (!pd.isYaxisinteger()) {
                                allInteger = false;
                            }
                            CewolfChartFactory.check(pd.getDataset(), class$org$jfree$data$xy$XYDataset == null ? CewolfChartFactory.class$("org.jfree.data.xy.XYDataset") : class$org$jfree$data$xy$XYDataset, chartType);
                            XYPlot temp = (XYPlot)pd.getPlot(chartTypeConst);
                            temp.setDomainAxis((ValueAxis)new DateAxis(pd.getXaxislabel()));
                            ((CombinedRangeXYPlot)plot).add(temp);
                        }
                        if (allInteger) {
                            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                        }
                        return new JFreeChart(title, new Font("SansSerif", 1, 18), (Plot)plot, showLegend);
                    }
                }
                throw new AttributeValidationException(layout, " any value");
            }
        }
        throw new UnsupportedChartTypeException(chartType);
    }

    public static void check(Dataset data, Class clazz, String chartType) throws IncompatibleDatasetException {
        if (!clazz.isInstance(data)) {
            throw new IncompatibleDatasetException("Charts of type " + chartType + " " + "need datasets of type " + clazz.getName());
        }
    }
}

