/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.PostProcessingException;
import de.laures.cewolf.event.ChartImageRenderListener;
import de.laures.cewolf.util.ImageHelper;
import de.laures.cewolf.util.RenderedImage;
import java.awt.Image;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.RectangleEdge;

public abstract class AbstractChartDefinition
implements ChartHolder,
Serializable,
ChartImageRenderListener {
    protected String title;
    protected String xAxisLabel;
    protected String yAxisLabel;
    protected String type;
    protected boolean xAxisInteger = false;
    protected boolean yAxisInteger = false;
    protected boolean xTickMarksVisible = true;
    protected boolean yTickMarksVisible = true;
    protected boolean xTickLabelsVisible = true;
    protected boolean yTickLabelsVisible = true;
    protected boolean borderVisible = false;
    protected boolean plotBorderVisible = true;
    private boolean antialias = true;
    private String background;
    private float backgroundImageAlpha = 1.0f;
    private Paint backgroundPaint;
    private Paint plotBackgroundPaint;
    private Paint borderPaint;
    private Paint plotBorderPaint;
    private int legendAnchor = 101;
    protected boolean showLegend = true;
    private List postProcessors = new ArrayList();
    private List postProcessorsParams = new ArrayList();
    private JFreeChart chart;

    protected abstract JFreeChart produceChart() throws DatasetProduceException, ChartValidationException;

    public LegendTitle getLegend() {
        LegendTitle legend = null;
        List subTitles = this.chart.getSubtitles();
        Iterator iter = subTitles.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof LegendTitle)) continue;
            legend = (LegendTitle)o;
            break;
        }
        return legend;
    }

    public void removeLegend() {
        List subTitles = this.chart.getSubtitles();
        Iterator iter = subTitles.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof LegendTitle)) continue;
            iter.remove();
            break;
        }
    }

    public JFreeChart getChart() throws DatasetProduceException, ChartValidationException, PostProcessingException {
        if (this.chart == null) {
            ValueAxis axis;
            this.chart = this.produceChart();
            this.chart.setAntiAlias(this.antialias);
            if (this.background != null) {
                Image image = ImageHelper.loadImage(this.background);
                this.chart.setBackgroundImage(image);
                this.chart.setBackgroundImageAlpha(this.backgroundImageAlpha);
            }
            if (this.backgroundPaint != null) {
                this.chart.setBackgroundPaint(this.backgroundPaint);
            }
            if (this.plotBackgroundPaint != null) {
                this.chart.getPlot().setBackgroundPaint(this.plotBackgroundPaint);
            }
            if (this.borderPaint != null) {
                this.chart.setBorderPaint(this.borderPaint);
            }
            if (this.plotBorderPaint != null) {
                this.chart.getPlot().setOutlinePaint(this.plotBorderPaint);
            }
            this.chart.setBorderVisible(this.borderVisible);
            this.chart.getPlot().setOutlineVisible(this.plotBorderVisible);
            if (this.showLegend) {
                LegendTitle legend = this.getLegend();
                switch (this.legendAnchor) {
                    case 100: {
                        legend.setPosition(RectangleEdge.TOP);
                        break;
                    }
                    case 103: {
                        legend.setPosition(RectangleEdge.LEFT);
                        break;
                    }
                    case 102: {
                        legend.setPosition(RectangleEdge.RIGHT);
                        break;
                    }
                    default: {
                        legend.setPosition(RectangleEdge.BOTTOM);
                        break;
                    }
                }
            } else {
                this.removeLegend();
            }
            Plot plot = this.chart.getPlot();
            if (plot instanceof CategoryPlot) {
                int i;
                CategoryPlot cplot = (CategoryPlot)plot;
                for (i = 0; i < cplot.getRangeAxisCount(); ++i) {
                    axis = cplot.getRangeAxis(i);
                    if (axis instanceof NumberAxis && this.yAxisInteger) {
                        ((NumberAxis)axis).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    }
                    if (axis == null) continue;
                    axis.setTickMarksVisible(this.yTickMarksVisible);
                    axis.setTickLabelsVisible(this.yTickLabelsVisible);
                }
                for (i = 0; i < cplot.getDomainAxisCount(); ++i) {
                    cplot.getDomainAxis(i).setTickMarksVisible(this.xTickMarksVisible);
                    cplot.getDomainAxis(i).setTickLabelsVisible(this.xTickLabelsVisible);
                }
            } else if (plot instanceof FastScatterPlot) {
                FastScatterPlot fsplot = (FastScatterPlot)plot;
                ValueAxis axis2 = fsplot.getDomainAxis();
                if (axis2 instanceof NumberAxis && this.xAxisInteger) {
                    ((NumberAxis)axis2).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                }
                if (axis2 != null) {
                    axis2.setTickMarksVisible(this.xTickMarksVisible);
                    axis2.setTickLabelsVisible(this.xTickLabelsVisible);
                }
                if ((axis2 = fsplot.getRangeAxis()) instanceof NumberAxis && this.yAxisInteger) {
                    ((NumberAxis)axis2).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                }
                if (axis2 != null) {
                    axis2.setTickMarksVisible(this.yTickMarksVisible);
                }
            } else if (plot instanceof ThermometerPlot) {
                ValueAxis axis3 = ((ThermometerPlot)plot).getRangeAxis();
                if (axis3 instanceof NumberAxis && this.yAxisInteger) {
                    ((NumberAxis)axis3).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                }
                if (axis3 != null) {
                    axis3.setTickMarksVisible(this.yTickMarksVisible);
                    axis3.setTickLabelsVisible(this.yTickLabelsVisible);
                }
            } else if (plot instanceof XYPlot) {
                int i;
                XYPlot xyplot = (XYPlot)plot;
                for (i = 0; i < xyplot.getRangeAxisCount(); ++i) {
                    axis = xyplot.getRangeAxis(i);
                    if (axis instanceof NumberAxis && this.yAxisInteger) {
                        ((NumberAxis)axis).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    }
                    if (axis == null) continue;
                    axis.setTickMarksVisible(this.yTickMarksVisible);
                    axis.setTickLabelsVisible(this.yTickLabelsVisible);
                }
                for (i = 0; i < xyplot.getDomainAxisCount(); ++i) {
                    axis = xyplot.getDomainAxis(i);
                    if (axis instanceof NumberAxis && this.xAxisInteger) {
                        ((NumberAxis)axis).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    }
                    if (axis == null) continue;
                    axis.setTickMarksVisible(this.xTickMarksVisible);
                    axis.setTickLabelsVisible(this.xTickLabelsVisible);
                }
            }
            for (int i = 0; i < this.postProcessors.size(); ++i) {
                ChartPostProcessor cpp = (ChartPostProcessor)this.postProcessors.get(i);
                try {
                    cpp.processChart(this.chart, (Map)this.postProcessorsParams.get(i));
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new PostProcessingException(t.getClass().getName() + " raised by post processor '" + cpp + "'.\nPost processing of this post processor " + "has been ignored.");
                }
            }
        }
        return this.chart;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setBackgroundImageAlpha(float backgroundImageAlpha) {
        this.backgroundImageAlpha = backgroundImageAlpha;
    }

    public void setLegendAnchor(int legendAnchor) {
        this.legendAnchor = legendAnchor;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public void setPlotBackgroundPaint(Paint paint) {
        this.plotBackgroundPaint = paint;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public void setXaxisinteger(boolean xAxisInteger) {
        this.xAxisInteger = xAxisInteger;
    }

    public void setYaxisinteger(boolean yAxisInteger) {
        this.yAxisInteger = yAxisInteger;
    }

    public void setXtickmarksvisible(boolean xTickMarksVisible) {
        this.xTickMarksVisible = xTickMarksVisible;
    }

    public void setYtickmarksvisible(boolean yTickMarksVisible) {
        this.yTickMarksVisible = yTickMarksVisible;
    }

    public void setXticklabelsvisible(boolean xTickLabelsVisible) {
        this.xTickLabelsVisible = xTickLabelsVisible;
    }

    public void setYticklabelsvisible(boolean yTickLabelsVisible) {
        this.yTickLabelsVisible = yTickLabelsVisible;
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    public void setPlotBorderVisible(boolean plotBorderVisible) {
        this.plotBorderVisible = plotBorderVisible;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public void setPlotBorderPaint(Paint paint) {
        this.plotBorderPaint = paint;
    }

    public void addPostProcessor(ChartPostProcessor cpp) {
        this.postProcessors.add(cpp);
    }

    public void addPostProcessorParams(Map params) {
        this.postProcessorsParams.add(params);
    }

    public void onImageRendered(RenderedImage renderedImage) {
        for (int i = 0; i < this.postProcessors.size(); ++i) {
            ChartPostProcessor cpp = (ChartPostProcessor)this.postProcessors.get(i);
            if (!(cpp instanceof ChartImageRenderListener)) continue;
            ((ChartImageRenderListener)((Object)cpp)).onImageRendered(renderedImage);
        }
    }
}

