/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.storage.SessionStorageGroup;
import de.laures.cewolf.storage.SessionStorageItem;
import de.laures.cewolf.storage.StorageCleaner;
import java.util.Calendar;
import junit.framework.TestCase;

public class TestSessionStorageGroup
extends TestCase {
    private SessionStorageGroup group1;
    private SessionStorageGroup group2;
    private SessionStorageItem ssi_chart1;
    private SessionStorageItem ssi_chart2;

    protected void setUp() throws Exception {
        super.setUp();
        this.group1 = new SessionStorageGroup();
        this.group2 = new SessionStorageGroup();
        Calendar expInOneSec = Calendar.getInstance();
        expInOneSec.add(13, 1);
        Calendar expInTenSec = Calendar.getInstance();
        expInTenSec.add(13, 10);
        this.ssi_chart1 = new SessionStorageItem(null, "chart1", expInOneSec.getTime());
        this.ssi_chart2 = new SessionStorageItem(null, "chart2", expInTenSec.getTime());
    }

    protected void tearDown() throws Exception {
        this.group1 = null;
        this.group2 = null;
        super.tearDown();
    }

    public void testStorageGroupCleanup() throws Exception {
        this.group1.put(this.ssi_chart1.getCid(), this.ssi_chart1);
        this.group2.put(this.ssi_chart2.getCid(), this.ssi_chart2);
        TestSessionStorageGroup.assertTrue((String)"the cleaner thread must run now", (boolean)StorageCleaner.getInstance().isRunning());
        TestSessionStorageGroup.assertNotNull((Object)this.group1.get(this.ssi_chart1.getCid()));
        TestSessionStorageGroup.assertNotNull((Object)this.group2.get(this.ssi_chart2.getCid()));
        Thread.sleep(2000L);
        TestSessionStorageGroup.assertNull((String)"One second image must go away", (Object)this.group1.get(this.ssi_chart1.getCid()));
        TestSessionStorageGroup.assertNotNull((String)"Ten second image must stay", (Object)this.group2.get(this.ssi_chart2.getCid()));
        Thread.sleep(9000L);
        TestSessionStorageGroup.assertTrue((String)"All images must go away", (boolean)this.group1.isEmpty());
        TestSessionStorageGroup.assertTrue((String)"All images must go away", (boolean)this.group2.isEmpty());
    }

    public void testCleanerThreadStop() throws Exception {
        this.group1.put(this.ssi_chart1.getCid(), this.ssi_chart1);
        this.group2.put(this.ssi_chart2.getCid(), this.ssi_chart2);
        TestSessionStorageGroup.assertTrue((String)"the cleaner thread must run now", (boolean)StorageCleaner.getInstance().isRunning());
        this.group1 = null;
        this.group2 = null;
        for (int i = 0; i < 20; ++i) {
            System.gc();
            Thread.sleep(100L);
        }
        TestSessionStorageGroup.assertFalse((String)"the cleaner thread should be stopped now", (boolean)StorageCleaner.getInstance().isRunning());
    }
}

