/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.storage.SessionStorageGroup;
import java.util.WeakHashMap;

class StorageCleaner
implements Runnable {
    private WeakHashMap storageGroups = new WeakHashMap();
    private Thread runner;
    private static StorageCleaner INSTANCE = new StorageCleaner();

    private StorageCleaner() {
    }

    public static StorageCleaner getInstance() {
        return INSTANCE;
    }

    public void addStorageGroup(SessionStorageGroup group) {
        this.storageGroups.put(group, null);
        this.start();
    }

    private void start() {
        if (!this.isRunning()) {
            this.runner = new Thread(this);
            this.runner.setDaemon(true);
            this.runner.setName("Cewolf-SessionCleanup");
            this.runner.setPriority(1);
            this.runner.start();
        }
    }

    boolean isRunning() {
        return this.runner != null && this.runner.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.storageGroups.keySet().isEmpty()) {
                Object issg = this.storageGroups.keySet().iterator();
                while (issg.hasNext()) {
                    SessionStorageGroup ssg = (SessionStorageGroup)issg.next();
                    ssg.cleanup();
                }
                issg = this;
                synchronized (issg) {
                    this.wait(1000L);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

