/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.Storage;
import de.laures.cewolf.storage.SerializableChartImage;
import de.laures.cewolf.taglib.util.KeyGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class FileStorage
implements Storage {
    static final long serialVersionUID = -6342203760851077577L;
    String basePath = null;
    List stored = new ArrayList();
    private boolean deleteOnExit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String storeChartImage(ChartImage cid, PageContext pageContext) {
        if (this.contains(cid, pageContext)) {
            return this.getKey(cid);
        }
        String id = this.getKey(cid);
        ObjectOutputStream oos = null;
        try {
            String fileName = this.getFileName(id);
            pageContext.getServletContext().log("Storing image to file " + fileName);
            File f = new File(fileName);
            if (this.deleteOnExit) {
                f.deleteOnExit();
            }
            oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(new SerializableChartImage(cid));
            oos.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        catch (CewolfException cwex) {
            cwex.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartImage getChartImage(String id, HttpServletRequest request) {
        ChartImage res = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.getFileName(id)));
            res = (ChartImage)ois.readObject();
            ois.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
        }
        return res;
    }

    public boolean contains(ChartImage chartImage, PageContext pageContext) {
        return new File(this.getFileName(chartImage)).exists();
    }

    public String getKey(ChartImage chartImage) {
        return String.valueOf(KeyGenerator.generateKey(chartImage));
    }

    public void init(ServletContext servletContext) throws CewolfException {
        this.basePath = servletContext.getRealPath("/");
        Configuration config = Configuration.getInstance(servletContext);
        this.deleteOnExit = "true".equalsIgnoreCase("" + config.getParameters().get("FileStorage.deleteOnExit"));
        servletContext.log("FileStorage initialized, deleteOnExit=" + this.deleteOnExit);
    }

    private String getFileName(ChartImage chartImage) {
        return this.getFileName(this.getKey(chartImage));
    }

    private String getFileName(String id) {
        return this.basePath + "_chart" + id;
    }

    public String removeChartImage(String imgKey, HttpServletRequest pageContext) throws CewolfException {
        File file = new File(this.getFileName(imgKey));
        if (file.exists() && !file.delete()) {
            throw new CewolfException("Could not delete file " + file.getAbsolutePath());
        }
        return imgKey;
    }
}

