/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.Storage;
import de.laures.cewolf.taglib.util.KeyGenerator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public abstract class AbstractSessionStorage
implements Storage {
    protected static volatile int stored = 0;
    protected static volatile int removed = 0;

    public String storeChartImage(ChartImage cid, PageContext pageContext) throws CewolfException {
        if (this.contains(cid, pageContext)) {
            return this.getKey(cid);
        }
        HttpSession session = pageContext.getSession();
        return this.storeChartImage(cid, session);
    }

    public ChartImage getChartImage(String id, HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (ChartImage)session.getAttribute(id);
    }

    public boolean contains(ChartImage cid, PageContext pageContext) {
        return pageContext.getSession().getAttribute(this.getKey(cid)) != null;
    }

    public final String getKey(ChartImage cid) {
        return String.valueOf(KeyGenerator.generateKey(cid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeChartImage(ChartImage cid, HttpSession session) throws CewolfException {
        String sessionKey = this.getKey(cid);
        Object object = session;
        synchronized (object) {
            session.setAttribute(sessionKey, this.getCacheObject(cid));
        }
        object = AbstractSessionStorage.class;
        synchronized (object) {
            ++stored;
        }
        return sessionKey;
    }

    public String removeChartImage(String imgKey, HttpServletRequest request) throws CewolfException {
        HttpSession session = request.getSession();
        if (session == null) {
            return imgKey;
        }
        return this.removeChartImage(imgKey, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String removeChartImage(String cid, HttpSession session) throws CewolfException {
        Object object = session;
        synchronized (object) {
            session.removeAttribute(cid);
        }
        object = AbstractSessionStorage.class;
        synchronized (object) {
            ++removed;
        }
        return cid;
    }

    protected abstract Object getCacheObject(ChartImage var1) throws CewolfException;

    public void init(ServletContext servletContext) throws CewolfException {
    }
}

