/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.jfree;

import de.laures.cewolf.util.Expr;
import java.util.HashMap;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class XYConditionRenderer
extends XYLineAndShapeRenderer {
    private static final long serialVersionUID = -6413096273679067358L;
    private String shapeVisibleCondition;
    private String shapeFilledCondition;
    private static Expr expr;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XYConditionRenderer(boolean lines, boolean shapes) {
        super(lines, shapes);
    }

    public String getShapeVisibleCondition() {
        return this.shapeVisibleCondition;
    }

    public void setShapeVisibleCondition(String cond) {
        this.shapeVisibleCondition = cond;
    }

    public String getShapeFilledCondition() {
        return this.shapeFilledCondition;
    }

    public void setShapeFilledCondition(String cond) {
        this.shapeFilledCondition = cond;
    }

    public boolean getItemShapeVisible(int series, int item) {
        if (this.shapeVisibleCondition == null || this.shapeVisibleCondition.length() == 0) {
            return super.getItemShapeVisible(series, item);
        }
        return this.evaluateCondition(this.shapeVisibleCondition, series, item);
    }

    public boolean getItemShapeFilled(int series, int item) {
        if (this.shapeFilledCondition == null || this.shapeFilledCondition.length() == 0) {
            return super.getItemShapeFilled(series, item);
        }
        return this.evaluateCondition(this.shapeFilledCondition, series, item);
    }

    private boolean evaluateCondition(String cond, int series, int item) {
        XYDataset ds = this.getPlot().getDataset();
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("s", new Double(series));
        vars.put("i", new Double(item));
        vars.put("x", new Double(ds.getXValue(series, item)));
        vars.put("y", new Double(ds.getYValue(series, item)));
        double result = Expr.eval("cond(" + cond + ", 1, -1)", vars);
        return result > 0.0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYConditionRenderer)) {
            return false;
        }
        XYConditionRenderer that = (XYConditionRenderer)((Object)obj);
        if (!this.shapeVisibleCondition.equals(that.shapeVisibleCondition)) {
            return false;
        }
        if (!this.shapeFilledCondition.equals(that.shapeFilledCondition)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    static {
        $assertionsDisabled = !XYConditionRenderer.class.desiredAssertionStatus();
        expr = new Expr();
    }
}

