/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.dp;

import de.laures.cewolf.DatasetProduceException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jfree.data.xy.XYSeries;

public class DataSourceXYSeries
implements Serializable {
    static final long serialVersionUID = -925366561462055785L;
    private String dataSourceName;
    private String query;
    private String xCol = "x";
    private String yCol = "y";
    private String seriesName = "name";

    public DataSourceXYSeries(String dataSourceName, String query) {
        this.dataSourceName = dataSourceName;
        this.query = query;
    }

    protected DataSource getDataSource() throws NamingException {
        InitialContext initCtx = new InitialContext();
        Context envCtx = (Context)initCtx.lookup("java:comp/env");
        return (DataSource)envCtx.lookup(this.dataSourceName);
    }

    public XYSeries produceXYSeries() throws DatasetProduceException {
        XYSeries series = new XYSeries((Comparable)((Object)this.seriesName));
        Connection con = null;
        Statement stmt = null;
        try {
            DataSource ds = this.getDataSource();
            con = ds.getConnection();
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(this.query);
            int xColIndex = rs.findColumn(this.xCol);
            int yColIndex = rs.findColumn(this.yCol);
            while (rs.next()) {
                series.add((Number)rs.getObject(xColIndex), (Number)rs.getObject(yColIndex));
            }
        }
        catch (Exception namingEx) {
            namingEx.printStackTrace();
            throw new DatasetProduceException(namingEx.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqlex) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sqlex) {}
        }
        return series;
    }
}

