/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class ZoomBothAxis
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = -3336573712263777733L;
    private double lowerRangeVal = 0.0;
    private double upperRangeVal = 0.0;
    private double lowerDomainValN = 0.0;
    private double upperDomainValN = 0.0;
    private GregorianCalendar lowerDomainValD = new GregorianCalendar(1901, 0, 1);
    private GregorianCalendar upperDomainValD = new GregorianCalendar(1901, 0, 1);
    private double zoomFactor = 1.0;
    private double anchorValueD = Double.NaN;
    private double anchorValueR = Double.NaN;

    public void processChart(Object chart, Map params) {
        JFreeChart localChart = (JFreeChart)chart;
        Plot plot = localChart.getPlot();
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            ValueAxis rangeAxis = xyPlot.getRangeAxis();
            ValueAxis domainAxis = xyPlot.getDomainAxis();
            if (rangeAxis instanceof NumberAxis) {
                this.lowerRangeVal = ((NumberAxis)rangeAxis).getLowerBound();
                this.upperRangeVal = ((NumberAxis)rangeAxis).getUpperBound();
            }
            if (domainAxis instanceof DateAxis) {
                this.lowerDomainValD.setTime(((DateAxis)domainAxis).getMinimumDate());
                this.upperDomainValD.setTime(((DateAxis)domainAxis).getMaximumDate());
            } else if (domainAxis instanceof NumberAxis) {
                this.lowerDomainValN = ((NumberAxis)domainAxis).getLowerBound();
                this.upperDomainValN = ((NumberAxis)domainAxis).getUpperBound();
            }
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot catPlot = (CategoryPlot)plot;
            ValueAxis axis = catPlot.getRangeAxis();
            this.lowerRangeVal = ((NumberAxis)axis).getLowerBound();
            this.upperRangeVal = ((NumberAxis)axis).getUpperBound();
        }
        String str = (String)params.get("lowerRangeVal");
        if (str != null) {
            try {
                this.lowerRangeVal = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("upperRangeVal")) != null) {
            try {
                this.upperRangeVal = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("zoomFactor")) != null) {
            try {
                this.zoomFactor = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("anchorValueD")) != null) {
            try {
                this.anchorValueD = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("anchorValueR")) != null) {
            try {
                this.anchorValueR = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("lowerDomainValN")) != null) {
            try {
                double newDomainVal = Double.parseDouble(str);
                if (newDomainVal >= this.lowerDomainValN) {
                    this.lowerDomainValN = newDomainVal;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("upperDomainValN")) != null) {
            try {
                double newDomainVal = Double.parseDouble(str);
                if (newDomainVal <= this.upperDomainValN) {
                    this.upperDomainValN = newDomainVal;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        String strL = (String)params.get("lowerDomainValD");
        String strU = (String)params.get("upperDomainValD");
        if (strL != null && strU != null && !strL.equals(strU)) {
            String[] component = strL.split(":");
            int hour = Integer.parseInt(component[0]);
            int minute = Integer.parseInt(component[1]);
            int tester = this.lowerDomainValD.get(11);
            if (hour > tester) {
                this.lowerDomainValD.set(11, hour);
                this.lowerDomainValD.set(12, minute);
            } else if (hour == 11) {
                if (minute > 12) {
                    this.lowerDomainValD.set(11, hour);
                    this.lowerDomainValD.set(12, minute);
                }
            }
            component = strU.split(":");
            hour = Integer.parseInt(component[0]);
            minute = Integer.parseInt(component[1]);
            tester = this.upperDomainValD.get(11);
            if (hour < tester) {
                this.upperDomainValD.set(11, hour);
                this.upperDomainValD.set(12, minute);
            } else if (hour == 11) {
                if (minute < 12) {
                    this.upperDomainValD.set(11, hour);
                    this.upperDomainValD.set(12, minute);
                }
            }
        }
        if (plot instanceof XYPlot) {
            ValueAxis dAxis;
            XYPlot xyPlot = (XYPlot)plot;
            ValueAxis rAxis = xyPlot.getRangeAxis();
            if (rAxis instanceof NumberAxis) {
                NumberAxis nAxis = (NumberAxis)rAxis;
                if (this.lowerRangeVal != this.upperRangeVal) {
                    nAxis.setLowerBound(this.lowerRangeVal);
                    nAxis.setUpperBound(this.upperRangeVal);
                }
                nAxis.resizeRange(this.zoomFactor);
                if (!Double.isNaN(this.anchorValueR)) {
                    nAxis.centerRange(this.anchorValueR);
                }
            }
            if ((dAxis = xyPlot.getDomainAxis()) instanceof DateAxis) {
                ((DateAxis)dAxis).setMinimumDate(this.lowerDomainValD.getTime());
                ((DateAxis)dAxis).setMaximumDate(this.upperDomainValD.getTime());
            } else if (dAxis instanceof NumberAxis) {
                NumberAxis nAxis = (NumberAxis)dAxis;
                if (this.lowerDomainValN != this.upperDomainValN) {
                    nAxis.setRange(this.lowerDomainValN, this.upperDomainValN);
                }
                if (!Double.isNaN(this.anchorValueD)) {
                    nAxis.centerRange(this.anchorValueD);
                }
            }
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot catPlot = (CategoryPlot)plot;
            NumberAxis axis = (NumberAxis)catPlot.getRangeAxis();
            axis.setLowerBound(this.lowerRangeVal);
            axis.setUpperBound(this.upperRangeVal);
            axis.resizeRange(this.zoomFactor);
        }
    }

    public double getAnchorValueD() {
        return this.anchorValueD;
    }

    public void setAnchorValueD(double anchorValueD) {
        this.anchorValueD = anchorValueD;
    }

    public double getAnchorValueR() {
        return this.anchorValueR;
    }

    public void setAnchorValueR(double anchorValueR) {
        this.anchorValueR = anchorValueR;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public double getLowerRangeVal() {
        return this.lowerRangeVal;
    }

    public void setLowerRangeVal(double lowerRangeVal) {
        this.lowerRangeVal = lowerRangeVal;
    }

    public double getUpperRangeVal() {
        return this.upperRangeVal;
    }

    public void setUpperRangeVal(double upperRangeVal) {
        this.upperRangeVal = upperRangeVal;
    }

    public double getUpperDomainValN() {
        return this.upperDomainValN;
    }

    public void setUpperDomainValN(double upperDomainVal) {
        this.upperDomainValN = upperDomainVal;
    }

    public double getLowerDomainValN() {
        return this.lowerDomainValN;
    }

    public void setLowerDomainValN(double lowerDomainVal) {
        this.lowerDomainValN = lowerDomainVal;
    }

    public String getUpperDomainValD() {
        if (this.upperDomainValD != null) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            return format.format(this.upperDomainValD.getTime());
        }
        return null;
    }

    public void setUpperDomainValD(String upperDomainVal) {
        if (upperDomainVal != null) {
            if (!upperDomainVal.contains(":")) {
                upperDomainVal = upperDomainVal + ":00";
            }
            String[] component = upperDomainVal.split(":");
            int hour = Integer.parseInt(component[0]);
            int minute = Integer.parseInt(component[1]);
            this.upperDomainValD.set(11, hour);
            this.upperDomainValD.set(12, minute);
        }
    }

    public String getLowerDomainValD() {
        if (this.lowerDomainValD != null) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            return format.format(this.lowerDomainValD.getTime());
        }
        return null;
    }

    public void setLowerDomainValD(String lowerDomainVal) {
        if (lowerDomainVal != null) {
            if (!lowerDomainVal.contains(":")) {
                lowerDomainVal = lowerDomainVal + ":00";
            }
            String[] component = lowerDomainVal.split(":");
            int hour = Integer.parseInt(component[0]);
            int minute = Integer.parseInt(component[1]);
            this.lowerDomainValD.set(11, hour);
            this.lowerDomainValD.set(12, minute);
        }
    }
}

