/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleInsets;

public class VisualEnhancer
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = -4434675932582386052L;

    public void processChart(Object chart, Map params) {
        JFreeChart localChart = (JFreeChart)chart;
        Color borderPaint = new Color(0, 0, 0);
        boolean hasBorder = true;
        boolean rangeIncludesZero = true;
        boolean showDomainAxes = true;
        boolean showRangeAxes = true;
        double top = 1.0;
        double left = 1.0;
        double right = 1.0;
        double bottom = 1.0;
        double plotTop = 4.0;
        double plotLeft = 8.0;
        double plotRight = 8.0;
        double plotBottom = 4.0;
        String str = (String)params.get("top");
        if (str != null && str.trim().length() > 0) {
            try {
                top = Double.parseDouble(str);
                if (top < 0.0) {
                    top = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("left")) != null && str.trim().length() > 0) {
            try {
                left = Double.parseDouble(str);
                if (left < 0.0) {
                    left = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("right")) != null && str.trim().length() > 0) {
            try {
                right = Double.parseDouble(str);
                if (right < 0.0) {
                    right = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("bottom")) != null && str.trim().length() > 0) {
            try {
                bottom = Double.parseDouble(str);
                if (bottom < 0.0) {
                    bottom = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("plotTop")) != null && str.trim().length() > 0) {
            try {
                plotTop = Double.parseDouble(str);
                if (plotTop < 0.0) {
                    plotTop = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("plotLeft")) != null && str.trim().length() > 0) {
            try {
                plotLeft = Double.parseDouble(str);
                if (plotLeft < 0.0) {
                    plotLeft = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("plotRight")) != null && str.trim().length() > 0) {
            try {
                plotRight = Double.parseDouble(str);
                if (plotRight < 0.0) {
                    plotRight = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("plotBottom")) != null && str.trim().length() > 0) {
            try {
                plotBottom = Double.parseDouble(str);
                if (plotBottom < 0.0) {
                    plotBottom = 0.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("borderpaint")) != null && str.trim().length() > 0) {
            try {
                borderPaint = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("border")) != null) {
            hasBorder = "true".equals(str.toLowerCase());
        }
        if ((str = (String)params.get("rangeIncludesZero")) != null) {
            rangeIncludesZero = "true".equals(str.toLowerCase());
        }
        if ((str = (String)params.get("showDomainAxes")) != null) {
            showDomainAxes = "true".equals(str.toLowerCase());
        }
        if ((str = (String)params.get("showRangeAxes")) != null) {
            showRangeAxes = "true".equals(str.toLowerCase());
        }
        localChart.setBorderVisible(hasBorder);
        localChart.setBorderPaint((Paint)borderPaint);
        localChart.setPadding(new RectangleInsets(top, left, bottom, right));
        Plot plot = localChart.getPlot();
        plot.setInsets(new RectangleInsets(plotTop, plotLeft, plotBottom, plotRight));
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            ValueAxis axis = xyPlot.getRangeAxis();
            if (axis instanceof NumberAxis) {
                ((NumberAxis)axis).setAutoRangeIncludesZero(rangeIncludesZero);
            }
            if (!showDomainAxes) {
                xyPlot.clearDomainAxes();
            }
            if (!showRangeAxes) {
                xyPlot.clearRangeAxes();
            }
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot catPlot = (CategoryPlot)plot;
            ValueAxis axis = catPlot.getRangeAxis();
            if (axis instanceof NumberAxis) {
                ((NumberAxis)axis).setAutoRangeIncludesZero(rangeIncludesZero);
            }
            if (!showDomainAxes) {
                catPlot.clearDomainAxes();
            }
            if (!showRangeAxes) {
                catPlot.clearRangeAxes();
            }
        }
    }
}

