/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;

public class TitleEnhancer
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = 591686288142936677L;

    public void processChart(Object chart, Map params) {
        String italicParam;
        String boldParam;
        String backgroundpaintParam;
        String paintParam;
        String fontSizeParam;
        String fontNameParam;
        String titleParam;
        JFreeChart localChart = (JFreeChart)chart;
        String title = null;
        String type = "title";
        String fontName = "SansSerif";
        Color paint = null;
        Color backgroundPaint = null;
        int fontSize = 18;
        boolean isBold = true;
        boolean isItalic = false;
        String typeParam = (String)params.get("type");
        if (typeParam != null && typeParam.trim().length() > 0) {
            type = typeParam.trim();
        }
        if ((titleParam = (String)params.get("title")) != null && titleParam.trim().length() > 0) {
            title = titleParam.trim();
        }
        if ((fontNameParam = (String)params.get("fontname")) != null && fontNameParam.trim().length() > 0) {
            fontName = fontNameParam.trim();
        }
        if ((fontSizeParam = (String)params.get("fontsize")) != null && fontSizeParam.trim().length() > 0) {
            try {
                fontSize = Integer.parseInt(fontSizeParam);
                if (fontSize < 1) {
                    fontSize = 18;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((paintParam = (String)params.get("paint")) != null && paintParam.trim().length() > 0) {
            try {
                paint = Color.decode(paintParam);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((backgroundpaintParam = (String)params.get("backgroundpaint")) != null && backgroundpaintParam.trim().length() > 0) {
            try {
                backgroundPaint = Color.decode(backgroundpaintParam);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((boldParam = (String)params.get("bold")) != null) {
            isBold = "true".equals(boldParam.toLowerCase());
        }
        if ((italicParam = (String)params.get("italic")) != null) {
            isItalic = "true".equals(italicParam.toLowerCase());
        }
        if (title != null || "title".equals(type)) {
            TextTitle tt = null;
            if ("subtitle".equals(type)) {
                List subTitles = localChart.getSubtitles();
                Iterator iter = subTitles.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof TextTitle)) continue;
                    tt = (TextTitle)o;
                    break;
                }
                if (tt == null) {
                    tt = new TextTitle(title);
                    localChart.addSubtitle((Title)tt);
                }
            } else {
                tt = localChart.getTitle();
            }
            Font font = new Font(fontName, (isBold ? 1 : 0) + (isItalic ? 2 : 0), fontSize);
            tt.setFont(font);
            if (paint != null) {
                tt.setPaint((Paint)paint);
            }
            if (backgroundPaint != null) {
                tt.setBackgroundPaint((Paint)backgroundPaint);
            }
        }
    }
}

