/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.jfree.ThermometerPlot;
import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class ThermometerEnhancer
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = -8459734218848320685L;

    public void processChart(Object chart, Map params) {
        Plot plot;
        double lowerBound = 0.0;
        double warningPoint = 50.0;
        double criticalPoint = 75.0;
        double upperBound = 100.0;
        Color mercuryColor = Color.red;
        Color valueColor = Color.white;
        Color thermometerColor = Color.black;
        Color normalColor = Color.green;
        Color warningColor = Color.orange;
        Color criticalColor = Color.red;
        int units = 0;
        boolean useSubrangePaint = true;
        boolean subrangeIndicatorsVisible = true;
        String str = (String)params.get("mercuryColor");
        if (str != null && str.trim().length() > 0) {
            try {
                mercuryColor = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("thermometerColor")) != null && str.trim().length() > 0) {
            try {
                thermometerColor = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("valueColor")) != null && str.trim().length() > 0) {
            try {
                valueColor = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("subrangeColorNormal")) != null && str.trim().length() > 0) {
            try {
                normalColor = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("subrangeColorWarning")) != null && str.trim().length() > 0) {
            try {
                warningColor = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("subrangeColorCritical")) != null && str.trim().length() > 0) {
            try {
                criticalColor = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("lowerBound")) != null) {
            try {
                lowerBound = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("warningPoint")) != null) {
            try {
                warningPoint = Double.parseDouble(str);
                if (warningPoint < lowerBound || warningPoint > upperBound) {
                    warningPoint = 50.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("criticalPoint")) != null) {
            try {
                criticalPoint = Double.parseDouble(str);
                if (criticalPoint < warningPoint || criticalPoint > upperBound) {
                    criticalPoint = 75.0;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("upperBound")) != null) {
            try {
                upperBound = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("units")) != null) {
            if ("celsius".equals(str)) {
                units = 2;
            } else if ("fahrenheit".equals(str)) {
                units = 1;
            } else if ("kelvin".equals(str)) {
                units = 3;
            }
        }
        if ((str = (String)params.get("subrangeIndicatorsVisible")) != null) {
            subrangeIndicatorsVisible = "true".equals(str.toLowerCase());
        }
        if ((str = (String)params.get("useSubrangePaint")) != null) {
            useSubrangePaint = "true".equals(str.toLowerCase());
        }
        if ((plot = ((JFreeChart)chart).getPlot()) instanceof ThermometerPlot) {
            ThermometerPlot tplot = (ThermometerPlot)plot;
            tplot.setUnits(units);
            tplot.setUseSubrangePaint(false);
            tplot.setThermometerPaint(thermometerColor);
            tplot.setMercuryPaint(mercuryColor);
            tplot.setValuePaint(valueColor);
            tplot.setLowerBound(lowerBound);
            tplot.setSubrange(0, lowerBound, warningPoint);
            tplot.setSubrange(1, warningPoint, criticalPoint);
            tplot.setSubrange(2, criticalPoint, upperBound);
            tplot.setUpperBound(upperBound);
            tplot.setUseSubrangePaint(useSubrangePaint);
            tplot.setSubrangeIndicatorsVisible(subrangeIndicatorsVisible);
            tplot.setSubrangePaint(0, normalColor);
            tplot.setSubrangePaint(1, warningColor);
            tplot.setSubrangePaint(2, criticalColor);
        }
    }
}

