/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.util.Rotation;
import org.jfree.util.TableOrder;

public class SpiderWebEnhancer
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = 3693171934091003109L;

    public void processChart(Object chart, Map params) {
        Plot plot;
        double interiorGap = 0.25;
        double headPercent = 0.01;
        double startAngle = 0.0;
        boolean webFilled = true;
        boolean clockWise = false;
        boolean orderByRow = true;
        Color labelPaint = new Color(0, 0, 0);
        String labelFontName = "SansSerif";
        int labelFontSize = 10;
        boolean isBold = false;
        boolean isItalic = false;
        String str = (String)params.get("interiorGap");
        if (str != null) {
            try {
                interiorGap = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("headPercent")) != null) {
            try {
                headPercent = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("startAngle")) != null) {
            try {
                startAngle = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("webFilled")) != null) {
            webFilled = "true".equals(str);
        }
        if ((str = (String)params.get("clockWise")) != null) {
            clockWise = "true".equals(str);
        }
        if ((str = (String)params.get("orderByRow")) != null) {
            orderByRow = "true".equals(str);
        }
        if ((str = (String)params.get("labelPaint")) != null && str.trim().length() > 0) {
            try {
                labelPaint = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("labelFontName")) != null && str.trim().length() > 0) {
            labelFontName = str.trim();
        }
        if ((str = (String)params.get("labelFontSize")) != null && str.trim().length() > 0) {
            try {
                labelFontSize = Integer.parseInt(str);
                if (labelFontSize < 1) {
                    labelFontSize = 10;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("labelBold")) != null) {
            isBold = "true".equals(str.toLowerCase());
        }
        if ((str = (String)params.get("labelItalic")) != null) {
            isItalic = "true".equals(str.toLowerCase());
        }
        if ((plot = ((JFreeChart)chart).getPlot()) instanceof SpiderWebPlot) {
            SpiderWebPlot swplot = (SpiderWebPlot)plot;
            swplot.setStartAngle(startAngle);
            swplot.setInteriorGap(interiorGap);
            swplot.setHeadPercent(headPercent);
            swplot.setWebFilled(webFilled);
            swplot.setLabelPaint((Paint)labelPaint);
            Font font = new Font(labelFontName, (isBold ? 1 : 0) + (isItalic ? 2 : 0), labelFontSize);
            swplot.setLabelFont(font);
            if (clockWise) {
                swplot.setDirection(Rotation.CLOCKWISE);
            } else {
                swplot.setDirection(Rotation.ANTICLOCKWISE);
            }
            if (orderByRow) {
                swplot.setDataExtractOrder(TableOrder.BY_ROW);
            } else {
                swplot.setDataExtractOrder(TableOrder.BY_COLUMN);
            }
        }
    }
}

