/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class RotatedAxisLabels
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = 5242029033037971789L;

    public void processChart(Object chart, Map params) {
        String removeParam;
        int rotateThreshold = 1;
        int removeThreshold = 100;
        String rotateParam = (String)params.get("rotate_at");
        if (rotateParam != null && rotateParam.trim().length() > 0) {
            try {
                rotateThreshold = Integer.parseInt(rotateParam);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((removeParam = (String)params.get("remove_at")) != null && removeParam.trim().length() > 0) {
            try {
                removeThreshold = Integer.parseInt(removeParam);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        Plot plot = ((JFreeChart)chart).getPlot();
        CategoryAxis axis = null;
        int numValues = 0;
        if (plot instanceof CategoryPlot) {
            axis = ((CategoryPlot)plot).getDomainAxis();
            numValues = ((CategoryPlot)plot).getDataset().getRowCount();
        } else if (plot instanceof XYPlot) {
            axis = ((XYPlot)plot).getDomainAxis();
            numValues = ((XYPlot)plot).getDataset().getItemCount(0);
        } else if (plot instanceof FastScatterPlot) {
            axis = ((FastScatterPlot)plot).getDomainAxis();
            numValues = ((FastScatterPlot)plot).getData()[0].length;
        }
        if (axis instanceof CategoryAxis) {
            CategoryAxis catAxis = axis;
            if (rotateThreshold > 0) {
                if (numValues >= rotateThreshold) {
                    catAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                } else {
                    catAxis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
                }
            }
        } else if (axis instanceof ValueAxis) {
            ValueAxis valueAxis = (ValueAxis)axis;
            if (rotateThreshold > 0) {
                valueAxis.setVerticalTickLabels(numValues >= rotateThreshold);
            }
        }
        if (axis != null && removeThreshold > 0) {
            axis.setTickLabelsVisible(numValues < removeThreshold);
        }
    }
}

