/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.PieDataset;

public class PieEnhancer
implements ChartPostProcessor,
Serializable {
    private static final long serialVersionUID = 2295977907208852725L;

    public void processChart(Object chart, Map params) {
        Plot plot = ((JFreeChart)chart).getPlot();
        if (plot instanceof PiePlot) {
            PiePlot piePlot = (PiePlot)plot;
            double interiorGap = piePlot.getInteriorGap();
            double labelGap = piePlot.getLabelGap();
            double startAngle = piePlot.getStartAngle();
            boolean simpleLabels = piePlot.getSimpleLabels();
            String str = (String)params.get("interiorGap");
            if (str != null) {
                try {
                    interiorGap = Double.parseDouble(str);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((str = (String)params.get("labelGap")) != null) {
                try {
                    labelGap = Double.parseDouble(str);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((str = (String)params.get("startAngle")) != null) {
                try {
                    startAngle = Double.parseDouble(str);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((str = (String)params.get("simpleLabels")) != null) {
                simpleLabels = "true".equals(str);
            }
            piePlot.setSimpleLabels(simpleLabels);
            piePlot.setInteriorGap(interiorGap);
            piePlot.setLabelGap(labelGap);
            piePlot.setStartAngle(startAngle);
            if (!(plot instanceof PiePlot3D)) {
                PieDataset ds = piePlot.getDataset();
                Iterator paramIter = params.entrySet().iterator();
                while (paramIter.hasNext()) {
                    Map.Entry entry = paramIter.next();
                    String paramKey = (String)entry.getKey();
                    if (!paramKey.startsWith("explode_")) continue;
                    double explodePercent = Double.valueOf(paramKey.substring(8));
                    String paramValue = (String)entry.getValue();
                    Iterator keyIter = ds.getKeys().iterator();
                    while (keyIter.hasNext()) {
                        Comparable key = (Comparable)keyIter.next();
                        if (!key.equals(paramValue)) continue;
                        piePlot.setExplodePercent(key, explodePercent);
                    }
                }
            }
        }
    }
}

