/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.jfree.XYConditionRenderer;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class LineRendererProcessor
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = -1915129061254557434L;

    public void processChart(Object chart, Map params) {
        XYPlot xyPlot;
        XYItemRenderer xyRenderer;
        JFreeChart localChart = (JFreeChart)chart;
        Plot plot = localChart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryPlot catPlot = (CategoryPlot)plot;
            CategoryItemRenderer ciRenderer = catPlot.getRenderer();
            if (ciRenderer instanceof LineAndShapeRenderer) {
                LineAndShapeRenderer lasRenderer = (LineAndShapeRenderer)ciRenderer;
                boolean shapes = false;
                String str = (String)params.get("shapes");
                if (str != null) {
                    shapes = "true".equals(str);
                }
                lasRenderer.setBaseShapesVisible(shapes);
                boolean outline = false;
                str = (String)params.get("outline");
                if (str != null) {
                    outline = "true".equals(str);
                }
                lasRenderer.setDrawOutlines(outline);
                boolean useFillPaint = false;
                str = (String)params.get("useFillPaint");
                if (str != null) {
                    useFillPaint = "true".equals(str);
                }
                lasRenderer.setUseFillPaint(useFillPaint);
                if (useFillPaint && (str = (String)params.get("fillPaint")) != null && str.trim().length() > 0) {
                    try {
                        Color fillPaint = Color.decode(str);
                        lasRenderer.setBaseFillPaint((Paint)fillPaint);
                    }
                    catch (NumberFormatException nfex) {
                        // empty catch block
                    }
                }
                boolean useOutlinePaint = false;
                str = (String)params.get("useOutlinePaint");
                if (str != null) {
                    useOutlinePaint = "true".equals(str);
                }
                lasRenderer.setUseOutlinePaint(useOutlinePaint);
                if (useOutlinePaint && (str = (String)params.get("outlinePaint")) != null && str.trim().length() > 0) {
                    try {
                        Color outlinePaint = Color.decode(str);
                        lasRenderer.setBaseOutlinePaint((Paint)outlinePaint);
                    }
                    catch (NumberFormatException nfex) {}
                }
            }
        } else if (plot instanceof XYPlot && (xyRenderer = (xyPlot = (XYPlot)plot).getRenderer()) instanceof XYConditionRenderer) {
            XYConditionRenderer xyCondRender = (XYConditionRenderer)xyRenderer;
            boolean shapes = false;
            String str = (String)params.get("shapes");
            if (str != null) {
                shapes = "true".equals(str);
            }
            xyCondRender.setBaseShapesVisible(shapes);
            boolean outline = false;
            str = (String)params.get("outline");
            if (str != null) {
                outline = "true".equals(str);
            }
            xyCondRender.setDrawOutlines(outline);
            boolean useFillPaint = false;
            str = (String)params.get("useFillPaint");
            if (str != null) {
                useFillPaint = "true".equals(str);
            }
            xyCondRender.setUseFillPaint(useFillPaint);
            if (useFillPaint && (str = (String)params.get("fillPaint")) != null && str.trim().length() > 0) {
                try {
                    Color fillPaint = Color.decode(str);
                    xyCondRender.setBaseFillPaint(fillPaint);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            boolean useOutlinePaint = false;
            str = (String)params.get("useOutlinePaint");
            if (str != null) {
                useOutlinePaint = "true".equals(str);
            }
            xyCondRender.setUseOutlinePaint(useOutlinePaint);
            if (useOutlinePaint && (str = (String)params.get("outlinePaint")) != null && str.trim().length() > 0) {
                try {
                    Color outlinePaint = Color.decode(str);
                    xyCondRender.setBaseOutlinePaint(outlinePaint);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((str = (String)params.get("shapeVisibleCondition")) != null) {
                xyCondRender.setShapeVisibleCondition(str);
            }
            if ((str = (String)params.get("shapeFilledCondition")) != null) {
                xyCondRender.setShapeFilledCondition(str);
            }
        }
    }
}

