/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.StandardDialScale;

public class DialEnhancer
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = 6708371054518325470L;

    public void processChart(Object chart, Map params) {
        Plot plot;
        String pointerType = "pointer";
        String dialText = null;
        Color capFillPaint = new Color(0, 0, 0);
        Color capOutlinePaint = new Color(255, 255, 255);
        double capRadius = 0.05;
        boolean setCap = false;
        double lowerBound = 0.0;
        double upperBound = 100.0;
        double majorTickIncrement = 10.0;
        int minorTickCount = 4;
        boolean setScale = false;
        String str = (String)params.get("pointerType");
        if (str != null && str.trim().length() > 0) {
            pointerType = str.trim();
        }
        if ((str = (String)params.get("dialText")) != null && str.trim().length() > 0) {
            dialText = str.trim();
        }
        if ((str = (String)params.get("capRadius")) != null) {
            try {
                capRadius = Double.parseDouble(str);
                setCap = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("capFill")) != null && str.trim().length() > 0) {
            try {
                capFillPaint = Color.decode(str);
                setCap = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("capOutline")) != null && str.trim().length() > 0) {
            try {
                capOutlinePaint = Color.decode(str);
                setCap = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("lowerBound")) != null) {
            try {
                lowerBound = Double.parseDouble(str);
                setScale = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("upperBound")) != null) {
            try {
                upperBound = Double.parseDouble(str);
                setScale = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("majorTickIncrement")) != null) {
            try {
                majorTickIncrement = Double.parseDouble(str);
                setScale = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("minorTickCount")) != null) {
            try {
                minorTickCount = Integer.parseInt(str);
                setScale = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((plot = ((JFreeChart)chart).getPlot()) instanceof DialPlot) {
            DialPlot dplot = (DialPlot)plot;
            if ("pin".equals(pointerType)) {
                dplot.removePointer(0);
                dplot.addPointer((DialPointer)new DialPointer.Pin());
            } else if ("pointer".equals(pointerType)) {
                dplot.removePointer(0);
                dplot.addPointer((DialPointer)new DialPointer.Pointer());
            }
            if (setCap) {
                DialCap cap = new DialCap();
                cap.setRadius(capRadius);
                cap.setFillPaint((Paint)capFillPaint);
                cap.setOutlinePaint((Paint)capOutlinePaint);
                dplot.setCap((DialLayer)cap);
            }
            if (setScale) {
                StandardDialScale scale = (StandardDialScale)dplot.getScale(0);
                scale.setLowerBound(lowerBound);
                scale.setUpperBound(upperBound);
                scale.setMajorTickIncrement(majorTickIncrement);
                scale.setMinorTickCount(minorTickCount);
            }
            if (dialText != null) {
                DialTextAnnotation annotation = new DialTextAnnotation(dialText);
                annotation.setFont(new Font("Dialog", 1, 10));
                annotation.setRadius(0.35);
                annotation.setAngle(90.0);
                dplot.addLayer((DialLayer)annotation);
            }
        }
    }
}

