/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.Plot;

public class CompassEnhancer
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = -1392284687232625608L;

    public void processChart(Object chart, Map params) {
        Plot plot;
        String needleType = "arrow";
        boolean drawBorder = false;
        Color needleFill = new Color(0, 0, 0);
        Color needleOutline = new Color(0, 0, 0);
        String str = (String)params.get("needleType");
        if (str != null && str.trim().length() > 0) {
            needleType = str.trim();
        }
        if ((str = (String)params.get("needleFill")) != null && str.trim().length() > 0) {
            try {
                needleFill = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("needleOutline")) != null && str.trim().length() > 0) {
            try {
                needleOutline = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("drawBorder")) != null) {
            drawBorder = "true".equals(str);
        }
        if ((plot = ((JFreeChart)chart).getPlot()) instanceof CompassPlot) {
            CompassPlot cplot = (CompassPlot)plot;
            cplot.setDrawBorder(drawBorder);
            if ("line".equals(needleType)) {
                cplot.setSeriesNeedle(1);
            } else if ("long".equals(needleType)) {
                cplot.setSeriesNeedle(2);
            } else if ("pin".equals(needleType)) {
                cplot.setSeriesNeedle(3);
            } else if ("plum".equals(needleType)) {
                cplot.setSeriesNeedle(4);
            } else if ("pointer".equals(needleType)) {
                cplot.setSeriesNeedle(5);
            } else if ("ship".equals(needleType)) {
                cplot.setSeriesNeedle(6);
            } else if ("wind".equals(needleType)) {
                cplot.setSeriesNeedle(7);
            } else if ("arrow".equals(needleType)) {
                cplot.setSeriesNeedle(8);
            } else if ("middlepin".equals(needleType)) {
                cplot.setSeriesNeedle(9);
            }
            cplot.setSeriesPaint(0, (Paint)needleFill);
            cplot.setSeriesOutlinePaint(0, (Paint)needleOutline);
        }
    }
}

