/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;

public class BarRendererProcessor
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = 6687503315061004361L;

    public void processChart(Object chart, Map params) {
        CategoryPlot catPlot;
        CategoryItemRenderer ciRenderer;
        JFreeChart localChart = (JFreeChart)chart;
        Plot plot = localChart.getPlot();
        if (plot instanceof CategoryPlot && (ciRenderer = (catPlot = (CategoryPlot)plot).getRenderer()) instanceof BarRenderer) {
            boolean outline = false;
            boolean showItemLabels = false;
            boolean categoryColors = false;
            double itemMargin = 0.2;
            Color itemLabelColor = new Color(0, 0, 0);
            String str = (String)params.get("outline");
            if (str != null) {
                outline = "true".equals(str);
            }
            if ((str = (String)params.get("showItemLabels")) != null) {
                showItemLabels = "true".equals(str);
            }
            if ((str = (String)params.get("categoryColors")) != null) {
                categoryColors = "true".equals(str);
            }
            if ((str = (String)params.get("itemLabelColor")) != null && str.trim().length() > 0) {
                try {
                    itemLabelColor = Color.decode(str);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((str = (String)params.get("itemMargin")) != null && str.trim().length() > 0) {
                try {
                    itemMargin = Double.parseDouble(str);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if (categoryColors) {
                String colorStr;
                ArrayList<Color> paints = new ArrayList<Color>();
                int i = 0;
                while ((colorStr = (String)params.get(String.valueOf(i))) != null) {
                    paints.add(Color.decode(colorStr));
                    ++i;
                }
                if (ciRenderer instanceof BarRenderer3D) {
                    catPlot.setRenderer((CategoryItemRenderer)new CustomBarRenderer3D(paints));
                } else if (ciRenderer instanceof BarRenderer) {
                    catPlot.setRenderer((CategoryItemRenderer)new CustomBarRenderer(paints));
                }
                ciRenderer = catPlot.getRenderer();
            }
            BarRenderer renderer = (BarRenderer)ciRenderer;
            renderer.setDrawBarOutline(outline);
            renderer.setItemMargin(itemMargin);
            if (showItemLabels) {
                renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                renderer.setBaseItemLabelsVisible(true);
                renderer.setBaseItemLabelPaint((Paint)itemLabelColor);
            }
        }
    }

    private class CustomBarRenderer3D
    extends BarRenderer3D {
        static final long serialVersionUID = 2674255384600916413L;
        private List colors;

        public CustomBarRenderer3D(List colors) {
            this.colors = colors;
        }

        public Paint getItemPaint(int row, int column) {
            return (Paint)this.colors.get(column % this.colors.size());
        }
    }

    private class CustomBarRenderer
    extends BarRenderer {
        static final long serialVersionUID = 2451764538621611708L;
        private List colors;

        public CustomBarRenderer(List colors) {
            this.colors = colors;
        }

        public Paint getItemPaint(int row, int column) {
            return (Paint)this.colors.get(column % this.colors.size());
        }
    }
}

