/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.cpp;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.annotations.TextAnnotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.TextAnchor;

public class AnnotationProcessor
implements ChartPostProcessor,
Serializable {
    static final long serialVersionUID = 6321794363389448612L;

    public void processChart(Object chart, Map params) {
        Plot plot;
        String italicParam;
        String boldParam;
        String fontSizeParam;
        String fontNameParam;
        String text = "text goes here";
        String fontName = "SansSerif";
        int fontSize = 14;
        boolean isBold = false;
        boolean isItalic = false;
        double x = 0.0;
        double y = 0.0;
        String category = null;
        double value = 0.0;
        TextAnchor textAnchor = TextAnnotation.DEFAULT_TEXT_ANCHOR;
        Color textPaint = new Color(0, 0, 0);
        Color arrowPaint = new Color(0, 0, 0);
        double arrowAngle = 0.0;
        boolean drawArrow = false;
        String str = (String)params.get("text");
        if (str != null && str.trim().length() > 0) {
            text = str.trim();
        }
        if ((fontNameParam = (String)params.get("fontname")) != null && fontNameParam.trim().length() > 0) {
            fontName = fontNameParam.trim();
        }
        if ((fontSizeParam = (String)params.get("fontsize")) != null && fontSizeParam.trim().length() > 0) {
            try {
                fontSize = Integer.parseInt(fontSizeParam);
                if (fontSize < 4) {
                    fontSize = 14;
                }
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((boldParam = (String)params.get("bold")) != null) {
            isBold = "true".equals(boldParam.toLowerCase());
        }
        if ((italicParam = (String)params.get("italic")) != null) {
            isItalic = "true".equals(italicParam.toLowerCase());
        }
        Font font = new Font(fontName, (isBold ? 1 : 0) + (isItalic ? 2 : 0), fontSize);
        str = (String)params.get("x");
        if (str != null) {
            try {
                x = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("y")) != null) {
            try {
                y = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("category")) != null && str.trim().length() > 0) {
            category = str.trim();
        }
        if ((str = (String)params.get("value")) != null) {
            try {
                value = Double.parseDouble(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("textPaint")) != null && str.trim().length() > 0) {
            try {
                textPaint = Color.decode(str);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("arrowPaint")) != null && str.trim().length() > 0) {
            try {
                arrowPaint = Color.decode(str);
                drawArrow = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("arrowAngle")) != null) {
            try {
                arrowAngle = Double.parseDouble(str);
                drawArrow = true;
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
        }
        if ((str = (String)params.get("textAnchor")) != null) {
            if ("BASELINE_CENTER".equals(str)) {
                textAnchor = TextAnchor.BASELINE_CENTER;
            } else if ("BASELINE_LEFT".equals(str)) {
                textAnchor = TextAnchor.BASELINE_LEFT;
            } else if ("BASELINE_RIGHT".equals(str)) {
                textAnchor = TextAnchor.BASELINE_RIGHT;
            } else if ("BOTTOM_CENTER".equals(str)) {
                textAnchor = TextAnchor.BOTTOM_CENTER;
            } else if ("BOTTOM_LEFT".equals(str)) {
                textAnchor = TextAnchor.BOTTOM_LEFT;
            } else if ("BOTTOM_RIGHT".equals(str)) {
                textAnchor = TextAnchor.BOTTOM_RIGHT;
            } else if ("CENTER".equals(str)) {
                textAnchor = TextAnchor.CENTER;
            } else if ("CENTER_LEFT".equals(str)) {
                textAnchor = TextAnchor.CENTER_LEFT;
            } else if ("CENTER_RIGHT".equals(str)) {
                textAnchor = TextAnchor.CENTER_RIGHT;
            } else if ("HALF_ASCENT_CENTER".equals(str)) {
                textAnchor = TextAnchor.HALF_ASCENT_CENTER;
            } else if ("HALF_ASCENT_LEFT".equals(str)) {
                textAnchor = TextAnchor.HALF_ASCENT_LEFT;
            } else if ("HALF_ASCENT_RIGHT".equals(str)) {
                textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
            } else if ("TOP_CENTER".equals(str)) {
                textAnchor = TextAnchor.TOP_CENTER;
            } else if ("TOP_LEFT".equals(str)) {
                textAnchor = TextAnchor.TOP_LEFT;
            } else if ("TOP_RIGHT".equals(str)) {
                textAnchor = TextAnchor.TOP_RIGHT;
            }
        }
        if ((plot = ((JFreeChart)chart).getPlot()) instanceof XYPlot) {
            XYPointerAnnotation anno = drawArrow ? new XYPointerAnnotation(text, x, y, arrowAngle) : new XYTextAnnotation(text, x, y);
            anno.setPaint((Paint)textPaint);
            anno.setFont(font);
            anno.setTextAnchor(textAnchor);
            if (drawArrow) {
                anno.setArrowPaint((Paint)arrowPaint);
            }
            ((XYPlot)plot).addAnnotation((XYAnnotation)anno);
        } else if (plot instanceof CategoryPlot) {
            CategoryPointerAnnotation anno = drawArrow ? new CategoryPointerAnnotation(text, (Comparable)((Object)category), value, arrowAngle) : new CategoryTextAnnotation(text, (Comparable)((Object)category), value);
            anno.setPaint((Paint)textPaint);
            anno.setFont(font);
            anno.setTextAnchor(textAnchor);
            if (drawArrow) {
                anno.setArrowPaint((Paint)arrowPaint);
            }
            ((CategoryPlot)plot).addAnnotation((CategoryAnnotation)anno);
        }
    }
}

