/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.Storage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class Configuration
implements Serializable {
    static final long serialVersionUID = -3271334302902082721L;
    public static final String KEY = Configuration.class.getName();
    private static final String DEFAULT_OVERLIB_URL = "overlib.js";
    private static final String DEFAULT_STORAGE = "de.laures.cewolf.storage.TransientSessionStorage";
    private String overlibURL = "overlib.js";
    private boolean debugged = false;
    private String storageClassName = "de.laures.cewolf.storage.TransientSessionStorage";
    private Storage storage = null;
    private Map parameters = new HashMap();

    private Configuration() {
    }

    protected Configuration(ServletContext ctx) {
        ctx.log("configuring cewolf app..");
        ctx.setAttribute(KEY, (Object)this);
        ServletConfig config = (ServletConfig)ctx.getAttribute("CewolfRenderer_Init_Config");
        if (config != null) {
            Enumeration initParams = config.getInitParameterNames();
            try {
                while (initParams.hasMoreElements()) {
                    String param = (String)initParams.nextElement();
                    String value = config.getInitParameter(param);
                    if ("debug".equalsIgnoreCase(param)) {
                        this.debugged = Boolean.valueOf(value);
                    } else if ("overliburl".equalsIgnoreCase(param)) {
                        this.overlibURL = value;
                    } else if ("storage".equalsIgnoreCase(param)) {
                        this.storageClassName = value;
                    } else {
                        ctx.log(param + " parameter is ignored.");
                    }
                    this.parameters.put(param, value);
                }
            }
            catch (Throwable t) {
                ctx.log("Error in Cewolf config.", t);
            }
        } else {
            ctx.log("Cewolf Misconfiguration. You should add a <load-on-startup> tag to your web.xml for the Cewolf rendering servlet.\nA default Configuration will be used if not.");
        }
        try {
            this.initStorage(ctx);
        }
        catch (CewolfException ex) {
            ctx.log("exception during storage init from class " + this.storageClassName);
            ctx.log("using de.laures.cewolf.storage.TransientSessionStorage");
            this.storageClassName = DEFAULT_STORAGE;
            try {
                this.initStorage(ctx);
            }
            catch (CewolfException cwex) {
                cwex.printStackTrace();
                throw new RuntimeException(this.storageClassName + ".init() threw exception.");
            }
        }
        ctx.log("using storage class " + this.storageClassName);
        ctx.log("using overlibURL " + this.overlibURL);
        ctx.log("debugging is turned " + (this.debugged ? "on" : "off"));
        ctx.log("...done.");
    }

    private void initStorage(ServletContext ctx) throws CewolfException {
        try {
            this.storage = (Storage)Class.forName(this.storageClassName).newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CewolfException(ex.getMessage());
        }
        this.storage.init(ctx);
    }

    public static Configuration getInstance(ServletContext ctx) {
        Configuration config = null;
        try {
            config = (Configuration)ctx.getAttribute(KEY);
        }
        catch (ClassCastException ex) {
            ctx.log("Configuration on context is wrong class");
        }
        if (config == null) {
            ctx.log("No Configuration for this context. Initializing.");
            config = new Configuration(ctx);
            ctx.setAttribute(KEY, (Object)config);
        }
        return config;
    }

    public boolean isDebugged() {
        return this.debugged;
    }

    public String getOverlibURL() {
        return this.overlibURL;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Map getParameters() {
        return this.parameters;
    }
}

