# smf

A mighty RPC.

[flatbuffers](http://google.github.io/flatbuffers/) + [seastar](http://seastar-project.org)

# generator:

```bash
$> smf_gen --logtostderr --filename flatbuffers_idl_example.fbs

```

## generated

From this schema:

```protobuf
namespace smf_gen.fbs.rpc;

table Request {
  name: string;
}

table Response {
  name: string;
}


rpc_service SmfStorage {
  Get(Request):Response;
}

```

The generated code looks like this:


```cpp

// Generated by the smf_gen.
// Any local changes WILL BE LOST.
// source: ../src/rpc/smf_gen/demo_service
#pragma once
#ifndef SMF_DEMO_SERVICE__INCLUDED
#define SMF_DEMO_SERVICE__INCLUDED

#include "demo_service_generated.h"

#include <experimental/optional>
#include <rpc/rpc_service.h>
#include <rpc/rpc_client.h>
#include <rpc/rpc_recv_context.h>
#include "platform/log.h"
namespace smf_gen {
namespace fbs {
namespace rpc {

class SmfStorage: public smf::rpc_service {
 public:
  virtual const char *service_name() const override final {
    return "SmfStorage";
  }
  virtual uint32_t service_id() const override final {
    return 1969906889;
  }
  virtual std::vector<smf::rpc_service_method_handle> methods() override final {
    using h = smf::rpc_service_method_handle;
    std::vector<h> handles;
    handles.emplace_back(
      "Get", 3312871568,
      [this](smf::rpc_recv_context c) -> seastar::future<smf::rpc_envelope> {
        return Get(std::move(c));
    });
    return handles;
  }
  virtual seastar::future<smf::rpc_envelope>
  Get(smf::rpc_recv_context rec) {
    /*Input type: Request*/
    /*Output type: Response*/
    smf::rpc_envelope e(nullptr);
    // Helpful for clients to set the status.
    // Typically follows HTTP style. Not imposed by smf whatsoever.
    e.set_status(200);
    return seastar::make_ready_future<smf::rpc_envelope>(std::move(e));
  }
}; // end of service: SmfStorage

class SmfStorageClient: public smf::rpc_client {
 public:
  SmfStorageClient(ipv4_addr server_addr)
  :smf::rpc_client(std::move(server_addr)) {}

  seastar::future<smf::rpc_recv_ctx_t<Response>>
  GetSend(smf::rpc_envelope req) {
    // RequestID: 1969906889 ^ 3312871568
    // ServiceID: 1969906889 == crc32(ServiceName)
    // MethodID:  3312871568 == crc32(MethodName)
    req.set_request_id(1969906889, 3312871568);
    return send<Response>(req.to_temp_buf(),false);
  }
}; // end of rpc client: SmfStorageClient

}  // namespace rpc
}  // namespace fbs
}  // namespace smf_gen


#endif  // SMF_DEMO_SERVICE__INCLUDED

```

This is how you would set up a distributed load test for a remote server

```cpp

int main(int args, char **argv, char **env) {
  std::cerr << "About to start the client" << std::endl;
  app_template app;
  distributed<rpc_client_wrapper> clients;
  // leak memory
  try {
    return app.run_deprecated(args, argv, [&] {
      LOG_INFO("setting up exit hooks");
      engine().at_exit([&] { return clients.stop(); });
      return clients.start().then([&clients] {
        LOG_INFO("About to send a distributed set of requests to server");
        return clients.invoke_on_all(&rpc_client_wrapper::send_request);
      });
    });
  } catch(...) {
    std::cerr << "Fatal exception: " << std::current_exception() << std::endl;
  }
}
```


This is how you would set up a server


```cpp

int main(int args, char **argv, char **env) {
  std::cerr << "About to start the app" << std::endl;
  distributed<smf::rpc_server_stats> stats;
  distributed<smf::rpc_server> rpc;
  smf::rpc_server_stats_printer stats_printer(stats);
  app_template app;
  app.add_options()("rpc_port", bpo::value<uint16_t>()->default_value(11225),
                    "rpc port");
  return app.run_deprecated(args, argv, [&] {
    LOG_INFO("Setting up at_exit hooks");
    engine().at_exit([&] { return rpc.stop(); });
    engine().at_exit([&] { return stats.stop(); });


    auto &&config = app.configuration();
    uint16_t port = config["rpc_port"].as<uint16_t>();
    LOG_INFO("starting stats");
    return stats.start()
      .then([&rpc, &stats, port] {
        return rpc.start(&stats, port)
          .then([&rpc] {
            LOG_INFO("Registering smf_gen::fbs::rpc::storage_service");

            // THIS IS THE MOST IMPORTANT LINE:
            // HOWTO REGISTER YOUR FLATBUFFERS SERVICE
            //

            return rpc.invoke_on_all(
              &smf::rpc_server::register_service<storage_service>);
          });
      })
      .then([&rpc] {
        LOG_INFO("Invoking rpc start on all cores");
        return rpc.invoke_on_all(&smf::rpc_server::start);
      });
  });
}

```



## TODO

Please help with these!

* Finisht the limits integration



