---
layout: post
title:  reproducible deps 
---


# Dependencies: 

`smf` comes with the ability to fetch and build transitive dependencies on it's own at known
revisions for reproducible builds. 

To enable reproducible builds, simply invoke cmake like so:

`mkdir build &&  cmake -GNinja -DSMF_MANAGE_DEPS=ON -DCMAKE_BUILD_TYPE=Release .. `

By default automatic dep management is off (i.e.: `-DSMF_MANAGE_DEPS=OFF`) so you can 
use smf as part of a larger cmake project

# Example app

```

➜  release git:(master) ✗ ldd bin/smf_demo_client 

        # system deps required

        linux-vdso.so.1 (0x00007ffdd8364000)
        libpthread.so.0 => /lib64/libpthread.so.0 (0x00007fe397aec000)
        libdl.so.2 => /lib64/libdl.so.2 (0x00007fe397749000)
        libatomic.so.1 => /lib64/libatomic.so.1 (0x00007fe39754b000)
        librt.so.1 => /lib64/librt.so.1 (0x00007fe3972e3000)
        libstdc++.so.6 => /lib64/libstdc++.so.6 (0x00007fe3970fe000)
        libm.so.6 => /lib64/libm.so.6 (0x00007fe396f7a000)
        libgcc_s.so.1 => /lib64/libgcc_s.so.1 (0x00007fe396f5f000)
        libc.so.6 => /lib64/libc.so.6 (0x00007fe396d99000)
        /lib64/ld-linux-x86-64.so.2 (0x00007fe397b35000)
        
        # optionally manage deps
        
        libgnutls.so.30 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libgnutls.so.30 (0x00007fe397555000)
        libsctp.so.1 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libsctp.so.1 (0x00007fe397546000)
        libprotobuf.so.13 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libprotobuf.so.13 (0x00007fe3972ed000)
        libhwloc.so.5 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libhwloc.so.5 (0x00007fe3972a5000)
        libnuma.so.1 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libnuma.so.1 (0x00007fe397298000)
        libcares.so.2 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libcares.so.2 (0x00007fe397ad8000)
        libcryptopp.so.5.6 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib64/libcryptopp.so.5.6 (0x00007fe397766000)
        liblz4.so.1 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib64/liblz4.so.1 (0x00007fe39774f000)
        libz.so.1 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libz.so.1 (0x00007fe396d7c000)
        libnettle.so.6 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libnettle.so.6 (0x00007fe396d36000)
        libhogweed.so.4 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libhogweed.so.4 (0x00007fe396cf6000)
        libgmp.so.10 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libgmp.so.10 (0x00007fe396c80000)
        libpciaccess.so.0 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libpciaccess.so.0 (0x00007fe396c76000)
        libxml2.so.2 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/libxml2.so.2 (0x00007fe396b11000)
        liblzma.so.5 => /home/agallego/workspace/smf/build/release/smf-deps-install/lib/liblzma.so.5 (0x00007fe396ae9000)

```

# Next steps / help wanted

I'd love to make most of the dependencies statically compiled into the final binary. 

The only issue I ran into was w/ the TLS libraries. 

`protobuf, cares, lz4, z, lzma, xml2` are easy to change. They already produce the `.a` files for linking. 

The only remaining problematic libs are `hwloc, numa, gnutls, nettle, hogweed, gmp`

