# FONTLOG for Nupuram

This file provides detailed information on the Nupuram font software. This
information should be distributed along with the Nupuram fonts and any derivative
works.

## Basic Font Information

Nupuram is a Malayalam typeface with regular, bold, thin variants. Nupuram means anklet. This is the third font after Chilanka and Manjari fonts by Santhosh Thottingal.

Designer: Santhosh Thottingal

Nupuram development is currently hosted at:
http://gitlab.com/smc/fonts/Nupuram

Released versions of this font is available at [smc.org.in/fonts](smc.org.in/fonts) for download. For old versions and detailed changelog, see https://gitlab.com/smc/fonts/Nupuram/-/releases. Feature requests, bug reports and patches should be directed to our issue
tracker.

## Design Inspiration

Nupuram is inspired by the title posters of early Malayalam movies around 1960-1970, specifically by title designer S Appukkuttan Nair(Popularly known as [SA Nair](https://m3db.com/sa-nair)).  These title designs featured wide, flat, sharp terminals, thin vertical strokes and thick horizontal strokes(Examples: [1](https://m3db.com/film/thakilu-kottampuram), [2](https://m3db.com/film/vilakkum-velichavum), [3](https://m3db.com/film/angadi), [4](https://m3db.com/film/1283)). Even though there are hundreds of posters done by SA Nair with same design concept, there is no strict uniformity in these designs as they are all handmade. Adpating it to a typeface required many customization. I avoided the sharpness of terminals, but retained the wide strokes with reduced thickness. The Nupuram Display may be the style that is more close to these designs.

Nupuram is the third Malayalam typeface I am designing. The style is between the [Chilanka](https://smc.org.in/fonts/Chilanka) handwriting font and [Manjari](https://smc.org.in/fonts/Manjari) typeface. Chilanka is raw and handwriting. It is very informal. Manjari is regular font for formal style, but with a humanistic design. Nupuram is neither too formal nor too informal.

Nupuram is primarily a Malayalam typeface, but it also has latin support. The matching design for latin is a [reverse contrast](https://en.wikipedia.org/wiki/Reverse-contrast_typefaces) design. I made my best effort. I would love to hear the feedback.

The word Nupuram means '[anklet](https://en.wikipedia.org/wiki/Anklet)'.

## Acknowledgements

(in no particular order)

* [Donald Ervin Knuth](https://en.wikipedia.org/wiki/Donald_Knuth) for inspiration, TeX, Metafont, for his detailed books on these topics.
* John D. Hobby. [A METAFONT-like System with PostScript Output](http://www.tug.org/TUGboat/Articles/tb10-4/tb26hobby.pdf). TUGboat, 10(4), 1989.
* [MetaType1](https://mirror.ctan.org/fonts/utilities/metatype1/), a font development system using MetaPost, by Bogusław Jackowski, Janus M. Nowacki, Piotr Strzelczyk. The metapost macros(`plain_ex.mp`) from metatype1 package made this font feasible.
* John D. Hobby. [METAPOST — A User’s Manual](http://www.tug.org/docs/metapost/mpman.pdf.), 2008.
* Swathanthra Malayalam computing and its volunteers for all help and support.
* [Latin letter construction](https://www.kellscraft.com/EssentialsofLettering/EssentialsofLetteringCh02.html)
* [Of the Just Shaping of Letters  Author: Albrecht Dürer](https://www.gutenberg.org/files/37103/37103-h/37103-h.htm)
* [The Recursive project](https://github.com/arrowtype/recursive/) from where I learned a lot on technical aspects and copied the documentation style.
* [Wakamai Fondue](https://wakamaifondue.com) for variable font testing.
* [Axis Praxis](https://axis-praxis.org/) for variable font testing.
* [DJR's color font customizer](https://tools.djr.com/color-font-customizer/) for Color font testing
* [DJR's Bungee font](https://github.com/djrrb/Bungee) font for studying the Color font gradient concepts
* [FontFeatures](https://github.com/simoncozens/fontFeatures) python library by Simon Cozens helped programmatic generation of Opentype feature files.
* [Gayathri Ashokan](https://en.wikipedia.org/wiki/Gayathri_Ashokan), poster designer in Malayalam film industry for inputs on the designs by SA Nair.
* Jonathan Hoefler for [the latin kerning tests](https://github.com/hoeflerco/proofs)
* more to add...

For a complete list of authors who contributed to the project, see CONTRIBUTORS.md
