from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="ProvisionerClaims")


@_attrs_define
class ProvisionerClaims:
    """A set of constraints configuring how this provisioner can be used to issue certificates.

    Example:
        {'allowRenewalAfterExpiry': True, 'defaultHostSSHCertDuration': '168h', 'defaultTLSCertDuration': '24h',
            'defaultUserSSHCertDuration': '12h', 'disableRenewal': False, 'enableSSHCA': True, 'maxHostSSHCertDuration':
            '168h', 'maxTLSCertDuration': '168h', 'maxUserSSHCertDuration': '24h', 'minHostSSHCertDuration': '48h',
            'minTLSCertDuration': '1h', 'minUserSSHCertDuration': '4h'}

    Attributes:
        allow_renewal_after_expiry (Union[Unset, bool]): Allow renewals for expired certificates generated by this
            provisioner.
        default_host_ssh_cert_duration (Union[Unset, str]): The default duration for an SSH host certificate generated
            by this provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        default_tls_cert_duration (Union[Unset, str]): The default duration for an x509 certificate generated by this
            provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        default_user_ssh_cert_duration (Union[Unset, str]): The default duration for an SSH user certificate generated
            by this provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        disable_renewal (Union[Unset, bool]): Disable renewal for all certificates generated by this provisioner.
        enable_sshca (Union[Unset, bool]): Allow this provisioner to be used to generate SSH certificates.
        max_host_ssh_cert_duration (Union[Unset, str]): The maximum duration for an SSH host certificate generated by
            this provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        max_tls_cert_duration (Union[Unset, str]): The maximum duration for an x509 certificate generated by this
            provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        max_user_ssh_cert_duration (Union[Unset, str]): The maximum duration for an SSH user certificate generated by
            this provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        min_host_ssh_cert_duration (Union[Unset, str]): The minimum duration for an SSH host certificate generated by
            this provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        min_tls_cert_duration (Union[Unset, str]): The minimum duration for an x509 certificate generated by this
            provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
        min_user_ssh_cert_duration (Union[Unset, str]): The minimum duration for an SSH user certificate generated by
            this provisioner. Parsed as a [Golang duration](https://pkg.go.dev/time#ParseDuration).
    """

    allow_renewal_after_expiry: Union[Unset, bool] = UNSET
    default_host_ssh_cert_duration: Union[Unset, str] = UNSET
    default_tls_cert_duration: Union[Unset, str] = UNSET
    default_user_ssh_cert_duration: Union[Unset, str] = UNSET
    disable_renewal: Union[Unset, bool] = UNSET
    enable_sshca: Union[Unset, bool] = UNSET
    max_host_ssh_cert_duration: Union[Unset, str] = UNSET
    max_tls_cert_duration: Union[Unset, str] = UNSET
    max_user_ssh_cert_duration: Union[Unset, str] = UNSET
    min_host_ssh_cert_duration: Union[Unset, str] = UNSET
    min_tls_cert_duration: Union[Unset, str] = UNSET
    min_user_ssh_cert_duration: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        allow_renewal_after_expiry = self.allow_renewal_after_expiry
        default_host_ssh_cert_duration = self.default_host_ssh_cert_duration
        default_tls_cert_duration = self.default_tls_cert_duration
        default_user_ssh_cert_duration = self.default_user_ssh_cert_duration
        disable_renewal = self.disable_renewal
        enable_sshca = self.enable_sshca
        max_host_ssh_cert_duration = self.max_host_ssh_cert_duration
        max_tls_cert_duration = self.max_tls_cert_duration
        max_user_ssh_cert_duration = self.max_user_ssh_cert_duration
        min_host_ssh_cert_duration = self.min_host_ssh_cert_duration
        min_tls_cert_duration = self.min_tls_cert_duration
        min_user_ssh_cert_duration = self.min_user_ssh_cert_duration

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if allow_renewal_after_expiry is not UNSET:
            field_dict["allowRenewalAfterExpiry"] = allow_renewal_after_expiry
        if default_host_ssh_cert_duration is not UNSET:
            field_dict["defaultHostSSHCertDuration"] = default_host_ssh_cert_duration
        if default_tls_cert_duration is not UNSET:
            field_dict["defaultTLSCertDuration"] = default_tls_cert_duration
        if default_user_ssh_cert_duration is not UNSET:
            field_dict["defaultUserSSHCertDuration"] = default_user_ssh_cert_duration
        if disable_renewal is not UNSET:
            field_dict["disableRenewal"] = disable_renewal
        if enable_sshca is not UNSET:
            field_dict["enableSSHCA"] = enable_sshca
        if max_host_ssh_cert_duration is not UNSET:
            field_dict["maxHostSSHCertDuration"] = max_host_ssh_cert_duration
        if max_tls_cert_duration is not UNSET:
            field_dict["maxTLSCertDuration"] = max_tls_cert_duration
        if max_user_ssh_cert_duration is not UNSET:
            field_dict["maxUserSSHCertDuration"] = max_user_ssh_cert_duration
        if min_host_ssh_cert_duration is not UNSET:
            field_dict["minHostSSHCertDuration"] = min_host_ssh_cert_duration
        if min_tls_cert_duration is not UNSET:
            field_dict["minTLSCertDuration"] = min_tls_cert_duration
        if min_user_ssh_cert_duration is not UNSET:
            field_dict["minUserSSHCertDuration"] = min_user_ssh_cert_duration

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        allow_renewal_after_expiry = d.pop("allowRenewalAfterExpiry", UNSET)

        default_host_ssh_cert_duration = d.pop("defaultHostSSHCertDuration", UNSET)

        default_tls_cert_duration = d.pop("defaultTLSCertDuration", UNSET)

        default_user_ssh_cert_duration = d.pop("defaultUserSSHCertDuration", UNSET)

        disable_renewal = d.pop("disableRenewal", UNSET)

        enable_sshca = d.pop("enableSSHCA", UNSET)

        max_host_ssh_cert_duration = d.pop("maxHostSSHCertDuration", UNSET)

        max_tls_cert_duration = d.pop("maxTLSCertDuration", UNSET)

        max_user_ssh_cert_duration = d.pop("maxUserSSHCertDuration", UNSET)

        min_host_ssh_cert_duration = d.pop("minHostSSHCertDuration", UNSET)

        min_tls_cert_duration = d.pop("minTLSCertDuration", UNSET)

        min_user_ssh_cert_duration = d.pop("minUserSSHCertDuration", UNSET)

        provisioner_claims = cls(
            allow_renewal_after_expiry=allow_renewal_after_expiry,
            default_host_ssh_cert_duration=default_host_ssh_cert_duration,
            default_tls_cert_duration=default_tls_cert_duration,
            default_user_ssh_cert_duration=default_user_ssh_cert_duration,
            disable_renewal=disable_renewal,
            enable_sshca=enable_sshca,
            max_host_ssh_cert_duration=max_host_ssh_cert_duration,
            max_tls_cert_duration=max_tls_cert_duration,
            max_user_ssh_cert_duration=max_user_ssh_cert_duration,
            min_host_ssh_cert_duration=min_host_ssh_cert_duration,
            min_tls_cert_duration=min_tls_cert_duration,
            min_user_ssh_cert_duration=min_user_ssh_cert_duration,
        )

        provisioner_claims.additional_properties = d
        return provisioner_claims

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
