# Hugo example

## Run the example

To simply run the example:

  1. Run `site` on this folder.
  2. Visit `https://localhost`.

## Tutorial

Here’s how you can recreate this basic Hugo blog example. Along the way, you will learn how to:

  - generate a new Hugo site using Site.js,
  - create a bare minimum list (index) layout template,
  - create a bare minimum single (page) layout tamplate,
  - create new content for your blog.

First, create a new directory to hold your Hugo blog and switch to it:

```
mkdir basic-hugo-blog
cd basic-hugo-blog
```

Next, generate your new hugo site using Site.js. By generating it into the `.hugo` folder, we tell Site.js that the routes that are generated by Hugo should be address from the index of the site (and not from a sub-path).

```
site hugo new site .hugo
```

Now, let’s create the layout that will be used for the index page:

```
touch .hugo/layouts/list.html
```

Add the following content to that page using a text editor:

```html
<!doctype html>
<html lang=en>
<head>
  <meta charset=utf-8>
  <title>{{.Site.Title}}</title>
  <link rel='stylesheet' href='/styles.css'></style>
</head>
<body>
  <h1>{{.Site.Title}}</h1>
  <h2>Index</h2>
  <ul>
    {{ range .Pages }}
      <li>{{ .Date.Format "2006-01-02" }} <a href='{{.Permalink}}'>{{ .Title }}</a></li>
    {{ end }}
  </ul>
</body>
</html>
```

This will list the Site title (from `.hugo/config.toml`) and a list of pages (which it will find from the front-matter in the pages we will create in the `.hugo/content` directory). Specifically, we list the date of the post and its title, linked to the post itself via its permalink.

We also need to create a layout for the blog posts themselves. For that, we need a new layout. Let’s create it:

```
mkdir .hugo/layouts/_default
touch .hugo/layouts/_default/single.html
```

This will create a file called `single.html` in the `.hugo/layouts/_default/` directory.

Add the following content to that file using a text editor:

```html
<!doctype html>
<html lang=en>
<head>
  <meta charset=utf-8>
  <title>{{ .Page.Title }}</title>
  <link rel='stylesheet' href='/styles.css'></style>
</head>
<body>
  <h1>{{.Site.Title}}</h1>
  <h2>{{ .Page.Title}}</h2>
  {{ .Page.Content }}
  <p><a href='/'>Back.</a></p>
</body>
</html>
```

This layout is even simpler. We display the site title, the page title, and the page content along with a link back to the index page.

Now we’re ready to add our first two blog posts.

To create a blog post, enter the following command in a terminal session:

```
cd .hugo
site hugo new hello-world/index.md
```

Next, open the generated post in your text editor and you should see something similar to the following:

```md
---
title: "Hello World"
date: 2020-10-14T10:14:21Z
draft: true
---
```

When you use the `site hugo new` command to create a post, Hugo writes out the front matter (metadata) of your post automatically.

Edit this to make the title read `Hello, world!` and set `draft: false`. (Draft posts are not published.)

Next, under the front, enter some body text so that your post resembles the following:

```md
---
title: "Hello, world!"
date: 2020-10-14T10:14:21Z
draft: false
---

This is my very first blog post.
```

Repeat the same process, but this time create a post at `my-second-post/index.md` with content that resembles the following:

```md
---
title: "My second post"
date: 2020-10-26T12:50:21Z
draft: false
---

This is my second blog post.
```

If you’ve been following along, your current working directory in your terminal session should be in the `basic-hugo-blog/.hugo` directory, let’s first switch that back to the main directory of your project with:

```
cd ..
```

And now, let’s run a local Site.js server:

```
site
```

Now, go to https://localhost and you should see your new blog.

This basic tutorial has purposefully steered clear of using third-party Hugo themes or a complex design in order to teach you the basics of how Hugo works.

Now that you have this knowledge, please feel free to explore further by yourself.
