<!DOCTYPE HTML>  
<html>
<head>
  <style>
  .error {color: #FF0000;}
  </style>
</head>
<body>  

  <?php
  function myfilter_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    //$data = htmlspecialchars($data);
    $data = htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
    return $data;
  }

  // define variables and set to empty values
  $nameErr = $emailErr = $genderErr = $websiteErr = "";
  $name = $email = $gender = $comment = $website = "";

  if ($_SERVER["REQUEST_METHOD"] == "POST") 
  {
    if (empty($_POST["name"])) { $nameErr = "Name is required";
    } else { $name = myfilter_input($_POST["name"]);
      // check if name only contains letters and whitespace
      if (!preg_match("/^[a-zA-Z ]*$/",$name)) {
        $nameErr = "Only letters and white space allowed";
      }
    }
    
    if (empty($_POST["email"])) { $emailErr = "Email is required";
    } else {
      $email = myfilter_input($_POST["email"]);
      // check if e-mail address is well-formed
      if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { $emailErr = "Invalid email format"; }
    }
      
    if (empty($_POST["website"])) { $website = "";
    } else { $website = myfilter_input($_POST["website"]);
      //check if URL address syntax is valid (this reg.expr. also allows dashes in URL)
      if (!preg_match(
        "/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i"
        , $website)) {
        $websiteErr = "Invalid URL";
      }
    }

    if (empty($_POST["comment"])) { $comment = "";
    } else { $comment = myfilter_input($_POST["comment"]); }

    if (empty($_POST["gender"])) { $genderErr = "Gender is required";
    } else { $gender = myfilter_input($_POST["gender"]); }
  }

  ?>



  <h2>PHP Form Validation Example</h2>

  <p><span class="error">* required field</span></p>
  <form method="post" action="<?=htmlspecialchars($_SERVER["PHP_SELF"])?>">  

    Name: <input type="text" name="name" value="<?=$name?>">
    <span class="error">* <?=$nameErr?></span>

    <br><br>E-mail: <input type="text" name="email" value="<?=$email?>">
    <span class="error">* <?=$emailErr?></span>

    <br><br>Website: <input type="text" name="website" value="<?=$website?>">
    <span class="error"><?=$websiteErr?></span>

    <br><br>Comment: <textarea
        name="comment" rows="5" cols="40"><?=$comment?></textarea>

    <br><br>Gender:
    <input type="radio" name="gender" <?php 
      if (isset($gender) && $gender=="female") echo "checked"; ?> value="female">Female
    <input type="radio" name="gender" <?php 
      if (isset($gender) && $gender=="male") echo "checked"; ?> value="male">Male
    <input type="radio" name="gender" <?php 
      if (isset($gender) && $gender=="other") echo "checked"; ?> value="other">Other  
    <span class="error">* <?=$genderErr?></span>

    <br><br><input type="submit" name="submit" value="Submit">  
  </form>

  <?php
  echo "<h2>Your Input:</h2>";
  echo $name; echo "<br>";
  echo $email; echo "<br>";
  echo $website; echo "<br>";
  echo $comment; echo "<br>";
  echo $gender;
  ?>

</body>
</html>