import { Size } from '../../types';

import {
  ADDRESS_FIELD_SVG,
  ALIGN_CENTER_SVG,
  ALIGN_JUSTIFY_SVG,
  ALIGN_LEFT_SVG,
  ALIGN_RIGHT_SVG,
  AMBULANCE_SVG,
  ANCHOR_SVG,
  ARCHIVE_SVG,
  ARROW_DOWN_SVG,
  ARROW_LEFT_SVG,
  ARROW_RIGHT_SVG,
  ARROW_UP_SVG,
  AT_SVG,
  ATOM_SVG,
  AWARD_ALT_SVG,
  BACKWARD_SVG,
  BALANCE_SVG,
  BASKETBALL_SVG,
  BED_SVG,
  BELL_SVG,
  BITCOIN_SVG,
  BITKEEP_SVG,
  BOLD_SVG,
  BOLT_SVG,
  BOOK_SVG,
  BOOKS_SVG,
  BRANCH_SVG,
  BRAVE_SVG,
  BUG_SVG,
  BUILDING_SVG,
  BULLET_LIST_SVG,
  CALCULATOR_SVG,
  CALENDAR_SVG,
  CAMERA_SVG,
  CARRIAGE_SVG,
  CART_SVG,
  CHECK_CIRCLE_SVG,
  CHECK_SVG,
  CHECKBOX_EMPTY_SVG,
  CHECKBOX_FILLED_SVG,
  CHECKBOX_HALF_FILLED_SVG,
  CHEVRON_DOWN_SVG,
  CHEVRON_LEFT_SVG,
  CHEVRON_RIGHT_SVG,
  CHEVRON_UP_SVG,
  CLEAR_FORMATTING_SVG,
  CLIPBOARD_SVG,
  CLOCK_SVG,
  CLOSE_SVG,
  CLOUD_SVG,
  CODE_BLOCK_SVG,
  COFFEE_SVG,
  COINBASE_SVG,
  COLLAPSE_H_SVG,
  COLLAPSE_V_SVG,
  COMMENT_PLUS_SVG,
  COMMENT_SVG,
  COMPASS_SVG,
  COMPOSE_SVG,
  COPY_SVG,
  CORNER_DOWN_LEFT_SVG,
  CREDIT_CARD_SVG,
  CROSSHAIRS_SVG,
  CURLY_BRACKETS_SVG,
  CURRENCY_SVG,
  DECREASE_INDENT_SVG,
  DESERT_SVG,
  DESKTOP_SVG,
  DNA_SVG,
  DOT_SVG,
  DOUBLE_LEFT_SVG,
  DOUBLE_RIGHT_SVG,
  DOWNLOAD_SVG,
  DOWNWARD_SVG,
  DRAG_SVG,
  DUMBBEL_SVG,
  DUPLICATE_SVG,
  EDIT_SVG,
  ENVELOPE_READ_SVG,
  ENVELOPE_SEARCH_SVG,
  ENVELOPE_SVG,
  ENVELOPE_UNREAD_SVG,
  EQUATION_SVG,
  ESCAPE_SVG,
  ETHEREUM_SVG,
  EURO_SVG,
  EXIT_SVG,
  EXPAND_H_SVG,
  EXPAND_SVG,
  EXPAND_V_SVG,
  EXTERNAL_LINK_SVG,
  EYE_SLASH_SVG,
  EYE_SVG,
  FILE_EMPTY_SVG,
  FILE_LOCK_SVG,
  FILE_PLUS_SVG,
  FILE_SLASH_SVG,
  FILE_SUBPAGE_SVG,
  FILE_SVG,
  FILE_UPLOAD_SVG,
  FILE_X_SVG,
  FILM_SVG,
  FILTER_PLUS_SVG,
  FILTER_SVG,
  FIRE_SVG,
  FLAG_SVG,
  FLASK_SVG,
  FLOWER_SVG,
  FOLDER_ARROW_SVG,
  FOLDER_FILLED_SVG,
  FOLDER_LOCK_SVG,
  FOLDER_PLUS_SVG,
  FOLDER_SOLID_SVG,
  FOLDER_SVG,
  FOOTBALL_SVG,
  FORWARD_EMAIL_SVG,
  FORWARD_SVG,
  FULL_VIEW_SVG,
  GALLERY_SVG,
  GIFT_SVG,
  GLOBE_SVG,
  GMAIL_SVG,
  GOOGLE_CALENDAR_SVG,
  GOOGLE_DRIVE_COLOR_SVG,
  GOOGLE_DRIVE_SVG,
  GRADUATION_SVG,
  GRID_SVG,
  H1_SVG,
  H2_SVG,
  H3_SVG,
  H4_SVG,
  H5_SVG,
  H6_SVG,
  HEART_SVG,
  HIGHLIGHT_SVG,
  HISTORY_SVG,
  HOME_SVG,
  HORIZONTAL_RULE_SVG,
  HOURGLASS_SVG,
  IMAGE_SVG,
  INBOX_SVG,
  INCREASE_INDENT_SVG,
  INFO_SVG,
  IPFS_SVG,
  ITALIC_SVG,
  KEY_SVG,
  LIGHTBULB_SVG,
  LINE_CHART_SVG,
  LINK_SVG,
  LOCK_SVG,
  MAILBOX_SVG,
  MAP_MARKER_SVG,
  MAP_PIN_SVG,
  MAP_SVG,
  MARKDOWN_SVG,
  MARTINI_SVG,
  MEDKIT_SVG,
  MEGAPHONE_SVG,
  MENU_SVG,
  METAMASK_OUTLINE_SVG,
  METAMASK_SVG,
  METER_SVG,
  MINUS_SVG,
  MOBILE_SVG,
  MOON_SVG,
  MOVE_MAILBOX_SVG,
  MUSIC_NOTE_SVG,
  NOTIFICATION_BADGE_SVG,
  NUMBER_LIST_SVG,
  NUMBER_SVG,
  NUMBERS_SVG,
  ORG_STRUCTURE_SVG,
  OVERFLOW_H_SVG,
  OVERFLOW_V_SVG,
  PALETTE_SVG,
  PAPER_CLIP_SVG,
  PARCEL_SVG,
  PARENT_SVG,
  PDF_SVG,
  PHANTOM_SVG,
  PIE_CHART_SVG,
  PLANE_SVG,
  PLUS_CIRCLE_SVG,
  PLUS_SVG,
  PODIUM_SVG,
  POUND_SVG,
  PRESCRIPTION_BOTTLE_SVG,
  PRESENT_PLAY_SVG,
  PRINTER_SVG,
  PROCESSOR_SVG,
  PYTHON_SVG,
  QRCODE_SCAN_SVG,
  QUESTION_CIRCLE_SVG,
  QUESTION_SVG,
  RADIO_EMPTY_SVG,
  RADIO_FILLED_SVG,
  REDO_SVG,
  RELOAD_SVG,
  REMOVE_SVG,
  REPLY_ALL_SVG,
  REPLY_SVG,
  RESTAURANT_SVG,
  ROBOT_SVG,
  ROCKET_SVG,
  SAVE_SVG,
  SCREW_SVG,
  SEARCH_SVG,
  SEND_SVG,
  SERVER_SVG,
  SETTINGS_SVG,
  SHIELD_CHECK_SVG,
  SHIELD_ENCRYPT_SVG,
  SHIP_SVG,
  SIGN_SVG,
  SKIFF_SVG,
  SLIDERS_SVG,
  SMILE_PLUS_SVG,
  SMILE_SVG,
  SNOWFLAKE_SVG,
  SOCCER_SVG,
  SOLANA_SVG,
  SORT_ASCENDING_SVG,
  SORT_DESCENDING_SVG,
  SOUND_SVG,
  SPAM_SVG,
  SPIN_SVG,
  SPLIT_VIEW_SVG,
  STAR_SVG,
  STOPWATCH_SVG,
  STRIKETHROUGH_SVG,
  SUN_SVG,
  SYRINGE_SVG,
  TABLE_SVG,
  TABLE_TENNIS_SVG,
  TAG_SVG,
  TELESCOPE_SVG,
  TEMPERATURE_SVG,
  TENNIS_BALL_SVG,
  TEXT_FIELD_SVG,
  TEXT_MONO_SVG,
  TEXT_SERIF_SVG,
  TEXT_SIZE_SVG,
  TEXT_SVG,
  THEMES_SVG,
  THUMBS_DOWN_SVG,
  THUMBS_UP_SVG,
  THUNDERSTORM_SVG,
  TODO_SVG,
  TOGGLE_HEADER_SVG,
  TOGGLE_LIST_SVG,
  TRAFFIC_BARRIER_SVG,
  TRAFFIC_CONE_SVG,
  TRAFFIC_LIGHT_SVG,
  TRAIN_SVG,
  TRASH_SVG,
  TREES_SVG,
  TROPHY_SVG,
  TRUCK_SVG,
  TV_SVG,
  UMBRELLA_SVG,
  UNDERLINE_SVG,
  UNDO_SVG,
  UNIVERSITY_SVG,
  UNLINK_SVG,
  UNLOCK_SVG,
  UNSTOPPABLE_DARK_SVG,
  UNSTOPPABLE_SVG,
  UPLOAD_SVG,
  UPWARD_SVG,
  USER_CHECK_SVG,
  USER_CIRCLE_SVG,
  USER_MINUS_SVG,
  USER_PLURAL_SVG,
  USER_PLUS_SVG,
  USER_SQUARE_SVG,
  USER_SVG,
  VIDEO_SVG,
  WALLET_SVG,
  WARNING_SVG,
  WATERMARK_SVG,
  WIFI_SLASH_SVG,
  WIFI_SVG,
  WORD_SVG,
  WRENCH_SVG,
  X_CIRCLE_SVG,
  YEN_SVG,
  YIN_YANG_SVG,
  ZIP_SVG,
  ZOOM_MINUS_SVG,
  ZOOM_PLUS_SVG
} from './assets';
import { Icon, IconColor } from './Icons.types';

export const ICON_SIZE: Record<Size, number> = {
  xlarge: 48,
  large: 36,
  xmedium: 24,
  medium: 16,
  small: 14,
  xsmall: 12
};

export const ICON_COLOR: Record<IconColor, string> = {
  primary: 'var(--icon-primary)',
  secondary: 'var(--icon-secondary)',
  tertiary: 'var(--icon-tertiary)',
  disabled: 'var(--icon-disabled)',
  inverse: 'var(--icon-inverse)',
  destructive: 'var(--icon-destructive)',
  link: 'var(--icon-link)',
  white: 'var(--icon-always-white)',
  black: 'var(--icon-always-black)',
  orange: 'var(--accent-orange-primary)',
  green: 'var(--accent-green-primary)',
  pink: 'var(--accent-pink-primary)',
  yellow: 'var(--accent-yellow-primary)',
  blue: 'var(--accent-blue-primary)',
  red: 'var(--accent-red-primary)',
  'dark-blue': 'var(--accent-dark-blue-primary)',
  source: ''
};

export const ICON_SVG: Record<Icon, string> = {
  archive: ARCHIVE_SVG,
  at: AT_SVG,
  'address-field': ADDRESS_FIELD_SVG,
  'align-center': ALIGN_CENTER_SVG,
  'align-justify': ALIGN_JUSTIFY_SVG,
  'align-left': ALIGN_LEFT_SVG,
  'align-right': ALIGN_RIGHT_SVG,
  anchor: ANCHOR_SVG,
  ambulance: AMBULANCE_SVG,
  'arrow-down': ARROW_DOWN_SVG,
  'arrow-left': ARROW_LEFT_SVG,
  'arrow-right': ARROW_RIGHT_SVG,
  'arrow-up': ARROW_UP_SVG,
  atom: ATOM_SVG,
  'award-alt': AWARD_ALT_SVG,
  backward: BACKWARD_SVG,
  balance: BALANCE_SVG,
  basketball: BASKETBALL_SVG,
  bed: BED_SVG,
  bell: BELL_SVG,
  bitcoin: BITCOIN_SVG,
  bitkeep: BITKEEP_SVG,
  bold: BOLD_SVG,
  bolt: BOLT_SVG,
  book: BOOK_SVG,
  books: BOOKS_SVG,
  branch: BRANCH_SVG,
  brave: BRAVE_SVG,
  bug: BUG_SVG,
  building: BUILDING_SVG,
  'bullet-list': BULLET_LIST_SVG,
  calculator: CALCULATOR_SVG,
  calendar: CALENDAR_SVG,
  camera: CAMERA_SVG,
  carriage: CARRIAGE_SVG,
  cart: CART_SVG,
  'check-circle': CHECK_CIRCLE_SVG,
  check: CHECK_SVG,
  'checkbox-half-filled': CHECKBOX_HALF_FILLED_SVG,
  'checkbox-empty': CHECKBOX_EMPTY_SVG,
  'checkbox-filled': CHECKBOX_FILLED_SVG,
  'chevron-up': CHEVRON_UP_SVG,
  'chevron-down': CHEVRON_DOWN_SVG,
  'chevron-left': CHEVRON_LEFT_SVG,
  'chevron-right': CHEVRON_RIGHT_SVG,
  'clear-formatting': CLEAR_FORMATTING_SVG,
  clipboard: CLIPBOARD_SVG,
  clock: CLOCK_SVG,
  close: CLOSE_SVG,
  cloud: CLOUD_SVG,
  'code-block': CODE_BLOCK_SVG,
  coffee: COFFEE_SVG,
  coinbase: COINBASE_SVG,
  'collapse-h': COLLAPSE_H_SVG,
  'collapse-v': COLLAPSE_V_SVG,
  'comment-plus': COMMENT_PLUS_SVG,
  comment: COMMENT_SVG,
  compass: COMPASS_SVG,
  compose: COMPOSE_SVG,
  copy: COPY_SVG,
  'corner-down-left': CORNER_DOWN_LEFT_SVG,
  'credit-card': CREDIT_CARD_SVG,
  crosshairs: CROSSHAIRS_SVG,
  'curly-brackets': CURLY_BRACKETS_SVG,
  currency: CURRENCY_SVG,
  'decrease-indent': DECREASE_INDENT_SVG,
  desert: DESERT_SVG,
  desktop: DESKTOP_SVG,
  dna: DNA_SVG,
  dot: DOT_SVG,
  'double-left': DOUBLE_LEFT_SVG,
  'double-right': DOUBLE_RIGHT_SVG,
  download: DOWNLOAD_SVG,
  downward: DOWNWARD_SVG,
  drag: DRAG_SVG,
  dumbbell: DUMBBEL_SVG,
  duplicate: DUPLICATE_SVG,
  edit: EDIT_SVG,
  envelope: ENVELOPE_SVG,
  'envelope-unread': ENVELOPE_UNREAD_SVG,
  'envelope-read': ENVELOPE_READ_SVG,
  'envelope-search': ENVELOPE_SEARCH_SVG,
  equation: EQUATION_SVG,
  euro: EURO_SVG,
  escape: ESCAPE_SVG,
  ethereum: ETHEREUM_SVG,
  exit: EXIT_SVG,
  expand: EXPAND_SVG,
  'expand-h': EXPAND_H_SVG,
  'expand-v': EXPAND_V_SVG,
  'external-link': EXTERNAL_LINK_SVG,
  eye: EYE_SVG,
  'eye-slash': EYE_SLASH_SVG,
  'file-empty': FILE_EMPTY_SVG,
  'file-lock': FILE_LOCK_SVG,
  'file-plus': FILE_PLUS_SVG,
  'file-slash': FILE_SLASH_SVG,
  'file-subpage': FILE_SUBPAGE_SVG,
  'file-upload': FILE_UPLOAD_SVG,
  'file-x': FILE_X_SVG,
  file: FILE_SVG,
  film: FILM_SVG,
  filter: FILTER_SVG,
  'filter-plus': FILTER_PLUS_SVG,
  fire: FIRE_SVG,
  flag: FLAG_SVG,
  flask: FLASK_SVG,
  flower: FLOWER_SVG,
  'folder-arrow': FOLDER_ARROW_SVG,
  'folder-lock': FOLDER_LOCK_SVG,
  'folder-plus': FOLDER_PLUS_SVG,
  'folder-solid': FOLDER_SOLID_SVG,
  folder: FOLDER_SVG,
  'folder-filled': FOLDER_FILLED_SVG,
  football: FOOTBALL_SVG,
  forward: FORWARD_SVG,
  'forward-email': FORWARD_EMAIL_SVG,
  'full-view': FULL_VIEW_SVG,
  gallery: GALLERY_SVG,
  gift: GIFT_SVG,
  globe: GLOBE_SVG,
  gmail: GMAIL_SVG,
  'google-drive': GOOGLE_DRIVE_SVG,
  'google-drive-color': GOOGLE_DRIVE_COLOR_SVG,
  'google-calendar': GOOGLE_CALENDAR_SVG,
  graduation: GRADUATION_SVG,
  grid: GRID_SVG,
  h1: H1_SVG,
  h2: H2_SVG,
  h3: H3_SVG,
  h4: H4_SVG,
  h5: H5_SVG,
  h6: H6_SVG,
  heart: HEART_SVG,
  highlight: HIGHLIGHT_SVG,
  history: HISTORY_SVG,
  home: HOME_SVG,
  'horizontal-rule': HORIZONTAL_RULE_SVG,
  hourglass: HOURGLASS_SVG,
  image: IMAGE_SVG,
  inbox: INBOX_SVG,
  'increase-indent': INCREASE_INDENT_SVG,
  info: INFO_SVG,
  ipfs: IPFS_SVG,
  italic: ITALIC_SVG,
  key: KEY_SVG,
  lightbulb: LIGHTBULB_SVG,
  'line-chart': LINE_CHART_SVG,
  link: LINK_SVG,
  lock: LOCK_SVG,
  mailbox: MAILBOX_SVG,
  'map-marker': MAP_MARKER_SVG,
  'map-pin': MAP_PIN_SVG,
  map: MAP_SVG,
  martini: MARTINI_SVG,
  medkit: MEDKIT_SVG,
  megaphone: MEGAPHONE_SVG,
  menu: MENU_SVG,
  metamask: METAMASK_SVG,
  'metamask-outline': METAMASK_OUTLINE_SVG,
  meter: METER_SVG,
  minus: MINUS_SVG,
  mobile: MOBILE_SVG,
  moon: MOON_SVG,
  'music-note': MUSIC_NOTE_SVG,
  'move-mailbox': MOVE_MAILBOX_SVG,
  'number-list': NUMBER_LIST_SVG,
  'notification-badge': NOTIFICATION_BADGE_SVG,
  number: NUMBER_SVG,
  numbers: NUMBERS_SVG,
  'org-structure': ORG_STRUCTURE_SVG,
  'overflow-h': OVERFLOW_H_SVG,
  'overflow-v': OVERFLOW_V_SVG,
  parcel: PARCEL_SVG,
  palette: PALETTE_SVG,
  'paper-clip': PAPER_CLIP_SVG,
  parent: PARENT_SVG,
  pdf: PDF_SVG,
  phantom: PHANTOM_SVG,
  'pie-chart': PIE_CHART_SVG,
  plane: PLANE_SVG,
  'plus-circle': PLUS_CIRCLE_SVG,
  plus: PLUS_SVG,
  podium: PODIUM_SVG,
  pound: POUND_SVG,
  'prescription-bottle': PRESCRIPTION_BOTTLE_SVG,
  'present-play': PRESENT_PLAY_SVG,
  printer: PRINTER_SVG,
  processor: PROCESSOR_SVG,
  'qrcode-scan': QRCODE_SCAN_SVG,
  'question-circle': QUESTION_CIRCLE_SVG,
  question: QUESTION_SVG,
  'radio-empty': RADIO_EMPTY_SVG,
  'radio-filled': RADIO_FILLED_SVG,
  redo: REDO_SVG,
  reload: RELOAD_SVG,
  remove: REMOVE_SVG,
  reply: REPLY_SVG,
  'reply-all': REPLY_ALL_SVG,
  restaurant: RESTAURANT_SVG,
  robot: ROBOT_SVG,
  rocket: ROCKET_SVG,
  save: SAVE_SVG,
  screw: SCREW_SVG,
  search: SEARCH_SVG,
  send: SEND_SVG,
  server: SERVER_SVG,
  settings: SETTINGS_SVG,
  'shield-check': SHIELD_CHECK_SVG,
  'shield-encrypt': SHIELD_ENCRYPT_SVG,
  ship: SHIP_SVG,
  sign: SIGN_SVG,
  sliders: SLIDERS_SVG,
  smile: SMILE_SVG,
  'smile-plus': SMILE_PLUS_SVG,
  snowflake: SNOWFLAKE_SVG,
  soccer: SOCCER_SVG,
  solana: SOLANA_SVG,
  'sort-ascending': SORT_ASCENDING_SVG,
  'sort-descending': SORT_DESCENDING_SVG,
  sound: SOUND_SVG,
  spam: SPAM_SVG,
  spin: SPIN_SVG,
  'split-view': SPLIT_VIEW_SVG,
  star: STAR_SVG,
  stopwatch: STOPWATCH_SVG,
  strikethrough: STRIKETHROUGH_SVG,
  sun: SUN_SVG,
  syringe: SYRINGE_SVG,
  table: TABLE_SVG,
  'table-tennis': TABLE_TENNIS_SVG,
  tag: TAG_SVG,
  telescope: TELESCOPE_SVG,
  temperature: TEMPERATURE_SVG,
  'tennis-ball': TENNIS_BALL_SVG,
  text: TEXT_SVG,
  'text-field': TEXT_FIELD_SVG,
  'text-mono': TEXT_MONO_SVG,
  'text-serif': TEXT_SERIF_SVG,
  'text-size': TEXT_SIZE_SVG,
  themes: THEMES_SVG,
  'thumbs-down': THUMBS_DOWN_SVG,
  'thumbs-up': THUMBS_UP_SVG,
  thunderstorm: THUNDERSTORM_SVG,
  todo: TODO_SVG,
  'toggle-header': TOGGLE_HEADER_SVG,
  'toggle-list': TOGGLE_LIST_SVG,
  'traffic-barrier': TRAFFIC_BARRIER_SVG,
  'traffic-cone': TRAFFIC_CONE_SVG,
  'traffic-light': TRAFFIC_LIGHT_SVG,
  train: TRAIN_SVG,
  trash: TRASH_SVG,
  trees: TREES_SVG,
  trophy: TROPHY_SVG,
  truck: TRUCK_SVG,
  tv: TV_SVG,
  umbrella: UMBRELLA_SVG,
  underline: UNDERLINE_SVG,
  undo: UNDO_SVG,
  university: UNIVERSITY_SVG,
  unlink: UNLINK_SVG,
  unlock: UNLOCK_SVG,
  unstoppable: UNSTOPPABLE_SVG,
  'unstoppable-dark': UNSTOPPABLE_DARK_SVG,
  upload: UPLOAD_SVG,
  upward: UPWARD_SVG,
  'user-check': USER_CHECK_SVG,
  'user-circle': USER_CIRCLE_SVG,
  'user-minus': USER_MINUS_SVG,
  'user-plural': USER_PLURAL_SVG,
  'user-plus': USER_PLUS_SVG,
  'user-square': USER_SQUARE_SVG,
  user: USER_SVG,
  wallet: WALLET_SVG,
  warning: WARNING_SVG,
  watermark: WATERMARK_SVG,
  'wifi-slash': WIFI_SLASH_SVG,
  wrench: WRENCH_SVG,
  wifi: WIFI_SVG,
  'x-circle': X_CIRCLE_SVG,
  yen: YEN_SVG,
  'yin-yang': YIN_YANG_SVG,
  'zoom-minus': ZOOM_MINUS_SVG,
  'zoom-plus': ZOOM_PLUS_SVG,
  markdown: MARKDOWN_SVG,
  skiff: SKIFF_SVG,
  video: VIDEO_SVG,
  word: WORD_SVG,
  zip: ZIP_SVG,
  python: PYTHON_SVG
};
