import type { Placement } from '@floating-ui/react-dom-interactions';
export declare enum TooltipPlacement {
    TOP = "top",
    TOP_START = "top-start",
    TOP_END = "top-end",
    RIGHT = "right",
    RIGHT_START = "right-start",
    RIGHT_END = "right-end",
    BOTTOM = "bottom",
    BOTTOM_START = "bottom-start",
    BOTTOM_END = "bottom-end",
    LEFT = "left",
    LEFT_START = "left-start",
    LEFT_END = "left-end"
}
export interface TooltipLabelProps {
    /** Keyboard shortcut */
    shortcut: string;
    /** Tooltip label */
    title: string;
}
export interface TooltipOptions {
    initialOpen?: boolean;
    placement?: Placement;
    open?: boolean;
    onOpenChange?: (open: boolean) => void;
}
//# sourceMappingURL=Tooltip.constants.d.ts.map