import * as React from 'react';
import { Size, ThemeMode } from '../../types';
import { Color } from '../../utils/colorUtils';
export type IconColor = Color | 'source';
export interface IconProps {
    /** The type of Icon */
    icon: Icon;
    dataTest?: string;
    disabled?: boolean;
    /** Icons in-line style */
    color?: IconColor;
    /** Color transition delay in milliseconds */
    colorDelay?: number;
    forceTheme?: ThemeMode;
    rotate?: number;
    shadow?: boolean;
    /** The size for the Icon */
    size?: Size | number;
    /** Tooltip label */
    tooltip?: string;
    /** Gets called when the user clicks on the icon */
    onClick?: (e: React.MouseEvent) => void | Promise<void>;
}
export declare enum Icon {
    At = "at",
    AddressField = "address-field",
    AlignCenter = "align-center",
    AlignJustify = "align-justify",
    AlignLeft = "align-left",
    AlignRight = "align-right",
    Anchor = "anchor",
    Ambulance = "ambulance",
    Archive = "archive",
    ArrowDown = "arrow-down",
    ArrowLeft = "arrow-left",
    ArrowRight = "arrow-right",
    ArrowUp = "arrow-up",
    Atom = "atom",
    AwardAlt = "award-alt",
    Backward = "backward",
    Balance = "balance",
    Basketball = "basketball",
    Bed = "bed",
    Bell = "bell",
    Bitcoin = "bitcoin",
    Bitkeep = "bitkeep",
    Bold = "bold",
    Bolt = "bolt",
    Book = "book",
    Books = "books",
    Branch = "branch",
    Brave = "brave",
    Bug = "bug",
    Building = "building",
    BulletList = "bullet-list",
    Calculator = "calculator",
    Calendar = "calendar",
    Camera = "camera",
    Carriage = "carriage",
    Cart = "cart",
    CheckCircle = "check-circle",
    Check = "check",
    CheckboxHalfFilled = "checkbox-half-filled",
    CheckboxEmpty = "checkbox-empty",
    CheckboxFilled = "checkbox-filled",
    ChevronUp = "chevron-up",
    ChevronDown = "chevron-down",
    ChevronLeft = "chevron-left",
    ChevronRight = "chevron-right",
    ClearFormatting = "clear-formatting",
    Clipboard = "clipboard",
    Clock = "clock",
    Close = "close",
    Cloud = "cloud",
    CodeBlock = "code-block",
    Coffee = "coffee",
    Coinbase = "coinbase",
    CollapseH = "collapse-h",
    CollapseV = "collapse-v",
    CommentPlus = "comment-plus",
    Comment = "comment",
    Compass = "compass",
    Compose = "compose",
    Copy = "copy",
    CornerDownLeft = "corner-down-left",
    CreditCard = "credit-card",
    Crosshairs = "crosshairs",
    CurlyBrackets = "curly-brackets",
    Currency = "currency",
    DecreaseIndent = "decrease-indent",
    Desert = "desert",
    Desktop = "desktop",
    Dna = "dna",
    Dot = "dot",
    DoubleLeft = "double-left",
    DoubleRight = "double-right",
    Download = "download",
    Downward = "downward",
    Drag = "drag",
    Dumbbell = "dumbbell",
    Duplicate = "duplicate",
    Edit = "edit",
    Envelope = "envelope",
    EnvelopeUnread = "envelope-unread",
    EnvelopeRead = "envelope-read",
    EnvelopeSearch = "envelope-search",
    Equation = "equation",
    Euro = "euro",
    Escape = "escape",
    Ethereum = "ethereum",
    Exit = "exit",
    Expand = "expand",
    ExpandH = "expand-h",
    ExpandV = "expand-v",
    ExternalLink = "external-link",
    Eye = "eye",
    EyeSlash = "eye-slash",
    FileEmpty = "file-empty",
    FileLock = "file-lock",
    FilePlus = "file-plus",
    FileSlash = "file-slash",
    FileSubpage = "file-subpage",
    FileUpload = "file-upload",
    FileX = "file-x",
    File = "file",
    Film = "film",
    Filter = "filter",
    FilterPlus = "filter-plus",
    Fire = "fire",
    Flag = "flag",
    Flask = "flask",
    Flower = "flower",
    FolderArrow = "folder-arrow",
    FolderLock = "folder-lock",
    FolderPlus = "folder-plus",
    FolderSolid = "folder-solid",
    Folder = "folder",
    FolderFilled = "folder-filled",
    Football = "football",
    Forward = "forward",
    ForwardEmail = "forward-email",
    FullView = "full-view",
    Gallery = "gallery",
    Gift = "gift",
    Globe = "globe",
    Gmail = "gmail",
    GoogleDrive = "google-drive",
    GoogleDriveColor = "google-drive-color",
    GoogleCalendar = "google-calendar",
    Graduation = "graduation",
    Grid = "grid",
    H1 = "h1",
    H2 = "h2",
    H3 = "h3",
    H4 = "h4",
    H5 = "h5",
    H6 = "h6",
    Heart = "heart",
    Highlight = "highlight",
    History = "history",
    Home = "home",
    HorizontalRule = "horizontal-rule",
    Hourglass = "hourglass",
    Image = "image",
    Inbox = "inbox",
    IncreaseIndent = "increase-indent",
    Info = "info",
    Ipfs = "ipfs",
    Italic = "italic",
    Key = "key",
    Lightbulb = "lightbulb",
    LineChart = "line-chart",
    Link = "link",
    Lock = "lock",
    Mailbox = "mailbox",
    MapMarker = "map-marker",
    MapPin = "map-pin",
    Markdown = "markdown",
    Map = "map",
    Martini = "martini",
    Medkit = "medkit",
    Megaphone = "megaphone",
    Menu = "menu",
    Metamask = "metamask",
    MetamaskOutline = "metamask-outline",
    Meter = "meter",
    Minus = "minus",
    Mobile = "mobile",
    Moon = "moon",
    MusicNote = "music-note",
    MoveMailbox = "move-mailbox",
    NotificationBadge = "notification-badge",
    NumberList = "number-list",
    Number = "number",
    Numbers = "numbers",
    OrgStructure = "org-structure",
    OverflowH = "overflow-h",
    OverflowV = "overflow-v",
    Parcel = "parcel",
    Palette = "palette",
    PaperClip = "paper-clip",
    Parent = "parent",
    Pdf = "pdf",
    Phantom = "phantom",
    PieChart = "pie-chart",
    Plane = "plane",
    PlusCircle = "plus-circle",
    Plus = "plus",
    Podium = "podium",
    Pound = "pound",
    PrescriptionBottle = "prescription-bottle",
    PresentPlay = "present-play",
    Printer = "printer",
    Processor = "processor",
    Python = "python",
    QrCodeScan = "qrcode-scan",
    QuestionCircle = "question-circle",
    Question = "question",
    RadioEmpty = "radio-empty",
    RadioFilled = "radio-filled",
    Redo = "redo",
    Reload = "reload",
    Remove = "remove",
    Reply = "reply",
    ReplyAll = "reply-all",
    Restaurant = "restaurant",
    Robot = "robot",
    Rocket = "rocket",
    Save = "save",
    Screw = "screw",
    Search = "search",
    Send = "send",
    Server = "server",
    Settings = "settings",
    ShieldCheck = "shield-check",
    ShieldEncrypt = "shield-encrypt",
    Ship = "ship",
    Sign = "sign",
    Skiff = "skiff",
    Sliders = "sliders",
    Smile = "smile",
    SmilePlus = "smile-plus",
    Snowflake = "snowflake",
    Soccer = "soccer",
    Solana = "solana",
    SortAscending = "sort-ascending",
    SortDescending = "sort-descending",
    Sound = "sound",
    Spam = "spam",
    Spin = "spin",
    SplitView = "split-view",
    Star = "star",
    Stopwatch = "stopwatch",
    Strikethrough = "strikethrough",
    Sun = "sun",
    Syringe = "syringe",
    TableTennis = "table-tennis",
    Table = "table",
    Tag = "tag",
    Telescope = "telescope",
    Temperature = "temperature",
    TennisBall = "tennis-ball",
    TextField = "text-field",
    TextMono = "text-mono",
    TextSerif = "text-serif",
    TextSize = "text-size",
    Text = "text",
    Themes = "themes",
    ThumbsDown = "thumbs-down",
    ThumbsUp = "thumbs-up",
    Thunderstorm = "thunderstorm",
    Todo = "todo",
    ToggleList = "toggle-list",
    TrafficBarrier = "traffic-barrier",
    TrafficCone = "traffic-cone",
    TrafficLight = "traffic-light",
    Train = "train",
    ToggleHeader = "toggle-header",
    Trash = "trash",
    Trees = "trees",
    Trophy = "trophy",
    Truck = "truck",
    Tv = "tv",
    Umbrella = "umbrella",
    Underline = "underline",
    Undo = "undo",
    University = "university",
    Unlink = "unlink",
    Unlock = "unlock",
    Unstoppable = "unstoppable",
    UnstoppableDark = "unstoppable-dark",
    Upload = "upload",
    Upward = "upward",
    UserCheck = "user-check",
    UserCircle = "user-circle",
    UserMinus = "user-minus",
    UserPlural = "user-plural",
    UserPlus = "user-plus",
    UserSquare = "user-square",
    User = "user",
    Video = "video",
    Wallet = "wallet",
    Warning = "warning",
    Watermark = "watermark",
    WifiSlash = "wifi-slash",
    Word = "word",
    Wrench = "wrench",
    Wifi = "wifi",
    XCircle = "x-circle",
    Yen = "yen",
    YinYang = "yin-yang",
    Zip = "zip",
    ZoomMinus = "zoom-minus",
    ZoomPlus = "zoom-plus"
}
//# sourceMappingURL=Icons.types.d.ts.map