## LinkedList跟ArrayList简单的性能测试
在网上总是看到别人的博客谈到`LinkedList`跟`ArrayList`的优缺点,自己也是有点背理论的感觉,干脆今天自己来简单的测试一番,以下数据仅供参考,因为每次测试的时间不是一定会相等的,因测试环境的不同导致不同的差异
### 测试环境
- 物理机: 内存12G,四核心/八线程
- 操作系统: Ubuntu 16.04 LTS X64位
- JDK:JDK 1.8 X64位
- IDE: IDEA 2017.1.3,启动配置文件如下
````properties
-Xms256m
-Xmx1500m
-XX:ReservedCodeCacheSize=480m
````
## 测试数据
### 在有数据的基础上插入数据测试
| 测试总数据量 | 测试条件 | LinkedList测试结果 | ArrayList测试结果 |
|:---:|:---:|:---:|:---:|
 | 1千万  | 不指定下标直接插入一条数据   |  0毫秒  |  0毫秒 |
| 1千万  |  下标为1的位置插入一条数据 | 0毫秒  | 0毫秒|
| 1千万  |  下标为2000000的位置插入一个数据 | 19毫秒  | 25毫秒|
| 1千万  |  下标为5000000的位置插入一个数据 | 30毫秒  | 54毫秒|
| 1千万  |  下标为7000000的位置插入一个数据 | 13毫秒  | 34毫秒|
| 1千万  |  下标为8020300的位置插入一个数据 | 8毫秒  | 21毫秒|
| 1千万  |  下标为10000000的位置插入一个数据 | 0毫秒  | 0毫秒|

### 在无数据的基础上进行插入数据测试
| 测试条件 | LinkedList测试结果 | ArrayList测试结果 |
|:---:|:---:|:---:|
| 在空的集合里面插入1千万条数据   |  4982毫秒  |  843毫秒 |
 
### 获取数据测试
| 测试总数据量 | 测试条件 | LinkedList测试结果 | ArrayList测试结果 |
|:---:|:---:|:---:|:---:|
| 1千万  |  读取下标为1的位置的数据 | 0毫秒  | 0毫秒|
| 1千万  |  读取下标为1020300的位置的数据 | 10毫秒  | 10毫秒|
| 1千万  |  读取下标为3020300的位置的数据 | 28毫秒  | 30毫秒|
| 1千万  |  读取下标为5000000的位置的数据 | 34毫秒  | 47毫秒|
| 1千万  |  读取下标为8020300的位置的数据 | 9毫秒  | 19毫秒|
 | 1千万  | 读取下标为9000000的位置的数据   |  5毫秒  |  9毫秒 |
| 1千万  |  读取下标为9020300的位置的数据 | 6毫秒  | 9毫秒|
| 1千万  |  读取下标为10000000的位置的数据 | 0毫秒  | 0毫秒|

