﻿// The following connection settings were used to generate this file:
//     Connection String Name: "MyDbContext"
//     Connection String:      "Data Source=(local);Initial Catalog=Northwind;Integrated Security=True;Encrypt=false;TrustServerCertificate=true"
//
// Database Edition       : Developer Edition (64-bit)
// Database Engine Edition: Enterprise
// Database Version       : 14.0.3480.1
//
// <auto-generated>
#pragma warning disable 1591    //  Ignore "Missing XML Comment" warning

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel.DataAnnotations.Schema;
using System.Data;
using System.Data.Common;
using System.Data.Entity;
using System.Data.Entity.Core.Objects;
using System.Data.Entity.Infrastructure;
using System.Data.Entity.Infrastructure.Annotations;
using System.Data.Entity.Infrastructure.Interception;
using System.Data.Entity.ModelConfiguration;
using System.Data.Entity.Spatial;
using System.Data.Entity.Validation;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Tester.Integration.Ef6
{
    #region Database context interface

    public interface IMyDbContext : IDisposable
    {
        DbSet<AlphabeticalListOfProduct> AlphabeticalListOfProducts { get; set; } // Alphabetical list of products
        DbSet<Category> Categories { get; set; } // Categories
        DbSet<CategorySalesFor1997> CategorySalesFor1997 { get; set; } // Category Sales for 1997
        DbSet<CurrentProductList> CurrentProductLists { get; set; } // Current Product List
        DbSet<Customer> Customers { get; set; } // Customers
        DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; } // Customer and Suppliers by City
        DbSet<CustomerDemographic> CustomerDemographics { get; set; } // CustomerDemographics
        DbSet<Employee> Employees { get; set; } // Employees
        DbSet<Invoice> Invoices { get; set; } // Invoices
        DbSet<Order> Orders { get; set; } // Orders
        DbSet<OrderDetail> OrderDetails { get; set; } // Order Details
        DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; } // Order Details Extended
        DbSet<OrdersQry> OrdersQries { get; set; } // Orders Qry
        DbSet<OrderSubtotal> OrderSubtotals { get; set; } // Order Subtotals
        DbSet<Product> Products { get; set; } // Products
        DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; } // Products Above Average Price
        DbSet<ProductSalesFor1997> ProductSalesFor1997 { get; set; } // Product Sales for 1997
        DbSet<ProductsByCategory> ProductsByCategories { get; set; } // Products by Category
        DbSet<Region> Regions { get; set; } // Region
        DbSet<SalesByCategory> SalesByCategories { get; set; } // Sales by Category
        DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; } // Sales Totals by Amount
        DbSet<Shipper> Shippers { get; set; } // Shippers
        DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; } // Summary of Sales by Quarter
        DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; } // Summary of Sales by Year
        DbSet<Supplier> Suppliers { get; set; } // Suppliers
        DbSet<Territory> Territories { get; set; } // Territories

        int SaveChanges();
        Task<int> SaveChangesAsync();
        Task<int> SaveChangesAsync(CancellationToken cancellationToken);
        DbChangeTracker ChangeTracker { get; }
        DbContextConfiguration Configuration { get; }
        Database Database { get; }
        DbEntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class;
        DbEntityEntry Entry(object entity);
        IEnumerable<DbEntityValidationResult> GetValidationErrors();
        DbSet Set(Type entityType);
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();

        // Stored Procedures
        List<CustOrderHistReturnModel> CustOrderHist(string customerId);
        List<CustOrderHistReturnModel> CustOrderHist(string customerId, out int procResult);
        Task<List<CustOrderHistReturnModel>> CustOrderHistAsync(string customerId, CancellationToken cancellationToken = default(CancellationToken));

        List<CustOrdersDetailReturnModel> CustOrdersDetail(int? orderId);
        List<CustOrdersDetailReturnModel> CustOrdersDetail(int? orderId, out int procResult);
        Task<List<CustOrdersDetailReturnModel>> CustOrdersDetailAsync(int? orderId, CancellationToken cancellationToken = default(CancellationToken));

        List<CustOrdersOrdersReturnModel> CustOrdersOrders(string customerId);
        List<CustOrdersOrdersReturnModel> CustOrdersOrders(string customerId, out int procResult);
        Task<List<CustOrdersOrdersReturnModel>> CustOrdersOrdersAsync(string customerId, CancellationToken cancellationToken = default(CancellationToken));

        List<EmployeeSalesByCountryReturnModel> EmployeeSalesByCountry(DateTime? beginningDate, DateTime? endingDate);
        List<EmployeeSalesByCountryReturnModel> EmployeeSalesByCountry(DateTime? beginningDate, DateTime? endingDate, out int procResult);
        Task<List<EmployeeSalesByCountryReturnModel>> EmployeeSalesByCountryAsync(DateTime? beginningDate, DateTime? endingDate, CancellationToken cancellationToken = default(CancellationToken));

        List<SalesByCategoryReturnModel> SalesByCategory(string categoryName, string ordYear);
        List<SalesByCategoryReturnModel> SalesByCategory(string categoryName, string ordYear, out int procResult);
        Task<List<SalesByCategoryReturnModel>> SalesByCategoryAsync(string categoryName, string ordYear, CancellationToken cancellationToken = default(CancellationToken));

        List<SalesByYearReturnModel> SalesByYear(DateTime? beginningDate, DateTime? endingDate);
        List<SalesByYearReturnModel> SalesByYear(DateTime? beginningDate, DateTime? endingDate, out int procResult);
        Task<List<SalesByYearReturnModel>> SalesByYearAsync(DateTime? beginningDate, DateTime? endingDate, CancellationToken cancellationToken = default(CancellationToken));

        List<TenMostExpensiveProductsReturnModel> TenMostExpensiveProducts();
        List<TenMostExpensiveProductsReturnModel> TenMostExpensiveProducts(out int procResult);
        Task<List<TenMostExpensiveProductsReturnModel>> TenMostExpensiveProductsAsync(CancellationToken cancellationToken = default(CancellationToken));

    }

    #endregion

    #region Database context

    public class MyDbContext : DbContext, IMyDbContext
    {
        public DbSet<AlphabeticalListOfProduct> AlphabeticalListOfProducts { get; set; } // Alphabetical list of products
        public DbSet<Category> Categories { get; set; } // Categories
        public DbSet<CategorySalesFor1997> CategorySalesFor1997 { get; set; } // Category Sales for 1997
        public DbSet<CurrentProductList> CurrentProductLists { get; set; } // Current Product List
        public DbSet<Customer> Customers { get; set; } // Customers
        public DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; } // Customer and Suppliers by City
        public DbSet<CustomerDemographic> CustomerDemographics { get; set; } // CustomerDemographics
        public DbSet<Employee> Employees { get; set; } // Employees
        public DbSet<Invoice> Invoices { get; set; } // Invoices
        public DbSet<Order> Orders { get; set; } // Orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // Order Details
        public DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; } // Order Details Extended
        public DbSet<OrdersQry> OrdersQries { get; set; } // Orders Qry
        public DbSet<OrderSubtotal> OrderSubtotals { get; set; } // Order Subtotals
        public DbSet<Product> Products { get; set; } // Products
        public DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; } // Products Above Average Price
        public DbSet<ProductSalesFor1997> ProductSalesFor1997 { get; set; } // Product Sales for 1997
        public DbSet<ProductsByCategory> ProductsByCategories { get; set; } // Products by Category
        public DbSet<Region> Regions { get; set; } // Region
        public DbSet<SalesByCategory> SalesByCategories { get; set; } // Sales by Category
        public DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; } // Sales Totals by Amount
        public DbSet<Shipper> Shippers { get; set; } // Shippers
        public DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; } // Summary of Sales by Quarter
        public DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; } // Summary of Sales by Year
        public DbSet<Supplier> Suppliers { get; set; } // Suppliers
        public DbSet<Territory> Territories { get; set; } // Territories

        static MyDbContext()
        {
            System.Data.Entity.Database.SetInitializer<MyDbContext>(null);
        }

        /// <inheritdoc />
        public MyDbContext()
            : base("Name=MyDbContext")
        {
        }

        /// <inheritdoc />
        public MyDbContext(string connectionString)
            : base(connectionString)
        {
        }

        /// <inheritdoc />
        public MyDbContext(string connectionString, DbCompiledModel model)
            : base(connectionString, model)
        {
        }

        /// <inheritdoc />
        public MyDbContext(DbConnection existingConnection, bool contextOwnsConnection)
            : base(existingConnection, contextOwnsConnection)
        {
        }

        /// <inheritdoc />
        public MyDbContext(DbConnection existingConnection, DbCompiledModel model, bool contextOwnsConnection)
            : base(existingConnection, model, contextOwnsConnection)
        {
        }

        /// <inheritdoc />
        public MyDbContext(ObjectContext objectContext, bool dbContextOwnsObjectContext)
            : base(objectContext, dbContextOwnsObjectContext)
        {
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        public bool IsSqlParameterNull(SqlParameter param)
        {
            var sqlValue = param.SqlValue;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.Configurations.Add(new AlphabeticalListOfProductConfiguration());
            modelBuilder.Configurations.Add(new CategoryConfiguration());
            modelBuilder.Configurations.Add(new CategorySalesFor1997Configuration());
            modelBuilder.Configurations.Add(new CurrentProductListConfiguration());
            modelBuilder.Configurations.Add(new CustomerConfiguration());
            modelBuilder.Configurations.Add(new CustomerAndSuppliersByCityConfiguration());
            modelBuilder.Configurations.Add(new CustomerDemographicConfiguration());
            modelBuilder.Configurations.Add(new EmployeeConfiguration());
            modelBuilder.Configurations.Add(new InvoiceConfiguration());
            modelBuilder.Configurations.Add(new OrderConfiguration());
            modelBuilder.Configurations.Add(new OrderDetailConfiguration());
            modelBuilder.Configurations.Add(new OrderDetailsExtendedConfiguration());
            modelBuilder.Configurations.Add(new OrdersQryConfiguration());
            modelBuilder.Configurations.Add(new OrderSubtotalConfiguration());
            modelBuilder.Configurations.Add(new ProductConfiguration());
            modelBuilder.Configurations.Add(new ProductsAboveAveragePriceConfiguration());
            modelBuilder.Configurations.Add(new ProductSalesFor1997Configuration());
            modelBuilder.Configurations.Add(new ProductsByCategoryConfiguration());
            modelBuilder.Configurations.Add(new RegionConfiguration());
            modelBuilder.Configurations.Add(new SalesByCategoryConfiguration());
            modelBuilder.Configurations.Add(new SalesTotalsByAmountConfiguration());
            modelBuilder.Configurations.Add(new ShipperConfiguration());
            modelBuilder.Configurations.Add(new SummaryOfSalesByQuarterConfiguration());
            modelBuilder.Configurations.Add(new SummaryOfSalesByYearConfiguration());
            modelBuilder.Configurations.Add(new SupplierConfiguration());
            modelBuilder.Configurations.Add(new TerritoryConfiguration());

            // Indexes
            modelBuilder.Entity<Category>()
                .Property(e => e.CategoryName)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("CategoryName", 1))
                );

            modelBuilder.Entity<Customer>()
                .Property(e => e.CompanyName)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("CompanyName", 1))
                );

            modelBuilder.Entity<Customer>()
                .Property(e => e.City)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("City", 1))
                );

            modelBuilder.Entity<Customer>()
                .Property(e => e.Region)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("Region", 1))
                );

            modelBuilder.Entity<Customer>()
                .Property(e => e.PostalCode)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("PostalCode", 1))
                );

            modelBuilder.Entity<Employee>()
                .Property(e => e.LastName)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("LastName", 1))
                );

            modelBuilder.Entity<Employee>()
                .Property(e => e.PostalCode)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("PostalCode", 1))
                );

            modelBuilder.Entity<Order>()
                .Property(e => e.CustomerId)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new[]
                    {
                        new IndexAttribute("CustomerID", 1),
                        new IndexAttribute("CustomersOrders", 1)
                    }));

            modelBuilder.Entity<Order>()
                .Property(e => e.EmployeeId)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new[]
                    {
                        new IndexAttribute("EmployeeID", 1),
                        new IndexAttribute("EmployeesOrders", 1)
                    }));

            modelBuilder.Entity<Order>()
                .Property(e => e.OrderDate)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("OrderDate", 1))
                );

            modelBuilder.Entity<Order>()
                .Property(e => e.ShippedDate)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("ShippedDate", 1))
                );

            modelBuilder.Entity<Order>()
                .Property(e => e.ShipVia)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("ShippersOrders", 1))
                );

            modelBuilder.Entity<Order>()
                .Property(e => e.ShipPostalCode)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("ShipPostalCode", 1))
                );

            modelBuilder.Entity<OrderDetail>()
                .Property(e => e.OrderId)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new[]
                    {
                        new IndexAttribute("OrderID", 1),
                        new IndexAttribute("OrdersOrder_Details", 1)
                    }));

            modelBuilder.Entity<OrderDetail>()
                .Property(e => e.ProductId)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new[]
                    {
                        new IndexAttribute("ProductID", 1),
                        new IndexAttribute("ProductsOrder_Details", 1)
                    }));

            modelBuilder.Entity<Product>()
                .Property(e => e.ProductName)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("ProductName", 1))
                );

            modelBuilder.Entity<Product>()
                .Property(e => e.SupplierId)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new[]
                    {
                        new IndexAttribute("SupplierID", 1),
                        new IndexAttribute("SuppliersProducts", 1)
                    }));

            modelBuilder.Entity<Product>()
                .Property(e => e.CategoryId)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new[]
                    {
                        new IndexAttribute("CategoriesProducts", 1),
                        new IndexAttribute("CategoryID", 1)
                    }));

            modelBuilder.Entity<Supplier>()
                .Property(e => e.CompanyName)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("CompanyName", 1))
                );

            modelBuilder.Entity<Supplier>()
                .Property(e => e.PostalCode)
                .HasColumnAnnotation(
                    IndexAnnotation.AnnotationName,
                    new IndexAnnotation(new IndexAttribute("PostalCode", 1))
                );

        }

        public static DbModelBuilder CreateModel(DbModelBuilder modelBuilder, string schema)
        {
            modelBuilder.Configurations.Add(new AlphabeticalListOfProductConfiguration(schema));
            modelBuilder.Configurations.Add(new CategoryConfiguration(schema));
            modelBuilder.Configurations.Add(new CategorySalesFor1997Configuration(schema));
            modelBuilder.Configurations.Add(new CurrentProductListConfiguration(schema));
            modelBuilder.Configurations.Add(new CustomerConfiguration(schema));
            modelBuilder.Configurations.Add(new CustomerAndSuppliersByCityConfiguration(schema));
            modelBuilder.Configurations.Add(new CustomerDemographicConfiguration(schema));
            modelBuilder.Configurations.Add(new EmployeeConfiguration(schema));
            modelBuilder.Configurations.Add(new InvoiceConfiguration(schema));
            modelBuilder.Configurations.Add(new OrderConfiguration(schema));
            modelBuilder.Configurations.Add(new OrderDetailConfiguration(schema));
            modelBuilder.Configurations.Add(new OrderDetailsExtendedConfiguration(schema));
            modelBuilder.Configurations.Add(new OrdersQryConfiguration(schema));
            modelBuilder.Configurations.Add(new OrderSubtotalConfiguration(schema));
            modelBuilder.Configurations.Add(new ProductConfiguration(schema));
            modelBuilder.Configurations.Add(new ProductsAboveAveragePriceConfiguration(schema));
            modelBuilder.Configurations.Add(new ProductSalesFor1997Configuration(schema));
            modelBuilder.Configurations.Add(new ProductsByCategoryConfiguration(schema));
            modelBuilder.Configurations.Add(new RegionConfiguration(schema));
            modelBuilder.Configurations.Add(new SalesByCategoryConfiguration(schema));
            modelBuilder.Configurations.Add(new SalesTotalsByAmountConfiguration(schema));
            modelBuilder.Configurations.Add(new ShipperConfiguration(schema));
            modelBuilder.Configurations.Add(new SummaryOfSalesByQuarterConfiguration(schema));
            modelBuilder.Configurations.Add(new SummaryOfSalesByYearConfiguration(schema));
            modelBuilder.Configurations.Add(new SupplierConfiguration(schema));
            modelBuilder.Configurations.Add(new TerritoryConfiguration(schema));

            return modelBuilder;
        }

        // Stored Procedures
        public List<CustOrderHistReturnModel> CustOrderHist(string customerId)
        {
            int procResult;
            return CustOrderHist(customerId, out procResult);
        }

        public List<CustOrderHistReturnModel> CustOrderHist(string customerId, out int procResult)
        {
            var customerIdParam = new SqlParameter { ParameterName = "@CustomerID", SqlDbType = SqlDbType.NChar, Direction = ParameterDirection.Input, Value = customerId, Size = 5 };
            if (customerIdParam.Value == null)
                customerIdParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<CustOrderHistReturnModel>("EXEC @procResult = [dbo].[CustOrderHist] @CustomerID", customerIdParam, procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<CustOrderHistReturnModel>> CustOrderHistAsync(string customerId, CancellationToken cancellationToken = default(CancellationToken))
        {
            var customerIdParam = new SqlParameter { ParameterName = "@CustomerID", SqlDbType = SqlDbType.NChar, Direction = ParameterDirection.Input, Value = customerId, Size = 5 };
            if (customerIdParam.Value == null)
                customerIdParam.Value = DBNull.Value;

            var procResultData = await Database.SqlQuery<CustOrderHistReturnModel>("EXEC [dbo].[CustOrderHist] @CustomerID", customerIdParam).ToListAsync(cancellationToken);
            return procResultData;
        }

        public List<CustOrdersDetailReturnModel> CustOrdersDetail(int? orderId = null)
        {
            int procResult;
            return CustOrdersDetail(orderId, out procResult);
        }

        public List<CustOrdersDetailReturnModel> CustOrdersDetail(int? orderId, out int procResult)
        {
            var orderIdParam = new SqlParameter { ParameterName = "@OrderID", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Input, Value = orderId.GetValueOrDefault(), Precision = 10, Scale = 0 };
            if (!orderId.HasValue)
                orderIdParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<CustOrdersDetailReturnModel>("EXEC @procResult = [dbo].[CustOrdersDetail] @OrderID", orderIdParam, procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<CustOrdersDetailReturnModel>> CustOrdersDetailAsync(int? orderId = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            var orderIdParam = new SqlParameter { ParameterName = "@OrderID", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Input, Value = orderId.GetValueOrDefault(), Precision = 10, Scale = 0 };
            if (!orderId.HasValue)
                orderIdParam.Value = DBNull.Value;

            var procResultData = await Database.SqlQuery<CustOrdersDetailReturnModel>("EXEC [dbo].[CustOrdersDetail] @OrderID", orderIdParam).ToListAsync(cancellationToken);
            return procResultData;
        }

        public List<CustOrdersOrdersReturnModel> CustOrdersOrders(string customerId)
        {
            int procResult;
            return CustOrdersOrders(customerId, out procResult);
        }

        public List<CustOrdersOrdersReturnModel> CustOrdersOrders(string customerId, out int procResult)
        {
            var customerIdParam = new SqlParameter { ParameterName = "@CustomerID", SqlDbType = SqlDbType.NChar, Direction = ParameterDirection.Input, Value = customerId, Size = 5 };
            if (customerIdParam.Value == null)
                customerIdParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<CustOrdersOrdersReturnModel>("EXEC @procResult = [dbo].[CustOrdersOrders] @CustomerID", customerIdParam, procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<CustOrdersOrdersReturnModel>> CustOrdersOrdersAsync(string customerId, CancellationToken cancellationToken = default(CancellationToken))
        {
            var customerIdParam = new SqlParameter { ParameterName = "@CustomerID", SqlDbType = SqlDbType.NChar, Direction = ParameterDirection.Input, Value = customerId, Size = 5 };
            if (customerIdParam.Value == null)
                customerIdParam.Value = DBNull.Value;

            var procResultData = await Database.SqlQuery<CustOrdersOrdersReturnModel>("EXEC [dbo].[CustOrdersOrders] @CustomerID", customerIdParam).ToListAsync(cancellationToken);
            return procResultData;
        }

        public List<EmployeeSalesByCountryReturnModel> EmployeeSalesByCountry(DateTime? beginningDate = null, DateTime? endingDate = null)
        {
            int procResult;
            return EmployeeSalesByCountry(beginningDate, endingDate, out procResult);
        }

        public List<EmployeeSalesByCountryReturnModel> EmployeeSalesByCountry(DateTime? beginningDate, DateTime? endingDate, out int procResult)
        {
            var beginningDateParam = new SqlParameter { ParameterName = "@Beginning_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = beginningDate.GetValueOrDefault() };
            if (!beginningDate.HasValue)
                beginningDateParam.Value = DBNull.Value;

            var endingDateParam = new SqlParameter { ParameterName = "@Ending_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = endingDate.GetValueOrDefault() };
            if (!endingDate.HasValue)
                endingDateParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<EmployeeSalesByCountryReturnModel>("EXEC @procResult = [dbo].[Employee Sales by Country] @Beginning_Date, @Ending_Date", beginningDateParam, endingDateParam, procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<EmployeeSalesByCountryReturnModel>> EmployeeSalesByCountryAsync(DateTime? beginningDate = null, DateTime? endingDate = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            var beginningDateParam = new SqlParameter { ParameterName = "@Beginning_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = beginningDate.GetValueOrDefault() };
            if (!beginningDate.HasValue)
                beginningDateParam.Value = DBNull.Value;

            var endingDateParam = new SqlParameter { ParameterName = "@Ending_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = endingDate.GetValueOrDefault() };
            if (!endingDate.HasValue)
                endingDateParam.Value = DBNull.Value;

            var procResultData = await Database.SqlQuery<EmployeeSalesByCountryReturnModel>("EXEC [dbo].[Employee Sales by Country] @Beginning_Date, @Ending_Date", beginningDateParam, endingDateParam).ToListAsync(cancellationToken);
            return procResultData;
        }

        public List<SalesByCategoryReturnModel> SalesByCategory(string categoryName, string ordYear)
        {
            int procResult;
            return SalesByCategory(categoryName, ordYear, out procResult);
        }

        public List<SalesByCategoryReturnModel> SalesByCategory(string categoryName, string ordYear, out int procResult)
        {
            var categoryNameParam = new SqlParameter { ParameterName = "@CategoryName", SqlDbType = SqlDbType.NVarChar, Direction = ParameterDirection.Input, Value = categoryName, Size = 15 };
            if (categoryNameParam.Value == null)
                categoryNameParam.Value = DBNull.Value;

            var ordYearParam = new SqlParameter { ParameterName = "@OrdYear", SqlDbType = SqlDbType.NVarChar, Direction = ParameterDirection.Input, Value = ordYear, Size = 4 };
            if (ordYearParam.Value == null)
                ordYearParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<SalesByCategoryReturnModel>("EXEC @procResult = [dbo].[SalesByCategory] @CategoryName, @OrdYear", categoryNameParam, ordYearParam, procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<SalesByCategoryReturnModel>> SalesByCategoryAsync(string categoryName, string ordYear, CancellationToken cancellationToken = default(CancellationToken))
        {
            var categoryNameParam = new SqlParameter { ParameterName = "@CategoryName", SqlDbType = SqlDbType.NVarChar, Direction = ParameterDirection.Input, Value = categoryName, Size = 15 };
            if (categoryNameParam.Value == null)
                categoryNameParam.Value = DBNull.Value;

            var ordYearParam = new SqlParameter { ParameterName = "@OrdYear", SqlDbType = SqlDbType.NVarChar, Direction = ParameterDirection.Input, Value = ordYear, Size = 4 };
            if (ordYearParam.Value == null)
                ordYearParam.Value = DBNull.Value;

            var procResultData = await Database.SqlQuery<SalesByCategoryReturnModel>("EXEC [dbo].[SalesByCategory] @CategoryName, @OrdYear", categoryNameParam, ordYearParam).ToListAsync(cancellationToken);
            return procResultData;
        }

        public List<SalesByYearReturnModel> SalesByYear(DateTime? beginningDate = null, DateTime? endingDate = null)
        {
            int procResult;
            return SalesByYear(beginningDate, endingDate, out procResult);
        }

        public List<SalesByYearReturnModel> SalesByYear(DateTime? beginningDate, DateTime? endingDate, out int procResult)
        {
            var beginningDateParam = new SqlParameter { ParameterName = "@Beginning_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = beginningDate.GetValueOrDefault() };
            if (!beginningDate.HasValue)
                beginningDateParam.Value = DBNull.Value;

            var endingDateParam = new SqlParameter { ParameterName = "@Ending_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = endingDate.GetValueOrDefault() };
            if (!endingDate.HasValue)
                endingDateParam.Value = DBNull.Value;

            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<SalesByYearReturnModel>("EXEC @procResult = [dbo].[Sales by Year] @Beginning_Date, @Ending_Date", beginningDateParam, endingDateParam, procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<SalesByYearReturnModel>> SalesByYearAsync(DateTime? beginningDate = null, DateTime? endingDate = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            var beginningDateParam = new SqlParameter { ParameterName = "@Beginning_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = beginningDate.GetValueOrDefault() };
            if (!beginningDate.HasValue)
                beginningDateParam.Value = DBNull.Value;

            var endingDateParam = new SqlParameter { ParameterName = "@Ending_Date", SqlDbType = SqlDbType.DateTime, Direction = ParameterDirection.Input, Value = endingDate.GetValueOrDefault() };
            if (!endingDate.HasValue)
                endingDateParam.Value = DBNull.Value;

            var procResultData = await Database.SqlQuery<SalesByYearReturnModel>("EXEC [dbo].[Sales by Year] @Beginning_Date, @Ending_Date", beginningDateParam, endingDateParam).ToListAsync(cancellationToken);
            return procResultData;
        }

        public List<TenMostExpensiveProductsReturnModel> TenMostExpensiveProducts()
        {
            int procResult;
            return TenMostExpensiveProducts(out procResult);
        }

        public List<TenMostExpensiveProductsReturnModel> TenMostExpensiveProducts(out int procResult)
        {
            var procResultParam = new SqlParameter { ParameterName = "@procResult", SqlDbType = SqlDbType.Int, Direction = ParameterDirection.Output };
            var procResultData = Database.SqlQuery<TenMostExpensiveProductsReturnModel>("EXEC @procResult = [dbo].[Ten Most Expensive Products]", procResultParam).ToList();
            procResult = (int) procResultParam.Value;
            return procResultData;
        }

        public async Task<List<TenMostExpensiveProductsReturnModel>> TenMostExpensiveProductsAsync(CancellationToken cancellationToken = default(CancellationToken))
        {
            var procResultData = await Database.SqlQuery<TenMostExpensiveProductsReturnModel>("EXEC [dbo].[Ten Most Expensive Products]").ToListAsync(cancellationToken);
            return procResultData;
        }

    }

    #endregion

    #region Database context factory

    public class MyDbContextFactory : IDbContextFactory<MyDbContext>
    {
        public MyDbContext Create()
        {
            return new MyDbContext();
        }
    }

    #endregion

    #region Fake Database context

    public class FakeMyDbContext : IMyDbContext
    {
        public DbSet<AlphabeticalListOfProduct> AlphabeticalListOfProducts { get; set; } // Alphabetical list of products
        public DbSet<Category> Categories { get; set; } // Categories
        public DbSet<CategorySalesFor1997> CategorySalesFor1997 { get; set; } // Category Sales for 1997
        public DbSet<CurrentProductList> CurrentProductLists { get; set; } // Current Product List
        public DbSet<Customer> Customers { get; set; } // Customers
        public DbSet<CustomerAndSuppliersByCity> CustomerAndSuppliersByCities { get; set; } // Customer and Suppliers by City
        public DbSet<CustomerDemographic> CustomerDemographics { get; set; } // CustomerDemographics
        public DbSet<Employee> Employees { get; set; } // Employees
        public DbSet<Invoice> Invoices { get; set; } // Invoices
        public DbSet<Order> Orders { get; set; } // Orders
        public DbSet<OrderDetail> OrderDetails { get; set; } // Order Details
        public DbSet<OrderDetailsExtended> OrderDetailsExtendeds { get; set; } // Order Details Extended
        public DbSet<OrdersQry> OrdersQries { get; set; } // Orders Qry
        public DbSet<OrderSubtotal> OrderSubtotals { get; set; } // Order Subtotals
        public DbSet<Product> Products { get; set; } // Products
        public DbSet<ProductsAboveAveragePrice> ProductsAboveAveragePrices { get; set; } // Products Above Average Price
        public DbSet<ProductSalesFor1997> ProductSalesFor1997 { get; set; } // Product Sales for 1997
        public DbSet<ProductsByCategory> ProductsByCategories { get; set; } // Products by Category
        public DbSet<Region> Regions { get; set; } // Region
        public DbSet<SalesByCategory> SalesByCategories { get; set; } // Sales by Category
        public DbSet<SalesTotalsByAmount> SalesTotalsByAmounts { get; set; } // Sales Totals by Amount
        public DbSet<Shipper> Shippers { get; set; } // Shippers
        public DbSet<SummaryOfSalesByQuarter> SummaryOfSalesByQuarters { get; set; } // Summary of Sales by Quarter
        public DbSet<SummaryOfSalesByYear> SummaryOfSalesByYears { get; set; } // Summary of Sales by Year
        public DbSet<Supplier> Suppliers { get; set; } // Suppliers
        public DbSet<Territory> Territories { get; set; } // Territories

        public FakeMyDbContext()
        {
            _changeTracker = null;
            _configuration = null;
            _database = null;

            AlphabeticalListOfProducts = new FakeDbSet<AlphabeticalListOfProduct>("ProductId", "ProductName", "Discontinued", "CategoryName");
            Categories = new FakeDbSet<Category>("CategoryId");
            CategorySalesFor1997 = new FakeDbSet<CategorySalesFor1997>("CategoryName");
            CurrentProductLists = new FakeDbSet<CurrentProductList>("ProductId", "ProductName");
            Customers = new FakeDbSet<Customer>("CustomerId");
            CustomerAndSuppliersByCities = new FakeDbSet<CustomerAndSuppliersByCity>("CompanyName", "Relationship");
            CustomerDemographics = new FakeDbSet<CustomerDemographic>("CustomerTypeId");
            Employees = new FakeDbSet<Employee>("EmployeeId");
            Invoices = new FakeDbSet<Invoice>("CustomerName", "Salesperson", "OrderId", "ShipperName", "ProductId", "ProductName", "UnitPrice", "Quantity", "Discount");
            Orders = new FakeDbSet<Order>("OrderId");
            OrderDetails = new FakeDbSet<OrderDetail>("OrderId", "ProductId");
            OrderDetailsExtendeds = new FakeDbSet<OrderDetailsExtended>("OrderId", "ProductId", "ProductName", "UnitPrice", "Quantity", "Discount");
            OrdersQries = new FakeDbSet<OrdersQry>("OrderId", "CompanyName");
            OrderSubtotals = new FakeDbSet<OrderSubtotal>("OrderId");
            Products = new FakeDbSet<Product>("ProductId");
            ProductsAboveAveragePrices = new FakeDbSet<ProductsAboveAveragePrice>("ProductName");
            ProductSalesFor1997 = new FakeDbSet<ProductSalesFor1997>("CategoryName", "ProductName");
            ProductsByCategories = new FakeDbSet<ProductsByCategory>("CategoryName", "ProductName", "Discontinued");
            Regions = new FakeDbSet<Region>("RegionId");
            SalesByCategories = new FakeDbSet<SalesByCategory>("CategoryId", "CategoryName", "ProductName");
            SalesTotalsByAmounts = new FakeDbSet<SalesTotalsByAmount>("OrderId", "CompanyName");
            Shippers = new FakeDbSet<Shipper>("ShipperId");
            SummaryOfSalesByQuarters = new FakeDbSet<SummaryOfSalesByQuarter>("OrderId");
            SummaryOfSalesByYears = new FakeDbSet<SummaryOfSalesByYear>("OrderId");
            Suppliers = new FakeDbSet<Supplier>("SupplierId");
            Territories = new FakeDbSet<Territory>("TerritoryId");

        }

        public int SaveChangesCount { get; private set; }
        public int SaveChanges()
        {
            ++SaveChangesCount;
            return 1;
        }

        public Task<int> SaveChangesAsync()
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1);
        }

        public Task<int> SaveChangesAsync(CancellationToken cancellationToken)
        {
            ++SaveChangesCount;
            return Task<int>.Factory.StartNew(() => 1, cancellationToken);
        }

        protected virtual void Dispose(bool disposing)
        {
        }

        public void Dispose()
        {
            Dispose(true);
        }

        private DbChangeTracker _changeTracker;

        public DbChangeTracker ChangeTracker { get { return _changeTracker; } }

        private DbContextConfiguration _configuration;

        public DbContextConfiguration Configuration { get { return _configuration; } }

        private Database _database;

        public Database Database { get { return _database; } }

        public DbEntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class
        {
            throw new NotImplementedException();
        }

        public DbEntityEntry Entry(object entity)
        {
            throw new NotImplementedException();
        }

        public IEnumerable<DbEntityValidationResult> GetValidationErrors()
        {
            throw new NotImplementedException();
        }

        public DbSet Set(Type entityType)
        {
            throw new NotImplementedException();
        }

        public DbSet<TEntity> Set<TEntity>() where TEntity : class
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            throw new NotImplementedException();
        }

        // Stored Procedures

        public List<CustOrderHistReturnModel> CustOrderHist(string customerId)
        {
            int procResult;
            return CustOrderHist(customerId, out procResult);
        }

        public List<CustOrderHistReturnModel> CustOrderHist(string customerId, out int procResult)
        {
            procResult = 0;
            return new List<CustOrderHistReturnModel>();
        }

        public Task<List<CustOrderHistReturnModel>> CustOrderHistAsync(string customerId, CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(CustOrderHist(customerId, out procResult));
        }

        public List<CustOrdersDetailReturnModel> CustOrdersDetail(int? orderId = null)
        {
            int procResult;
            return CustOrdersDetail(orderId, out procResult);
        }

        public List<CustOrdersDetailReturnModel> CustOrdersDetail(int? orderId, out int procResult)
        {
            procResult = 0;
            return new List<CustOrdersDetailReturnModel>();
        }

        public Task<List<CustOrdersDetailReturnModel>> CustOrdersDetailAsync(int? orderId = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(CustOrdersDetail(orderId, out procResult));
        }

        public List<CustOrdersOrdersReturnModel> CustOrdersOrders(string customerId)
        {
            int procResult;
            return CustOrdersOrders(customerId, out procResult);
        }

        public List<CustOrdersOrdersReturnModel> CustOrdersOrders(string customerId, out int procResult)
        {
            procResult = 0;
            return new List<CustOrdersOrdersReturnModel>();
        }

        public Task<List<CustOrdersOrdersReturnModel>> CustOrdersOrdersAsync(string customerId, CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(CustOrdersOrders(customerId, out procResult));
        }

        public List<EmployeeSalesByCountryReturnModel> EmployeeSalesByCountry(DateTime? beginningDate = null, DateTime? endingDate = null)
        {
            int procResult;
            return EmployeeSalesByCountry(beginningDate, endingDate, out procResult);
        }

        public List<EmployeeSalesByCountryReturnModel> EmployeeSalesByCountry(DateTime? beginningDate, DateTime? endingDate, out int procResult)
        {
            procResult = 0;
            return new List<EmployeeSalesByCountryReturnModel>();
        }

        public Task<List<EmployeeSalesByCountryReturnModel>> EmployeeSalesByCountryAsync(DateTime? beginningDate = null, DateTime? endingDate = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(EmployeeSalesByCountry(beginningDate, endingDate, out procResult));
        }

        public List<SalesByCategoryReturnModel> SalesByCategory(string categoryName, string ordYear)
        {
            int procResult;
            return SalesByCategory(categoryName, ordYear, out procResult);
        }

        public List<SalesByCategoryReturnModel> SalesByCategory(string categoryName, string ordYear, out int procResult)
        {
            procResult = 0;
            return new List<SalesByCategoryReturnModel>();
        }

        public Task<List<SalesByCategoryReturnModel>> SalesByCategoryAsync(string categoryName, string ordYear, CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(SalesByCategory(categoryName, ordYear, out procResult));
        }

        public List<SalesByYearReturnModel> SalesByYear(DateTime? beginningDate = null, DateTime? endingDate = null)
        {
            int procResult;
            return SalesByYear(beginningDate, endingDate, out procResult);
        }

        public List<SalesByYearReturnModel> SalesByYear(DateTime? beginningDate, DateTime? endingDate, out int procResult)
        {
            procResult = 0;
            return new List<SalesByYearReturnModel>();
        }

        public Task<List<SalesByYearReturnModel>> SalesByYearAsync(DateTime? beginningDate = null, DateTime? endingDate = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(SalesByYear(beginningDate, endingDate, out procResult));
        }

        public List<TenMostExpensiveProductsReturnModel> TenMostExpensiveProducts()
        {
            int procResult;
            return TenMostExpensiveProducts(out procResult);
        }

        public List<TenMostExpensiveProductsReturnModel> TenMostExpensiveProducts(out int procResult)
        {
            procResult = 0;
            return new List<TenMostExpensiveProductsReturnModel>();
        }

        public Task<List<TenMostExpensiveProductsReturnModel>> TenMostExpensiveProductsAsync(CancellationToken cancellationToken = default(CancellationToken))
        {
            int procResult;
            return Task.FromResult(TenMostExpensiveProducts(out procResult));
        }
    }

    #endregion

    #region Fake DbSet

    // ************************************************************************
    // Fake DbSet
    // Implementing Find:
    //      The Find method is difficult to implement in a generic fashion. If
    //      you need to test code that makes use of the Find method it is
    //      easiest to create a test DbSet for each of the entity types that
    //      need to support find. You can then write logic to find that
    //      particular type of entity, as shown below:
    //      public class FakeBlogDbSet : FakeDbSet<Blog>
    //      {
    //          public override Blog Find(params object[] keyValues)
    //          {
    //              var id = (int) keyValues.Single();
    //              return this.SingleOrDefault(b => b.BlogId == id);
    //          }
    //      }
    //      Read more about it here: https://msdn.microsoft.com/en-us/data/dn314431.aspx
    public class FakeDbSet<TEntity> : DbSet<TEntity>, IQueryable, IEnumerable<TEntity>, IDbAsyncEnumerable<TEntity> where TEntity : class
    {
        private readonly PropertyInfo[] _primaryKeys;
        private readonly ObservableCollection<TEntity> _data;
        private readonly IQueryable _query;

        public FakeDbSet()
        {
            _data = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public FakeDbSet(params string[] primaryKeys)
        {
            _primaryKeys = typeof(TEntity).GetProperties().Where(x => primaryKeys.Contains(x.Name)).ToArray();
            _data = new ObservableCollection<TEntity>();
            _query = _data.AsQueryable();
        }

        public override TEntity Find(params object[] keyValues)
        {
            if (_primaryKeys == null)
                throw new ArgumentException("No primary keys defined");
            if (keyValues.Length != _primaryKeys.Length)
                throw new ArgumentException("Incorrect number of keys passed to Find method");

            var keyQuery = this.AsQueryable();
            keyQuery = keyValues
                .Select((t, i) => i)
                .Aggregate(keyQuery,
                    (current, x) =>
                        current.Where(entity => _primaryKeys[x].GetValue(entity, null).Equals(keyValues[x])));

            return keyQuery.SingleOrDefault();
        }

        public override Task<TEntity> FindAsync(CancellationToken cancellationToken, params object[] keyValues)
        {
            return Task<TEntity>.Factory.StartNew(() => Find(keyValues), cancellationToken);
        }

        public override Task<TEntity> FindAsync(params object[] keyValues)
        {
            return Task<TEntity>.Factory.StartNew(() => Find(keyValues));
        }

        public override IEnumerable<TEntity> AddRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var items = entities.ToList();
            foreach (var entity in items)
            {
                _data.Add(entity);
            }
            return items;
        }

        public override TEntity Add(TEntity item)
        {
            if (item == null) throw new ArgumentNullException("item");
            _data.Add(item);
            return item;
        }

        public override IEnumerable<TEntity> RemoveRange(IEnumerable<TEntity> entities)
        {
            if (entities == null) throw new ArgumentNullException("entities");
            var items = entities.ToList();
            foreach (var entity in items)
            {
                _data.Remove(entity);
            }
            return items;
        }

        public override TEntity Remove(TEntity item)
        {
            if (item == null) throw new ArgumentNullException("item");
            _data.Remove(item);
            return item;
        }

        public override TEntity Attach(TEntity item)
        {
            if (item == null) throw new ArgumentNullException("item");
            _data.Add(item);
            return item;
        }

        public override TEntity Create()
        {
            return Activator.CreateInstance<TEntity>();
        }

        public override TDerivedEntity Create<TDerivedEntity>()
        {
            return Activator.CreateInstance<TDerivedEntity>();
        }

        public override ObservableCollection<TEntity> Local
        {
            get { return _data; }
        }

        Type IQueryable.ElementType
        {
            get { return _query.ElementType; }
        }

        Expression IQueryable.Expression
        {
            get { return _query.Expression; }
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<TEntity>(_query.Provider); }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IEnumerator<TEntity> IEnumerable<TEntity>.GetEnumerator()
        {
            return _data.GetEnumerator();
        }

        IDbAsyncEnumerator<TEntity> IDbAsyncEnumerable<TEntity>.GetAsyncEnumerator()
        {
            return new FakeDbAsyncEnumerator<TEntity>(_data.GetEnumerator());
        }
    }

    public class FakeDbAsyncQueryProvider<TEntity> : IDbAsyncQueryProvider
    {
        private readonly IQueryProvider _inner;

        public FakeDbAsyncQueryProvider(IQueryProvider inner)
        {
            _inner = inner;
        }

        public IQueryable CreateQuery(Expression expression)
        {
            var m = expression as MethodCallExpression;
            if (m != null)
            {
                var resultType = m.Method.ReturnType; // it should be IQueryable<T>
                var tElement = resultType.GetGenericArguments()[0];
                var queryType = typeof(FakeDbAsyncEnumerable<>).MakeGenericType(tElement);
                return (IQueryable) Activator.CreateInstance(queryType, expression);
            }
            return new FakeDbAsyncEnumerable<TEntity>(expression);
        }

        public IQueryable<TElement> CreateQuery<TElement>(Expression expression)
        {
            var queryType = typeof(FakeDbAsyncEnumerable<>).MakeGenericType(typeof(TElement));
            return (IQueryable<TElement>) Activator.CreateInstance(queryType, expression);
        }

        public object Execute(Expression expression)
        {
            return _inner.Execute(expression);
        }

        public TResult Execute<TResult>(Expression expression)
        {
            return _inner.Execute<TResult>(expression);
        }

        public Task<object> ExecuteAsync(Expression expression, CancellationToken cancellationToken)
        {
            return Task.FromResult(Execute(expression));
        }

        public Task<TResult> ExecuteAsync<TResult>(Expression expression, CancellationToken cancellationToken)
        {
            return Task.FromResult(Execute<TResult>(expression));
        }
    }

    public class FakeDbAsyncEnumerable<T> : EnumerableQuery<T>, IDbAsyncEnumerable<T>, IQueryable<T>
    {
        public FakeDbAsyncEnumerable(IEnumerable<T> enumerable)
            : base(enumerable)
        { }

        public FakeDbAsyncEnumerable(Expression expression)
            : base(expression)
        { }

        public IDbAsyncEnumerator<T> GetAsyncEnumerator()
        {
            return new FakeDbAsyncEnumerator<T>(this.AsEnumerable().GetEnumerator());
        }

        IDbAsyncEnumerator IDbAsyncEnumerable.GetAsyncEnumerator()
        {
            return GetAsyncEnumerator();
        }

        IQueryProvider IQueryable.Provider
        {
            get { return new FakeDbAsyncQueryProvider<T>(this); }
        }

    }

    public class FakeDbAsyncEnumerator<T> : IDbAsyncEnumerator<T>
    {
        private readonly IEnumerator<T> _inner;

        public FakeDbAsyncEnumerator(IEnumerator<T> inner)
        {
            _inner = inner;
        }

        public void Dispose()
        {
            _inner.Dispose();
        }

        public Task<bool> MoveNextAsync(CancellationToken cancellationToken)
        {
            return Task.FromResult(_inner.MoveNext());
        }

        public T Current
        {
            get { return _inner.Current; }
        }

        object IDbAsyncEnumerator.Current
        {
            get { return Current; }
        }
    }

    #endregion

    #region POCO classes

    // Alphabetical list of products
    public class AlphabeticalListOfProduct
    {
        public int ProductId { get; set; } // ProductID (Primary key)
        public const string ProductIdField = "ProductId";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public int? SupplierId { get; set; } // SupplierID
        public const string SupplierIdField = "SupplierId";
        public int? CategoryId { get; set; } // CategoryID
        public const string CategoryIdField = "CategoryId";
        public string QuantityPerUnit { get; set; } // QuantityPerUnit (length: 20)
        public const string QuantityPerUnitField = "QuantityPerUnit";
        public decimal? UnitPrice { get; set; } // UnitPrice
        public const string UnitPriceField = "UnitPrice";
        public short? UnitsInStock { get; set; } // UnitsInStock
        public const string UnitsInStockField = "UnitsInStock";
        public short? UnitsOnOrder { get; set; } // UnitsOnOrder
        public const string UnitsOnOrderField = "UnitsOnOrder";
        public short? ReorderLevel { get; set; } // ReorderLevel
        public const string ReorderLevelField = "ReorderLevel";
        public bool Discontinued { get; set; } // Discontinued (Primary key)
        public const string DiscontinuedField = "Discontinued";
        public string CategoryName { get; set; } // CategoryName (Primary key) (length: 15)
        public const string CategoryNameField = "CategoryName";
    }

    // Categories
    public class Category
    {
        public int CategoryId { get; set; } // CategoryID (Primary key)
        public const string CategoryIdField = "CategoryId";
        public string CategoryName { get; set; } // CategoryName (length: 15)
        public const string CategoryNameField = "CategoryName";
        public string Description { get; set; } // Description (length: 1073741823)
        public const string DescriptionField = "Description";
        public byte[] Picture { get; set; } // Picture (length: 2147483647)
        public const string PictureField = "Picture";

        // Reverse navigation

        /// <summary>
        /// Child Products where [Products].[CategoryID] point to this entity (FK_Products_Categories)
        /// </summary>
        public ICollection<Product> Products { get; set; } // Products.FK_Products_Categories

        public Category()
        {
            Products = new List<Product>();
        }
    }

    // Category Sales for 1997
    public class CategorySalesFor1997
    {
        public string CategoryName { get; set; } // CategoryName (Primary key) (length: 15)
        public const string CategoryNameField = "CategoryName";
        public decimal? CategorySales { get; set; } // CategorySales
        public const string CategorySalesField = "CategorySales";
    }

    // Current Product List
    public class CurrentProductList
    {
        public int ProductId { get; set; } // ProductID (Primary key)
        public const string ProductIdField = "ProductId";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
    }

    // Customers
    public class Customer
    {
        public string CustomerId { get; set; } // CustomerID (Primary key) (length: 5)
        public const string CustomerIdField = "CustomerId";
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public const string CompanyNameField = "CompanyName";
        public string ContactName { get; set; } // ContactName (length: 30)
        public const string ContactNameField = "ContactName";
        public string ContactTitle { get; set; } // ContactTitle (length: 30)
        public const string ContactTitleField = "ContactTitle";
        public string Address { get; set; } // Address (length: 60)
        public const string AddressField = "Address";
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string Region { get; set; } // Region (length: 15)
        public const string RegionField = "Region";
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public const string PostalCodeField = "PostalCode";
        public string Country { get; set; } // Country (length: 15)
        public const string CountryField = "Country";
        public string Phone { get; set; } // Phone (length: 24)
        public const string PhoneField = "Phone";
        public string Fax { get; set; } // Fax (length: 24)
        public const string FaxField = "Fax";

        // Reverse navigation

        /// <summary>
        /// Child CustomerDemographics (Many-to-Many) mapped by table [CustomerCustomerDemo]
        /// </summary>
        public ICollection<CustomerDemographic> CustomerDemographics { get; set; } // Many to many mapping

        /// <summary>
        /// Child Orders where [Orders].[CustomerID] point to this entity (FK_Orders_Customers)
        /// </summary>
        public ICollection<Order> Orders { get; set; } // Orders.FK_Orders_Customers

        public Customer()
        {
            Orders = new List<Order>();
            CustomerDemographics = new List<CustomerDemographic>();
        }
    }

    // Customer and Suppliers by City
    public class CustomerAndSuppliersByCity
    {
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string CompanyName { get; set; } // CompanyName (Primary key) (length: 40)
        public const string CompanyNameField = "CompanyName";
        public string ContactName { get; set; } // ContactName (length: 30)
        public const string ContactNameField = "ContactName";
        public string Relationship { get; set; } // Relationship (Primary key) (length: 9)
        public const string RelationshipField = "Relationship";
    }

    // CustomerDemographics
    public class CustomerDemographic
    {
        public string CustomerTypeId { get; set; } // CustomerTypeID (Primary key) (length: 10)
        public const string CustomerTypeIdField = "CustomerTypeId";
        public string CustomerDesc { get; set; } // CustomerDesc (length: 1073741823)
        public const string CustomerDescField = "CustomerDesc";

        // Reverse navigation

        /// <summary>
        /// Child Customers (Many-to-Many) mapped by table [CustomerCustomerDemo]
        /// </summary>
        public ICollection<Customer> Customers { get; set; } // Many to many mapping

        public CustomerDemographic()
        {
            Customers = new List<Customer>();
        }
    }

    // Employees
    public class Employee
    {
        public int EmployeeId { get; set; } // EmployeeID (Primary key)
        public const string EmployeeIdField = "EmployeeId";
        public string LastName { get; set; } // LastName (length: 20)
        public const string LastNameField = "LastName";
        public string FirstName { get; set; } // FirstName (length: 10)
        public const string FirstNameField = "FirstName";
        public string Title { get; set; } // Title (length: 30)
        public const string TitleField = "Title";
        public string TitleOfCourtesy { get; set; } // TitleOfCourtesy (length: 25)
        public const string TitleOfCourtesyField = "TitleOfCourtesy";
        public DateTime? BirthDate { get; set; } // BirthDate
        public const string BirthDateField = "BirthDate";
        public DateTime? HireDate { get; set; } // HireDate
        public const string HireDateField = "HireDate";
        public string Address { get; set; } // Address (length: 60)
        public const string AddressField = "Address";
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string Region { get; set; } // Region (length: 15)
        public const string RegionField = "Region";
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public const string PostalCodeField = "PostalCode";
        public string Country { get; set; } // Country (length: 15)
        public const string CountryField = "Country";
        public string HomePhone { get; set; } // HomePhone (length: 24)
        public const string HomePhoneField = "HomePhone";
        public string Extension { get; set; } // Extension (length: 4)
        public const string ExtensionField = "Extension";
        public byte[] Photo { get; set; } // Photo (length: 2147483647)
        public const string PhotoField = "Photo";
        public string Notes { get; set; } // Notes (length: 1073741823)
        public const string NotesField = "Notes";
        public int? ReportsTo { get; set; } // ReportsTo
        public const string ReportsToField = "ReportsTo";
        public string PhotoPath { get; set; } // PhotoPath (length: 255)
        public const string PhotoPathField = "PhotoPath";

        // Reverse navigation

        /// <summary>
        /// Child Employees where [Employees].[ReportsTo] point to this entity (FK_Employees_Employees)
        /// </summary>
        public ICollection<Employee> Employees { get; set; } // Employees.FK_Employees_Employees

        /// <summary>
        /// Child Orders where [Orders].[EmployeeID] point to this entity (FK_Orders_Employees)
        /// </summary>
        public ICollection<Order> Orders { get; set; } // Orders.FK_Orders_Employees

        /// <summary>
        /// Child Territories (Many-to-Many) mapped by table [EmployeeTerritories]
        /// </summary>
        public ICollection<Territory> Territories { get; set; } // Many to many mapping

        // Foreign keys

        /// <summary>
        /// Parent Employee pointed by [Employees].([ReportsTo]) (FK_Employees_Employees)
        /// </summary>
        public Employee Employee_ReportsTo { get; set; } // FK_Employees_Employees

        public Employee()
        {
            Employees = new List<Employee>();
            Orders = new List<Order>();
            Territories = new List<Territory>();
        }
    }

    // Invoices
    public class Invoice
    {
        public string ShipName { get; set; } // ShipName (length: 40)
        public const string ShipNameField = "ShipName";
        public string ShipAddress { get; set; } // ShipAddress (length: 60)
        public const string ShipAddressField = "ShipAddress";
        public string ShipCity { get; set; } // ShipCity (length: 15)
        public const string ShipCityField = "ShipCity";
        public string ShipRegion { get; set; } // ShipRegion (length: 15)
        public const string ShipRegionField = "ShipRegion";
        public string ShipPostalCode { get; set; } // ShipPostalCode (length: 10)
        public const string ShipPostalCodeField = "ShipPostalCode";
        public string ShipCountry { get; set; } // ShipCountry (length: 15)
        public const string ShipCountryField = "ShipCountry";
        public string CustomerId { get; set; } // CustomerID (length: 5)
        public const string CustomerIdField = "CustomerId";
        public string CustomerName { get; set; } // CustomerName (Primary key) (length: 40)
        public const string CustomerNameField = "CustomerName";
        public string Address { get; set; } // Address (length: 60)
        public const string AddressField = "Address";
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string Region { get; set; } // Region (length: 15)
        public const string RegionField = "Region";
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public const string PostalCodeField = "PostalCode";
        public string Country { get; set; } // Country (length: 15)
        public const string CountryField = "Country";
        public string Salesperson { get; set; } // Salesperson (Primary key) (length: 31)
        public const string SalespersonField = "Salesperson";
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public DateTime? OrderDate { get; set; } // OrderDate
        public const string OrderDateField = "OrderDate";
        public DateTime? RequiredDate { get; set; } // RequiredDate
        public const string RequiredDateField = "RequiredDate";
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public const string ShippedDateField = "ShippedDate";
        public string ShipperName { get; set; } // ShipperName (Primary key) (length: 40)
        public const string ShipperNameField = "ShipperName";
        public int ProductId { get; set; } // ProductID (Primary key)
        public const string ProductIdField = "ProductId";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public decimal UnitPrice { get; set; } // UnitPrice (Primary key)
        public const string UnitPriceField = "UnitPrice";
        public short Quantity { get; set; } // Quantity (Primary key)
        public const string QuantityField = "Quantity";
        public float Discount { get; set; } // Discount (Primary key)
        public const string DiscountField = "Discount";
        public decimal? ExtendedPrice { get; set; } // ExtendedPrice
        public const string ExtendedPriceField = "ExtendedPrice";
        public decimal? Freight { get; set; } // Freight
        public const string FreightField = "Freight";
    }

    // Orders
    public class Order
    {
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public string CustomerId { get; set; } // CustomerID (length: 5)
        public const string CustomerIdField = "CustomerId";
        public int? EmployeeId { get; set; } // EmployeeID
        public const string EmployeeIdField = "EmployeeId";
        public DateTime? OrderDate { get; set; } // OrderDate
        public const string OrderDateField = "OrderDate";
        public DateTime? RequiredDate { get; set; } // RequiredDate
        public const string RequiredDateField = "RequiredDate";
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public const string ShippedDateField = "ShippedDate";
        public int? ShipVia { get; set; } // ShipVia
        public const string ShipViaField = "ShipVia";
        public decimal? Freight { get; set; } // Freight
        public const string FreightField = "Freight";
        public string ShipName { get; set; } // ShipName (length: 40)
        public const string ShipNameField = "ShipName";
        public string ShipAddress { get; set; } // ShipAddress (length: 60)
        public const string ShipAddressField = "ShipAddress";
        public string ShipCity { get; set; } // ShipCity (length: 15)
        public const string ShipCityField = "ShipCity";
        public string ShipRegion { get; set; } // ShipRegion (length: 15)
        public const string ShipRegionField = "ShipRegion";
        public string ShipPostalCode { get; set; } // ShipPostalCode (length: 10)
        public const string ShipPostalCodeField = "ShipPostalCode";
        public string ShipCountry { get; set; } // ShipCountry (length: 15)
        public const string ShipCountryField = "ShipCountry";

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [Order Details].[OrderID] point to this entity (FK_Order_Details_Orders)
        /// </summary>
        public ICollection<OrderDetail> OrderDetails { get; set; } // Order Details.FK_Order_Details_Orders

        // Foreign keys

        /// <summary>
        /// Parent Customer pointed by [Orders].([CustomerId]) (FK_Orders_Customers)
        /// </summary>
        public Customer Customer { get; set; } // FK_Orders_Customers

        /// <summary>
        /// Parent Employee pointed by [Orders].([EmployeeId]) (FK_Orders_Employees)
        /// </summary>
        public Employee Employee { get; set; } // FK_Orders_Employees

        /// <summary>
        /// Parent Shipper pointed by [Orders].([ShipVia]) (FK_Orders_Shippers)
        /// </summary>
        public Shipper Shipper { get; set; } // FK_Orders_Shippers

        public Order()
        {
            Freight = 0m;
            OrderDetails = new List<OrderDetail>();
        }
    }

    // Order Details
    public class OrderDetail
    {
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public int ProductId { get; set; } // ProductID (Primary key)
        public const string ProductIdField = "ProductId";
        public decimal UnitPrice { get; set; } // UnitPrice
        public const string UnitPriceField = "UnitPrice";
        public short Quantity { get; set; } // Quantity
        public const string QuantityField = "Quantity";
        public float Discount { get; set; } // Discount
        public const string DiscountField = "Discount";

        // Foreign keys

        /// <summary>
        /// Parent Order pointed by [Order Details].([OrderId]) (FK_Order_Details_Orders)
        /// </summary>
        public Order Order { get; set; } // FK_Order_Details_Orders

        /// <summary>
        /// Parent Product pointed by [Order Details].([ProductId]) (FK_Order_Details_Products)
        /// </summary>
        public Product Product { get; set; } // FK_Order_Details_Products

        public OrderDetail()
        {
            UnitPrice = 0m;
            Quantity = 1;
            Discount = 0f;
        }
    }

    // Order Details Extended
    public class OrderDetailsExtended
    {
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public int ProductId { get; set; } // ProductID (Primary key)
        public const string ProductIdField = "ProductId";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public decimal UnitPrice { get; set; } // UnitPrice (Primary key)
        public const string UnitPriceField = "UnitPrice";
        public short Quantity { get; set; } // Quantity (Primary key)
        public const string QuantityField = "Quantity";
        public float Discount { get; set; } // Discount (Primary key)
        public const string DiscountField = "Discount";
        public decimal? ExtendedPrice { get; set; } // ExtendedPrice
        public const string ExtendedPriceField = "ExtendedPrice";
    }

    // Orders Qry
    public class OrdersQry
    {
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public string CustomerId { get; set; } // CustomerID (length: 5)
        public const string CustomerIdField = "CustomerId";
        public int? EmployeeId { get; set; } // EmployeeID
        public const string EmployeeIdField = "EmployeeId";
        public DateTime? OrderDate { get; set; } // OrderDate
        public const string OrderDateField = "OrderDate";
        public DateTime? RequiredDate { get; set; } // RequiredDate
        public const string RequiredDateField = "RequiredDate";
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public const string ShippedDateField = "ShippedDate";
        public int? ShipVia { get; set; } // ShipVia
        public const string ShipViaField = "ShipVia";
        public decimal? Freight { get; set; } // Freight
        public const string FreightField = "Freight";
        public string ShipName { get; set; } // ShipName (length: 40)
        public const string ShipNameField = "ShipName";
        public string ShipAddress { get; set; } // ShipAddress (length: 60)
        public const string ShipAddressField = "ShipAddress";
        public string ShipCity { get; set; } // ShipCity (length: 15)
        public const string ShipCityField = "ShipCity";
        public string ShipRegion { get; set; } // ShipRegion (length: 15)
        public const string ShipRegionField = "ShipRegion";
        public string ShipPostalCode { get; set; } // ShipPostalCode (length: 10)
        public const string ShipPostalCodeField = "ShipPostalCode";
        public string ShipCountry { get; set; } // ShipCountry (length: 15)
        public const string ShipCountryField = "ShipCountry";
        public string CompanyName { get; set; } // CompanyName (Primary key) (length: 40)
        public const string CompanyNameField = "CompanyName";
        public string Address { get; set; } // Address (length: 60)
        public const string AddressField = "Address";
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string Region { get; set; } // Region (length: 15)
        public const string RegionField = "Region";
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public const string PostalCodeField = "PostalCode";
        public string Country { get; set; } // Country (length: 15)
        public const string CountryField = "Country";
    }

    // Order Subtotals
    public class OrderSubtotal
    {
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public decimal? Subtotal { get; set; } // Subtotal
        public const string SubtotalField = "Subtotal";
    }

    // Products
    public class Product
    {
        public int ProductId { get; set; } // ProductID (Primary key)
        public const string ProductIdField = "ProductId";
        public string ProductName { get; set; } // ProductName (length: 40)
        public const string ProductNameField = "ProductName";
        public int? SupplierId { get; set; } // SupplierID
        public const string SupplierIdField = "SupplierId";
        public int? CategoryId { get; set; } // CategoryID
        public const string CategoryIdField = "CategoryId";
        public string QuantityPerUnit { get; set; } // QuantityPerUnit (length: 20)
        public const string QuantityPerUnitField = "QuantityPerUnit";
        public decimal? UnitPrice { get; set; } // UnitPrice
        public const string UnitPriceField = "UnitPrice";
        public short? UnitsInStock { get; set; } // UnitsInStock
        public const string UnitsInStockField = "UnitsInStock";
        public short? UnitsOnOrder { get; set; } // UnitsOnOrder
        public const string UnitsOnOrderField = "UnitsOnOrder";
        public short? ReorderLevel { get; set; } // ReorderLevel
        public const string ReorderLevelField = "ReorderLevel";
        public bool Discontinued { get; set; } // Discontinued
        public const string DiscontinuedField = "Discontinued";

        // Reverse navigation

        /// <summary>
        /// Child OrderDetails where [Order Details].[ProductID] point to this entity (FK_Order_Details_Products)
        /// </summary>
        public ICollection<OrderDetail> OrderDetails { get; set; } // Order Details.FK_Order_Details_Products

        // Foreign keys

        /// <summary>
        /// Parent Category pointed by [Products].([CategoryId]) (FK_Products_Categories)
        /// </summary>
        public Category Category { get; set; } // FK_Products_Categories

        /// <summary>
        /// Parent Supplier pointed by [Products].([SupplierId]) (FK_Products_Suppliers)
        /// </summary>
        public Supplier Supplier { get; set; } // FK_Products_Suppliers

        public Product()
        {
            UnitPrice = 0m;
            UnitsInStock = 0;
            UnitsOnOrder = 0;
            ReorderLevel = 0;
            Discontinued = false;
            OrderDetails = new List<OrderDetail>();
        }
    }

    // Products Above Average Price
    public class ProductsAboveAveragePrice
    {
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public decimal? UnitPrice { get; set; } // UnitPrice
        public const string UnitPriceField = "UnitPrice";
    }

    // Product Sales for 1997
    public class ProductSalesFor1997
    {
        public string CategoryName { get; set; } // CategoryName (Primary key) (length: 15)
        public const string CategoryNameField = "CategoryName";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public decimal? ProductSales { get; set; } // ProductSales
        public const string ProductSalesField = "ProductSales";
    }

    // Products by Category
    public class ProductsByCategory
    {
        public string CategoryName { get; set; } // CategoryName (Primary key) (length: 15)
        public const string CategoryNameField = "CategoryName";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public string QuantityPerUnit { get; set; } // QuantityPerUnit (length: 20)
        public const string QuantityPerUnitField = "QuantityPerUnit";
        public short? UnitsInStock { get; set; } // UnitsInStock
        public const string UnitsInStockField = "UnitsInStock";
        public bool Discontinued { get; set; } // Discontinued (Primary key)
        public const string DiscontinuedField = "Discontinued";
    }

    // The table 'Quarterly Orders' is not usable by entity framework because it
    // does not have a primary key. It is listed here for completeness.
    // Quarterly Orders
    public class QuarterlyOrder
    {
        public string CustomerId { get; set; } // CustomerID (length: 5)
        public const string CustomerIdField = "CustomerId";
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public const string CompanyNameField = "CompanyName";
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string Country { get; set; } // Country (length: 15)
        public const string CountryField = "Country";
    }

    // Region
    public class Region
    {
        public int RegionId { get; set; } // RegionID (Primary key)
        public const string RegionIdField = "RegionId";
        public string RegionDescription { get; set; } // RegionDescription (length: 50)
        public const string RegionDescriptionField = "RegionDescription";

        // Reverse navigation

        /// <summary>
        /// Child Territories where [Territories].[RegionID] point to this entity (FK_Territories_Region)
        /// </summary>
        public ICollection<Territory> Territories { get; set; } // Territories.FK_Territories_Region

        public Region()
        {
            Territories = new List<Territory>();
        }
    }

    // Sales by Category
    public class SalesByCategory
    {
        public int CategoryId { get; set; } // CategoryID (Primary key)
        public const string CategoryIdField = "CategoryId";
        public string CategoryName { get; set; } // CategoryName (Primary key) (length: 15)
        public const string CategoryNameField = "CategoryName";
        public string ProductName { get; set; } // ProductName (Primary key) (length: 40)
        public const string ProductNameField = "ProductName";
        public decimal? ProductSales { get; set; } // ProductSales
        public const string ProductSalesField = "ProductSales";
    }

    // Sales Totals by Amount
    public class SalesTotalsByAmount
    {
        public decimal? SaleAmount { get; set; } // SaleAmount
        public const string SaleAmountField = "SaleAmount";
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public string CompanyName { get; set; } // CompanyName (Primary key) (length: 40)
        public const string CompanyNameField = "CompanyName";
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public const string ShippedDateField = "ShippedDate";
    }

    // Shippers
    public class Shipper
    {
        public int ShipperId { get; set; } // ShipperID (Primary key)
        public const string ShipperIdField = "ShipperId";
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public const string CompanyNameField = "CompanyName";
        public string Phone { get; set; } // Phone (length: 24)
        public const string PhoneField = "Phone";

        // Reverse navigation

        /// <summary>
        /// Child Orders where [Orders].[ShipVia] point to this entity (FK_Orders_Shippers)
        /// </summary>
        public ICollection<Order> Orders { get; set; } // Orders.FK_Orders_Shippers

        public Shipper()
        {
            Orders = new List<Order>();
        }
    }

    // Summary of Sales by Quarter
    public class SummaryOfSalesByQuarter
    {
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public const string ShippedDateField = "ShippedDate";
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public decimal? Subtotal { get; set; } // Subtotal
        public const string SubtotalField = "Subtotal";
    }

    // Summary of Sales by Year
    public class SummaryOfSalesByYear
    {
        public DateTime? ShippedDate { get; set; } // ShippedDate
        public const string ShippedDateField = "ShippedDate";
        public int OrderId { get; set; } // OrderID (Primary key)
        public const string OrderIdField = "OrderId";
        public decimal? Subtotal { get; set; } // Subtotal
        public const string SubtotalField = "Subtotal";
    }

    // Suppliers
    public class Supplier
    {
        public int SupplierId { get; set; } // SupplierID (Primary key)
        public const string SupplierIdField = "SupplierId";
        public string CompanyName { get; set; } // CompanyName (length: 40)
        public const string CompanyNameField = "CompanyName";
        public string ContactName { get; set; } // ContactName (length: 30)
        public const string ContactNameField = "ContactName";
        public string ContactTitle { get; set; } // ContactTitle (length: 30)
        public const string ContactTitleField = "ContactTitle";
        public string Address { get; set; } // Address (length: 60)
        public const string AddressField = "Address";
        public string City { get; set; } // City (length: 15)
        public const string CityField = "City";
        public string Region { get; set; } // Region (length: 15)
        public const string RegionField = "Region";
        public string PostalCode { get; set; } // PostalCode (length: 10)
        public const string PostalCodeField = "PostalCode";
        public string Country { get; set; } // Country (length: 15)
        public const string CountryField = "Country";
        public string Phone { get; set; } // Phone (length: 24)
        public const string PhoneField = "Phone";
        public string Fax { get; set; } // Fax (length: 24)
        public const string FaxField = "Fax";
        public string HomePage { get; set; } // HomePage (length: 1073741823)
        public const string HomePageField = "HomePage";

        // Reverse navigation

        /// <summary>
        /// Child Products where [Products].[SupplierID] point to this entity (FK_Products_Suppliers)
        /// </summary>
        public ICollection<Product> Products { get; set; } // Products.FK_Products_Suppliers

        public Supplier()
        {
            Products = new List<Product>();
        }
    }

    // Territories
    public class Territory
    {
        public string TerritoryId { get; set; } // TerritoryID (Primary key) (length: 20)
        public const string TerritoryIdField = "TerritoryId";
        public string TerritoryDescription { get; set; } // TerritoryDescription (length: 50)
        public const string TerritoryDescriptionField = "TerritoryDescription";
        public int RegionId { get; set; } // RegionID
        public const string RegionIdField = "RegionId";

        // Reverse navigation

        /// <summary>
        /// Child Employees (Many-to-Many) mapped by table [EmployeeTerritories]
        /// </summary>
        public ICollection<Employee> Employees { get; set; } // Many to many mapping

        // Foreign keys

        /// <summary>
        /// Parent Region pointed by [Territories].([RegionId]) (FK_Territories_Region)
        /// </summary>
        public Region Region { get; set; } // FK_Territories_Region

        public Territory()
        {
            Employees = new List<Employee>();
        }
    }


    #endregion

    #region POCO Configuration

    // Alphabetical list of products
    public class AlphabeticalListOfProductConfiguration : EntityTypeConfiguration<AlphabeticalListOfProduct>
    {
        public AlphabeticalListOfProductConfiguration()
            : this("dbo")
        {
        }

        public AlphabeticalListOfProductConfiguration(string schema)
        {
            ToTable("Alphabetical list of products", schema);
            HasKey(x => new { x.ProductId, x.ProductName, x.Discontinued, x.CategoryName });

            Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.SupplierId).HasColumnName(@"SupplierID").HasColumnType("int").IsOptional();
            Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("int").IsOptional();
            Property(x => x.QuantityPerUnit).HasColumnName(@"QuantityPerUnit").HasColumnType("nvarchar").IsOptional().HasMaxLength(20);
            Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("money").IsOptional();
            Property(x => x.UnitsInStock).HasColumnName(@"UnitsInStock").HasColumnType("smallint").IsOptional();
            Property(x => x.UnitsOnOrder).HasColumnName(@"UnitsOnOrder").HasColumnType("smallint").IsOptional();
            Property(x => x.ReorderLevel).HasColumnName(@"ReorderLevel").HasColumnType("smallint").IsOptional();
            Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("bit").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("nvarchar").IsRequired().HasMaxLength(15).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
        }
    }

    // Categories
    public class CategoryConfiguration : EntityTypeConfiguration<Category>
    {
        public CategoryConfiguration()
            : this("dbo")
        {
        }

        public CategoryConfiguration(string schema)
        {
            ToTable("Categories", schema);
            HasKey(x => x.CategoryId);

            Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("nvarchar").IsRequired().HasMaxLength(15);
            Property(x => x.Description).HasColumnName(@"Description").HasColumnType("ntext").IsOptional().IsMaxLength();
            Property(x => x.Picture).HasColumnName(@"Picture").HasColumnType("image").IsOptional().HasMaxLength(2147483647);
        }
    }

    // Category Sales for 1997
    public class CategorySalesFor1997Configuration : EntityTypeConfiguration<CategorySalesFor1997>
    {
        public CategorySalesFor1997Configuration()
            : this("dbo")
        {
        }

        public CategorySalesFor1997Configuration(string schema)
        {
            ToTable("Category Sales for 1997", schema);
            HasKey(x => x.CategoryName);

            Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("nvarchar").IsRequired().HasMaxLength(15).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CategorySales).HasColumnName(@"CategorySales").HasColumnType("money").IsOptional();
        }
    }

    // Current Product List
    public class CurrentProductListConfiguration : EntityTypeConfiguration<CurrentProductList>
    {
        public CurrentProductListConfiguration()
            : this("dbo")
        {
        }

        public CurrentProductListConfiguration(string schema)
        {
            ToTable("Current Product List", schema);
            HasKey(x => new { x.ProductId, x.ProductName });

            Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
        }
    }

    // Customers
    public class CustomerConfiguration : EntityTypeConfiguration<Customer>
    {
        public CustomerConfiguration()
            : this("dbo")
        {
        }

        public CustomerConfiguration(string schema)
        {
            ToTable("Customers", schema);
            HasKey(x => x.CustomerId);

            Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("nchar").IsRequired().IsFixedLength().HasMaxLength(5).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.ContactName).HasColumnName(@"ContactName").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.ContactTitle).HasColumnName(@"ContactTitle").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.Fax).HasColumnName(@"Fax").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            HasMany(t => t.CustomerDemographics).WithMany(t => t.Customers).Map(m =>
            {
                m.ToTable("CustomerCustomerDemo", "dbo");
                m.MapLeftKey("CustomerID");
                m.MapRightKey("CustomerTypeID");
            });
        }
    }

    // Customer and Suppliers by City
    public class CustomerAndSuppliersByCityConfiguration : EntityTypeConfiguration<CustomerAndSuppliersByCity>
    {
        public CustomerAndSuppliersByCityConfiguration()
            : this("dbo")
        {
        }

        public CustomerAndSuppliersByCityConfiguration(string schema)
        {
            ToTable("Customer and Suppliers by City", schema);
            HasKey(x => new { x.CompanyName, x.Relationship });

            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ContactName).HasColumnName(@"ContactName").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.Relationship).HasColumnName(@"Relationship").HasColumnType("varchar").IsRequired().IsUnicode(false).HasMaxLength(9).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
        }
    }

    // CustomerDemographics
    public class CustomerDemographicConfiguration : EntityTypeConfiguration<CustomerDemographic>
    {
        public CustomerDemographicConfiguration()
            : this("dbo")
        {
        }

        public CustomerDemographicConfiguration(string schema)
        {
            ToTable("CustomerDemographics", schema);
            HasKey(x => x.CustomerTypeId);

            Property(x => x.CustomerTypeId).HasColumnName(@"CustomerTypeID").HasColumnType("nchar").IsRequired().IsFixedLength().HasMaxLength(10).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CustomerDesc).HasColumnName(@"CustomerDesc").HasColumnType("ntext").IsOptional().IsMaxLength();
        }
    }

    // Employees
    public class EmployeeConfiguration : EntityTypeConfiguration<Employee>
    {
        public EmployeeConfiguration()
            : this("dbo")
        {
        }

        public EmployeeConfiguration(string schema)
        {
            ToTable("Employees", schema);
            HasKey(x => x.EmployeeId);

            Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.LastName).HasColumnName(@"LastName").HasColumnType("nvarchar").IsRequired().HasMaxLength(20);
            Property(x => x.FirstName).HasColumnName(@"FirstName").HasColumnType("nvarchar").IsRequired().HasMaxLength(10);
            Property(x => x.Title).HasColumnName(@"Title").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.TitleOfCourtesy).HasColumnName(@"TitleOfCourtesy").HasColumnType("nvarchar").IsOptional().HasMaxLength(25);
            Property(x => x.BirthDate).HasColumnName(@"BirthDate").HasColumnType("datetime").IsOptional();
            Property(x => x.HireDate).HasColumnName(@"HireDate").HasColumnType("datetime").IsOptional();
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.HomePhone).HasColumnName(@"HomePhone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.Extension).HasColumnName(@"Extension").HasColumnType("nvarchar").IsOptional().HasMaxLength(4);
            Property(x => x.Photo).HasColumnName(@"Photo").HasColumnType("image").IsOptional().HasMaxLength(2147483647);
            Property(x => x.Notes).HasColumnName(@"Notes").HasColumnType("ntext").IsOptional().IsMaxLength();
            Property(x => x.ReportsTo).HasColumnName(@"ReportsTo").HasColumnType("int").IsOptional();
            Property(x => x.PhotoPath).HasColumnName(@"PhotoPath").HasColumnType("nvarchar").IsOptional().HasMaxLength(255);

            // Foreign keys
            HasOptional(a => a.Employee_ReportsTo).WithMany(b => b.Employees).HasForeignKey(c => c.ReportsTo).WillCascadeOnDelete(false); // FK_Employees_Employees
            HasMany(t => t.Territories).WithMany(t => t.Employees).Map(m =>
            {
                m.ToTable("EmployeeTerritories", "dbo");
                m.MapLeftKey("EmployeeID");
                m.MapRightKey("TerritoryID");
            });
        }
    }

    // Invoices
    public class InvoiceConfiguration : EntityTypeConfiguration<Invoice>
    {
        public InvoiceConfiguration()
            : this("dbo")
        {
        }

        public InvoiceConfiguration(string schema)
        {
            ToTable("Invoices", schema);
            HasKey(x => new { x.CustomerName, x.Salesperson, x.OrderId, x.ShipperName, x.ProductId, x.ProductName, x.UnitPrice, x.Quantity, x.Discount });

            Property(x => x.ShipName).HasColumnName(@"ShipName").HasColumnType("nvarchar").IsOptional().HasMaxLength(40);
            Property(x => x.ShipAddress).HasColumnName(@"ShipAddress").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.ShipCity).HasColumnName(@"ShipCity").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipRegion).HasColumnName(@"ShipRegion").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipPostalCode).HasColumnName(@"ShipPostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.ShipCountry).HasColumnName(@"ShipCountry").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("nchar").IsOptional().IsFixedLength().HasMaxLength(5);
            Property(x => x.CustomerName).HasColumnName(@"CustomerName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Salesperson).HasColumnName(@"Salesperson").HasColumnType("nvarchar").IsRequired().HasMaxLength(31).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.OrderDate).HasColumnName(@"OrderDate").HasColumnType("datetime").IsOptional();
            Property(x => x.RequiredDate).HasColumnName(@"RequiredDate").HasColumnType("datetime").IsOptional();
            Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("datetime").IsOptional();
            Property(x => x.ShipperName).HasColumnName(@"ShipperName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("money").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ExtendedPrice).HasColumnName(@"ExtendedPrice").HasColumnType("money").IsOptional();
            Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("money").IsOptional();
        }
    }

    // Orders
    public class OrderConfiguration : EntityTypeConfiguration<Order>
    {
        public OrderConfiguration()
            : this("dbo")
        {
        }

        public OrderConfiguration(string schema)
        {
            ToTable("Orders", schema);
            HasKey(x => x.OrderId);

            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("nchar").IsOptional().IsFixedLength().HasMaxLength(5);
            Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("int").IsOptional();
            Property(x => x.OrderDate).HasColumnName(@"OrderDate").HasColumnType("datetime").IsOptional();
            Property(x => x.RequiredDate).HasColumnName(@"RequiredDate").HasColumnType("datetime").IsOptional();
            Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("datetime").IsOptional();
            Property(x => x.ShipVia).HasColumnName(@"ShipVia").HasColumnType("int").IsOptional();
            Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("money").IsOptional();
            Property(x => x.ShipName).HasColumnName(@"ShipName").HasColumnType("nvarchar").IsOptional().HasMaxLength(40);
            Property(x => x.ShipAddress).HasColumnName(@"ShipAddress").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.ShipCity).HasColumnName(@"ShipCity").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipRegion).HasColumnName(@"ShipRegion").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipPostalCode).HasColumnName(@"ShipPostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.ShipCountry).HasColumnName(@"ShipCountry").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);

            // Foreign keys
            HasOptional(a => a.Customer).WithMany(b => b.Orders).HasForeignKey(c => c.CustomerId).WillCascadeOnDelete(false); // FK_Orders_Customers
            HasOptional(a => a.Employee).WithMany(b => b.Orders).HasForeignKey(c => c.EmployeeId).WillCascadeOnDelete(false); // FK_Orders_Employees
            HasOptional(a => a.Shipper).WithMany(b => b.Orders).HasForeignKey(c => c.ShipVia).WillCascadeOnDelete(false); // FK_Orders_Shippers
        }
    }

    // Order Details
    public class OrderDetailConfiguration : EntityTypeConfiguration<OrderDetail>
    {
        public OrderDetailConfiguration()
            : this("dbo")
        {
        }

        public OrderDetailConfiguration(string schema)
        {
            ToTable("Order Details", schema);
            HasKey(x => new { x.OrderId, x.ProductId });

            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("money").IsRequired();
            Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired();
            Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired();

            // Foreign keys
            HasRequired(a => a.Order).WithMany(b => b.OrderDetails).HasForeignKey(c => c.OrderId).WillCascadeOnDelete(false); // FK_Order_Details_Orders
            HasRequired(a => a.Product).WithMany(b => b.OrderDetails).HasForeignKey(c => c.ProductId).WillCascadeOnDelete(false); // FK_Order_Details_Products
        }
    }

    // Order Details Extended
    public class OrderDetailsExtendedConfiguration : EntityTypeConfiguration<OrderDetailsExtended>
    {
        public OrderDetailsExtendedConfiguration()
            : this("dbo")
        {
        }

        public OrderDetailsExtendedConfiguration(string schema)
        {
            ToTable("Order Details Extended", schema);
            HasKey(x => new { x.OrderId, x.ProductId, x.ProductName, x.UnitPrice, x.Quantity, x.Discount });

            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("money").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Quantity).HasColumnName(@"Quantity").HasColumnType("smallint").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("real").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ExtendedPrice).HasColumnName(@"ExtendedPrice").HasColumnType("money").IsOptional();
        }
    }

    // Orders Qry
    public class OrdersQryConfiguration : EntityTypeConfiguration<OrdersQry>
    {
        public OrdersQryConfiguration()
            : this("dbo")
        {
        }

        public OrdersQryConfiguration(string schema)
        {
            ToTable("Orders Qry", schema);
            HasKey(x => new { x.OrderId, x.CompanyName });

            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CustomerId).HasColumnName(@"CustomerID").HasColumnType("nchar").IsOptional().IsFixedLength().HasMaxLength(5);
            Property(x => x.EmployeeId).HasColumnName(@"EmployeeID").HasColumnType("int").IsOptional();
            Property(x => x.OrderDate).HasColumnName(@"OrderDate").HasColumnType("datetime").IsOptional();
            Property(x => x.RequiredDate).HasColumnName(@"RequiredDate").HasColumnType("datetime").IsOptional();
            Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("datetime").IsOptional();
            Property(x => x.ShipVia).HasColumnName(@"ShipVia").HasColumnType("int").IsOptional();
            Property(x => x.Freight).HasColumnName(@"Freight").HasColumnType("money").IsOptional();
            Property(x => x.ShipName).HasColumnName(@"ShipName").HasColumnType("nvarchar").IsOptional().HasMaxLength(40);
            Property(x => x.ShipAddress).HasColumnName(@"ShipAddress").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.ShipCity).HasColumnName(@"ShipCity").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipRegion).HasColumnName(@"ShipRegion").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.ShipPostalCode).HasColumnName(@"ShipPostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.ShipCountry).HasColumnName(@"ShipCountry").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
        }
    }

    // Order Subtotals
    public class OrderSubtotalConfiguration : EntityTypeConfiguration<OrderSubtotal>
    {
        public OrderSubtotalConfiguration()
            : this("dbo")
        {
        }

        public OrderSubtotalConfiguration(string schema)
        {
            ToTable("Order Subtotals", schema);
            HasKey(x => x.OrderId);

            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Subtotal).HasColumnName(@"Subtotal").HasColumnType("money").IsOptional();
        }
    }

    // Products
    public class ProductConfiguration : EntityTypeConfiguration<Product>
    {
        public ProductConfiguration()
            : this("dbo")
        {
        }

        public ProductConfiguration(string schema)
        {
            ToTable("Products", schema);
            HasKey(x => x.ProductId);

            Property(x => x.ProductId).HasColumnName(@"ProductID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.SupplierId).HasColumnName(@"SupplierID").HasColumnType("int").IsOptional();
            Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("int").IsOptional();
            Property(x => x.QuantityPerUnit).HasColumnName(@"QuantityPerUnit").HasColumnType("nvarchar").IsOptional().HasMaxLength(20);
            Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("money").IsOptional();
            Property(x => x.UnitsInStock).HasColumnName(@"UnitsInStock").HasColumnType("smallint").IsOptional();
            Property(x => x.UnitsOnOrder).HasColumnName(@"UnitsOnOrder").HasColumnType("smallint").IsOptional();
            Property(x => x.ReorderLevel).HasColumnName(@"ReorderLevel").HasColumnType("smallint").IsOptional();
            Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("bit").IsRequired();

            // Foreign keys
            HasOptional(a => a.Category).WithMany(b => b.Products).HasForeignKey(c => c.CategoryId).WillCascadeOnDelete(false); // FK_Products_Categories
            HasOptional(a => a.Supplier).WithMany(b => b.Products).HasForeignKey(c => c.SupplierId).WillCascadeOnDelete(false); // FK_Products_Suppliers
        }
    }

    // Products Above Average Price
    public class ProductsAboveAveragePriceConfiguration : EntityTypeConfiguration<ProductsAboveAveragePrice>
    {
        public ProductsAboveAveragePriceConfiguration()
            : this("dbo")
        {
        }

        public ProductsAboveAveragePriceConfiguration(string schema)
        {
            ToTable("Products Above Average Price", schema);
            HasKey(x => x.ProductName);

            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("money").IsOptional();
        }
    }

    // Product Sales for 1997
    public class ProductSalesFor1997Configuration : EntityTypeConfiguration<ProductSalesFor1997>
    {
        public ProductSalesFor1997Configuration()
            : this("dbo")
        {
        }

        public ProductSalesFor1997Configuration(string schema)
        {
            ToTable("Product Sales for 1997", schema);
            HasKey(x => new { x.CategoryName, x.ProductName });

            Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("nvarchar").IsRequired().HasMaxLength(15).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductSales).HasColumnName(@"ProductSales").HasColumnType("money").IsOptional();
        }
    }

    // Products by Category
    public class ProductsByCategoryConfiguration : EntityTypeConfiguration<ProductsByCategory>
    {
        public ProductsByCategoryConfiguration()
            : this("dbo")
        {
        }

        public ProductsByCategoryConfiguration(string schema)
        {
            ToTable("Products by Category", schema);
            HasKey(x => new { x.CategoryName, x.ProductName, x.Discontinued });

            Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("nvarchar").IsRequired().HasMaxLength(15).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.QuantityPerUnit).HasColumnName(@"QuantityPerUnit").HasColumnType("nvarchar").IsOptional().HasMaxLength(20);
            Property(x => x.UnitsInStock).HasColumnName(@"UnitsInStock").HasColumnType("smallint").IsOptional();
            Property(x => x.Discontinued).HasColumnName(@"Discontinued").HasColumnType("bit").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
        }
    }

    // Region
    public class RegionConfiguration : EntityTypeConfiguration<Region>
    {
        public RegionConfiguration()
            : this("dbo")
        {
        }

        public RegionConfiguration(string schema)
        {
            ToTable("Region", schema);
            HasKey(x => x.RegionId);

            Property(x => x.RegionId).HasColumnName(@"RegionID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.RegionDescription).HasColumnName(@"RegionDescription").HasColumnType("nchar").IsRequired().IsFixedLength().HasMaxLength(50);
        }
    }

    // Sales by Category
    public class SalesByCategoryConfiguration : EntityTypeConfiguration<SalesByCategory>
    {
        public SalesByCategoryConfiguration()
            : this("dbo")
        {
        }

        public SalesByCategoryConfiguration(string schema)
        {
            ToTable("Sales by Category", schema);
            HasKey(x => new { x.CategoryId, x.CategoryName, x.ProductName });

            Property(x => x.CategoryId).HasColumnName(@"CategoryID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CategoryName).HasColumnName(@"CategoryName").HasColumnType("nvarchar").IsRequired().HasMaxLength(15).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductName).HasColumnName(@"ProductName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ProductSales).HasColumnName(@"ProductSales").HasColumnType("money").IsOptional();
        }
    }

    // Sales Totals by Amount
    public class SalesTotalsByAmountConfiguration : EntityTypeConfiguration<SalesTotalsByAmount>
    {
        public SalesTotalsByAmountConfiguration()
            : this("dbo")
        {
        }

        public SalesTotalsByAmountConfiguration(string schema)
        {
            ToTable("Sales Totals by Amount", schema);
            HasKey(x => new { x.OrderId, x.CompanyName });

            Property(x => x.SaleAmount).HasColumnName(@"SaleAmount").HasColumnType("money").IsOptional();
            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("datetime").IsOptional();
        }
    }

    // Shippers
    public class ShipperConfiguration : EntityTypeConfiguration<Shipper>
    {
        public ShipperConfiguration()
            : this("dbo")
        {
        }

        public ShipperConfiguration(string schema)
        {
            ToTable("Shippers", schema);
            HasKey(x => x.ShipperId);

            Property(x => x.ShipperId).HasColumnName(@"ShipperID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
        }
    }

    // Summary of Sales by Quarter
    public class SummaryOfSalesByQuarterConfiguration : EntityTypeConfiguration<SummaryOfSalesByQuarter>
    {
        public SummaryOfSalesByQuarterConfiguration()
            : this("dbo")
        {
        }

        public SummaryOfSalesByQuarterConfiguration(string schema)
        {
            ToTable("Summary of Sales by Quarter", schema);
            HasKey(x => x.OrderId);

            Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("datetime").IsOptional();
            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Subtotal).HasColumnName(@"Subtotal").HasColumnType("money").IsOptional();
        }
    }

    // Summary of Sales by Year
    public class SummaryOfSalesByYearConfiguration : EntityTypeConfiguration<SummaryOfSalesByYear>
    {
        public SummaryOfSalesByYearConfiguration()
            : this("dbo")
        {
        }

        public SummaryOfSalesByYearConfiguration(string schema)
        {
            ToTable("Summary of Sales by Year", schema);
            HasKey(x => x.OrderId);

            Property(x => x.ShippedDate).HasColumnName(@"ShippedDate").HasColumnType("datetime").IsOptional();
            Property(x => x.OrderId).HasColumnName(@"OrderID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.Subtotal).HasColumnName(@"Subtotal").HasColumnType("money").IsOptional();
        }
    }

    // Suppliers
    public class SupplierConfiguration : EntityTypeConfiguration<Supplier>
    {
        public SupplierConfiguration()
            : this("dbo")
        {
        }

        public SupplierConfiguration(string schema)
        {
            ToTable("Suppliers", schema);
            HasKey(x => x.SupplierId);

            Property(x => x.SupplierId).HasColumnName(@"SupplierID").HasColumnType("int").IsRequired().HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            Property(x => x.CompanyName).HasColumnName(@"CompanyName").HasColumnType("nvarchar").IsRequired().HasMaxLength(40);
            Property(x => x.ContactName).HasColumnName(@"ContactName").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.ContactTitle).HasColumnName(@"ContactTitle").HasColumnType("nvarchar").IsOptional().HasMaxLength(30);
            Property(x => x.Address).HasColumnName(@"Address").HasColumnType("nvarchar").IsOptional().HasMaxLength(60);
            Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar").IsOptional().HasMaxLength(10);
            Property(x => x.Country).HasColumnName(@"Country").HasColumnType("nvarchar").IsOptional().HasMaxLength(15);
            Property(x => x.Phone).HasColumnName(@"Phone").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.Fax).HasColumnName(@"Fax").HasColumnType("nvarchar").IsOptional().HasMaxLength(24);
            Property(x => x.HomePage).HasColumnName(@"HomePage").HasColumnType("ntext").IsOptional().IsMaxLength();
        }
    }

    // Territories
    public class TerritoryConfiguration : EntityTypeConfiguration<Territory>
    {
        public TerritoryConfiguration()
            : this("dbo")
        {
        }

        public TerritoryConfiguration(string schema)
        {
            ToTable("Territories", schema);
            HasKey(x => x.TerritoryId);

            Property(x => x.TerritoryId).HasColumnName(@"TerritoryID").HasColumnType("nvarchar").IsRequired().HasMaxLength(20).HasDatabaseGeneratedOption(DatabaseGeneratedOption.None);
            Property(x => x.TerritoryDescription).HasColumnName(@"TerritoryDescription").HasColumnType("nchar").IsRequired().IsFixedLength().HasMaxLength(50);
            Property(x => x.RegionId).HasColumnName(@"RegionID").HasColumnType("int").IsRequired();

            // Foreign keys
            HasRequired(a => a.Region).WithMany(b => b.Territories).HasForeignKey(c => c.RegionId).WillCascadeOnDelete(false); // FK_Territories_Region
        }
    }


    #endregion

    #region Stored procedure return models

    public class CustOrderHistReturnModel
    {
        public string ProductName { get; set; }
        public int? Total { get; set; }
    }

    public class CustOrdersDetailReturnModel
    {
        public string ProductName { get; set; }
        public decimal? UnitPrice { get; set; }
        public short Quantity { get; set; }
        public int? Discount { get; set; }
        public decimal? ExtendedPrice { get; set; }
    }

    public class CustOrdersOrdersReturnModel
    {
        public int OrderID { get; set; }
        public DateTime? OrderDate { get; set; }
        public DateTime? RequiredDate { get; set; }
        public DateTime? ShippedDate { get; set; }
    }

    public class EmployeeSalesByCountryReturnModel
    {
        public string Country { get; set; }
        public string LastName { get; set; }
        public string FirstName { get; set; }
        public DateTime? ShippedDate { get; set; }
        public int OrderID { get; set; }
        public decimal? SaleAmount { get; set; }
    }

    public class SalesByCategoryReturnModel
    {
        public string ProductName { get; set; }
        public decimal? TotalPurchase { get; set; }
    }

    public class SalesByYearReturnModel
    {
        public DateTime? ShippedDate { get; set; }
        public int OrderID { get; set; }
        public decimal? Subtotal { get; set; }
        public string Year { get; set; }
    }

    public class TenMostExpensiveProductsReturnModel
    {
        public string TenMostExpensiveProducts { get; set; }
        public decimal? UnitPrice { get; set; }
    }


    #endregion

}
// </auto-generated>
