﻿// <auto-generated>
// ReSharper disable All

using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlTypes;
using System.Linq;
using System.Linq.Expressions;
using System.Threading;
using System.Threading.Tasks;

namespace RP
{
    #region Database context interface

    public interface IAzureContext : IDisposable
    {
        DbSet<BadEmail> BadEmails { get; set; } // BadEmail
        DbSet<CartItem> CartItems { get; set; } // CartItem
        DbSet<Checkout> Checkouts { get; set; } // Checkout
        DbSet<Country> Countries { get; set; } // Country
        DbSet<Discount> Discounts { get; set; } // Discount
        DbSet<DiscountLimitation> DiscountLimitations { get; set; } // DiscountLimitation
        DbSet<LicenceType> LicenceTypes { get; set; } // LicenceType
        DbSet<NotificationOptOut> NotificationOptOuts { get; set; } // NotificationOptOut
        DbSet<NotificationType> NotificationTypes { get; set; } // NotificationType
        DbSet<Order> Orders { get; set; } // Order
        DbSet<OrderItem> OrderItems { get; set; } // OrderItem
        DbSet<OrderLog> OrderLogs { get; set; } // OrderLog
        DbSet<OrderNotificationSent> OrderNotificationSents { get; set; } // OrderNotificationSent
        DbSet<Product> Products { get; set; } // Product
        DbSet<ProductLicenceTypeMapping> ProductLicenceTypeMappings { get; set; } // ProductLicenceTypeMapping
        DbSet<SalesByWeek> SalesByWeeks { get; set; } // SalesByWeek
        DbSet<SignatureUsed> SignatureUseds { get; set; } // SignatureUsed
        DbSet<sys_DatabaseFirewallRule> sys_DatabaseFirewallRules { get; set; } // database_firewall_rules
        DbSet<VolumeDiscount> VolumeDiscounts { get; set; } // VolumeDiscount

        int SaveChanges();
        int SaveChanges(bool acceptAllChangesOnSuccess);
        Task<int> SaveChangesAsync(CancellationToken cancellationToken = default(CancellationToken));
        Task<int> SaveChangesAsync(bool acceptAllChangesOnSuccess, CancellationToken cancellationToken = default(CancellationToken));
        DatabaseFacade Database { get; }
        DbSet<TEntity> Set<TEntity>() where TEntity : class;
        string ToString();

        EntityEntry Add(object entity);
        EntityEntry<TEntity> Add<TEntity>(TEntity entity) where TEntity : class;
        Task AddRangeAsync(params object[] entities);
        Task AddRangeAsync(IEnumerable<object> entities, CancellationToken cancellationToken = default);
        ValueTask<EntityEntry<TEntity>> AddAsync<TEntity>(TEntity entity, CancellationToken cancellationToken = default) where TEntity : class;
        ValueTask<EntityEntry> AddAsync(object entity, CancellationToken cancellationToken = default);
        void AddRange(IEnumerable<object> entities);
        void AddRange(params object[] entities);

        EntityEntry Attach(object entity);
        EntityEntry<TEntity> Attach<TEntity>(TEntity entity) where TEntity : class;
        void AttachRange(IEnumerable<object> entities);
        void AttachRange(params object[] entities);

        EntityEntry Entry(object entity);
        EntityEntry<TEntity> Entry<TEntity>(TEntity entity) where TEntity : class;

        TEntity Find<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(object[] keyValues, CancellationToken cancellationToken) where TEntity : class;
        ValueTask<TEntity> FindAsync<TEntity>(params object[] keyValues) where TEntity : class;
        ValueTask<object> FindAsync(Type entityType, object[] keyValues, CancellationToken cancellationToken);
        ValueTask<object> FindAsync(Type entityType, params object[] keyValues);
        object Find(Type entityType, params object[] keyValues);

        EntityEntry Remove(object entity);
        EntityEntry<TEntity> Remove<TEntity>(TEntity entity) where TEntity : class;
        void RemoveRange(IEnumerable<object> entities);
        void RemoveRange(params object[] entities);

        EntityEntry Update(object entity);
        EntityEntry<TEntity> Update<TEntity>(TEntity entity) where TEntity : class;
        void UpdateRange(IEnumerable<object> entities);
        void UpdateRange(params object[] entities);

        IQueryable<TResult> FromExpression<TResult> (Expression<Func<IQueryable<TResult>>> expression);
    }

    #endregion

    #region Database context

    public class AzureContext : DbContext, IAzureContext
    {
        public AzureContext()
        {
        }

        public AzureContext(DbContextOptions<AzureContext> options)
            : base(options)
        {
        }

        public DbSet<BadEmail> BadEmails { get; set; } // BadEmail
        public DbSet<CartItem> CartItems { get; set; } // CartItem
        public DbSet<Checkout> Checkouts { get; set; } // Checkout
        public DbSet<Country> Countries { get; set; } // Country
        public DbSet<Discount> Discounts { get; set; } // Discount
        public DbSet<DiscountLimitation> DiscountLimitations { get; set; } // DiscountLimitation
        public DbSet<LicenceType> LicenceTypes { get; set; } // LicenceType
        public DbSet<NotificationOptOut> NotificationOptOuts { get; set; } // NotificationOptOut
        public DbSet<NotificationType> NotificationTypes { get; set; } // NotificationType
        public DbSet<Order> Orders { get; set; } // Order
        public DbSet<OrderItem> OrderItems { get; set; } // OrderItem
        public DbSet<OrderLog> OrderLogs { get; set; } // OrderLog
        public DbSet<OrderNotificationSent> OrderNotificationSents { get; set; } // OrderNotificationSent
        public DbSet<Product> Products { get; set; } // Product
        public DbSet<ProductLicenceTypeMapping> ProductLicenceTypeMappings { get; set; } // ProductLicenceTypeMapping
        public DbSet<SalesByWeek> SalesByWeeks { get; set; } // SalesByWeek
        public DbSet<SignatureUsed> SignatureUseds { get; set; } // SignatureUsed
        public DbSet<sys_DatabaseFirewallRule> sys_DatabaseFirewallRules { get; set; } // database_firewall_rules
        public DbSet<VolumeDiscount> VolumeDiscounts { get; set; } // VolumeDiscount

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseSqlServer(@"Server=tcp:reversepoco.database.windows.net,1433;Initial Catalog=ReversePoco;Persist Security Info=False;User ID=sjh37;Password=K92b4tRwxfJp92f;MultipleActiveResultSets=False;Encrypt=True;TrustServerCertificate=False");
            }
        }

        public bool IsSqlParameterNull(SqlParameter param)
        {
            var sqlValue = param.SqlValue;
            var nullableValue = sqlValue as INullable;
            if (nullableValue != null)
                return nullableValue.IsNull;
            return (sqlValue == null || sqlValue == DBNull.Value);
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            base.OnModelCreating(modelBuilder);

            modelBuilder.ApplyConfiguration(new BadEmailConfiguration());
            modelBuilder.ApplyConfiguration(new CartItemConfiguration());
            modelBuilder.ApplyConfiguration(new CheckoutConfiguration());
            modelBuilder.ApplyConfiguration(new CountryConfiguration());
            modelBuilder.ApplyConfiguration(new DiscountConfiguration());
            modelBuilder.ApplyConfiguration(new DiscountLimitationConfiguration());
            modelBuilder.ApplyConfiguration(new LicenceTypeConfiguration());
            modelBuilder.ApplyConfiguration(new NotificationOptOutConfiguration());
            modelBuilder.ApplyConfiguration(new NotificationTypeConfiguration());
            modelBuilder.ApplyConfiguration(new OrderConfiguration());
            modelBuilder.ApplyConfiguration(new OrderItemConfiguration());
            modelBuilder.ApplyConfiguration(new OrderLogConfiguration());
            modelBuilder.ApplyConfiguration(new OrderNotificationSentConfiguration());
            modelBuilder.ApplyConfiguration(new ProductConfiguration());
            modelBuilder.ApplyConfiguration(new ProductLicenceTypeMappingConfiguration());
            modelBuilder.ApplyConfiguration(new SalesByWeekConfiguration());
            modelBuilder.ApplyConfiguration(new SignatureUsedConfiguration());
            modelBuilder.ApplyConfiguration(new sys_DatabaseFirewallRuleConfiguration());
            modelBuilder.ApplyConfiguration(new VolumeDiscountConfiguration());
        }

    }

    #endregion

    #region Database context factory

    public class AzureContextFactory : IDesignTimeDbContextFactory<AzureContext>
    {
        public AzureContext CreateDbContext(string[] args)
        {
            return new AzureContext();
        }
    }

    #endregion

    #region POCO classes

    // BadEmail
    public class BadEmail
    {
        public string Email { get; set; } // Email (Primary key) (length: 256)
    }

    // CartItem
    public class CartItem
    {
        public int Id { get; set; } // Id (Primary key)
        public DateTime CreatedAt { get; set; } // CreatedAt
        public DateTime LastUpdatedAt { get; set; } // LastUpdatedAt
        public string UserName { get; set; } // UserName (length: 256)
        public int ProductId { get; set; } // ProductId
        public int LicenceTypeId { get; set; } // LicenceTypeId
        public int Qty { get; set; } // Qty
        public string RegisteredTo { get; set; } // RegisteredTo (length: 256)
        public DateTime? RenewalExpiry { get; set; } // RenewalExpiry
        public DateTime? ReminderSent { get; set; } // ReminderSent

        // Foreign keys

        /// <summary>
        /// Parent LicenceType pointed by [CartItem].([LicenceTypeId]) (FK_CartItem_LicenceType_LicenceTypeId)
        /// </summary>
        public LicenceType LicenceType { get; set; } // FK_CartItem_LicenceType_LicenceTypeId

        /// <summary>
        /// Parent Product pointed by [CartItem].([ProductId]) (FK_CartItem_Product_ProductId)
        /// </summary>
        public Product Product { get; set; } // FK_CartItem_Product_ProductId

        /// <summary>
        /// Parent ProductLicenceTypeMapping pointed by [CartItem].([ProductId], [LicenceTypeId]) (FK_CartItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId)
        /// </summary>
        public ProductLicenceTypeMapping ProductLicenceTypeMapping { get; set; } // FK_CartItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId
    }

    // Checkout
    public class Checkout
    {
        public string UserName { get; set; } // UserName (Primary key) (length: 256)
        public DateTime LastUpdatedAt { get; set; } // LastUpdatedAt
        public int CountryId { get; set; } // CountryId
        public int? DiscountId { get; set; } // DiscountId
        public string FirstName { get; set; } // FirstName (length: 100)
        public string LastName { get; set; } // LastName (length: 100)
        public string Address1 { get; set; } // Address1 (length: 100)
        public string Address2 { get; set; } // Address2 (length: 100)
        public string City { get; set; } // City (length: 100)
        public string Region { get; set; } // Region (length: 100)
        public string PostalCode { get; set; } // PostalCode (length: 20)
        public string Company { get; set; } // Company (length: 256)
        public string CustomerRef { get; set; } // CustomerRef (length: 80)
        public string VatNumber { get; set; } // VatNumber (length: 20)
        public decimal? VatRate { get; set; } // VatRate
        public decimal SubTotal { get; set; } // SubTotal
        public decimal VatTotal { get; set; } // VatTotal
        public decimal Total { get; set; } // Total

        // Foreign keys

        /// <summary>
        /// Parent Country pointed by [Checkout].([CountryId]) (FK_Checkout_Country_CountryId)
        /// </summary>
        public Country Country { get; set; } // FK_Checkout_Country_CountryId

        /// <summary>
        /// Parent Discount pointed by [Checkout].([DiscountId]) (FK_Checkout_Discount_DiscountId)
        /// </summary>
        public Discount Discount { get; set; } // FK_Checkout_Discount_DiscountId
    }

    // Country
    public class Country
    {
        public int Id { get; set; } // Id (Primary key)
        public string Name { get; set; } // Name (length: 100)
        public string TwoLetterIsoCode { get; set; } // TwoLetterIsoCode (length: 2)
        public string ThreeLetterIsoCode { get; set; } // ThreeLetterIsoCode (length: 3)
        public bool SubjectToVat { get; set; } // SubjectToVat
        public decimal? VatRate { get; set; } // VatRate
        public bool Published { get; set; } // Published
        public int DisplayOrder { get; set; } // DisplayOrder
        public bool InEurope { get; set; } // InEurope

        // Reverse navigation

        /// <summary>
        /// Child Checkouts where [Checkout].[CountryId] point to this entity (FK_Checkout_Country_CountryId)
        /// </summary>
        public ICollection<Checkout> Checkouts { get; set; } // Checkout.FK_Checkout_Country_CountryId

        /// <summary>
        /// Child Orders where [Order].[CountryId] point to this entity (FK_Order_Country_CountryId)
        /// </summary>
        public ICollection<Order> Orders { get; set; } // Order.FK_Order_Country_CountryId

        public Country()
        {
            InEurope = true;
            Checkouts = new List<Checkout>();
            Orders = new List<Order>();
        }
    }

    // Discount
    public class Discount
    {
        public int Id { get; set; } // Id (Primary key)
        public string Description { get; set; } // Description (length: 150)
        public bool Active { get; set; } // Active
        public DateTime? StartDate { get; set; } // StartDate
        public DateTime? EndDate { get; set; } // EndDate
        public bool RequiresCouponCode { get; set; } // RequiresCouponCode
        public string CouponCode { get; set; } // CouponCode (length: 20)
        public bool UsePercentage { get; set; } // UsePercentage
        public decimal? DiscountPercentage { get; set; } // DiscountPercentage
        public decimal? DiscountAmount { get; set; } // DiscountAmount
        public int AddDaysToLicence { get; set; } // AddDaysToLicence
        public int MaxQty { get; set; } // MaxQty
        public int DiscountLimitationId { get; set; } // DiscountLimitationId
        public int LimitationTimes { get; set; } // LimitationTimes

        // Reverse navigation

        /// <summary>
        /// Child Checkouts where [Checkout].[DiscountId] point to this entity (FK_Checkout_Discount_DiscountId)
        /// </summary>
        public ICollection<Checkout> Checkouts { get; set; } // Checkout.FK_Checkout_Discount_DiscountId

        /// <summary>
        /// Child Orders where [Order].[DiscountId] point to this entity (FK_Order_Discount_DiscountId)
        /// </summary>
        public ICollection<Order> Orders { get; set; } // Order.FK_Order_Discount_DiscountId

        // Foreign keys

        /// <summary>
        /// Parent DiscountLimitation pointed by [Discount].([DiscountLimitationId]) (FK_Discount_DiscountLimitation_DiscountLimitationId)
        /// </summary>
        public DiscountLimitation DiscountLimitation { get; set; } // FK_Discount_DiscountLimitation_DiscountLimitationId

        public Discount()
        {
            Checkouts = new List<Checkout>();
            Orders = new List<Order>();
        }
    }

    // DiscountLimitation
    public class DiscountLimitation
    {
        public int Id { get; set; } // Id (Primary key)
        public string Description { get; set; } // Description (length: 50)
        public bool Active { get; set; } // Active

        // Reverse navigation

        /// <summary>
        /// Child Discounts where [Discount].[DiscountLimitationId] point to this entity (FK_Discount_DiscountLimitation_DiscountLimitationId)
        /// </summary>
        public ICollection<Discount> Discounts { get; set; } // Discount.FK_Discount_DiscountLimitation_DiscountLimitationId

        public DiscountLimitation()
        {
            Discounts = new List<Discount>();
        }
    }

    // LicenceType
    public class LicenceType
    {
        public int Id { get; set; } // Id (Primary key)
        public string Description { get; set; } // Description (length: 50)
        public string SubText { get; set; } // SubText (length: 256)
        public bool Active { get; set; } // Active

        // Reverse navigation

        /// <summary>
        /// Child CartItems where [CartItem].[LicenceTypeId] point to this entity (FK_CartItem_LicenceType_LicenceTypeId)
        /// </summary>
        public ICollection<CartItem> CartItems { get; set; } // CartItem.FK_CartItem_LicenceType_LicenceTypeId

        /// <summary>
        /// Child OrderItems where [OrderItem].[LicenceTypeId] point to this entity (FK_OrderItem_LicenceType_LicenceTypeId)
        /// </summary>
        public ICollection<OrderItem> OrderItems { get; set; } // OrderItem.FK_OrderItem_LicenceType_LicenceTypeId

        /// <summary>
        /// Child ProductLicenceTypeMappings where [ProductLicenceTypeMapping].[LicenceTypeId] point to this entity (FK_ProductLicenceTypeMapping_LicenceType_LicenceTypeId)
        /// </summary>
        public ICollection<ProductLicenceTypeMapping> ProductLicenceTypeMappings { get; set; } // ProductLicenceTypeMapping.FK_ProductLicenceTypeMapping_LicenceType_LicenceTypeId

        /// <summary>
        /// Child VolumeDiscounts where [VolumeDiscount].[LicenceTypeId] point to this entity (FK_VolumeDiscount_LicenceType_LicenceTypeId)
        /// </summary>
        public ICollection<VolumeDiscount> VolumeDiscounts { get; set; } // VolumeDiscount.FK_VolumeDiscount_LicenceType_LicenceTypeId

        public LicenceType()
        {
            CartItems = new List<CartItem>();
            OrderItems = new List<OrderItem>();
            ProductLicenceTypeMappings = new List<ProductLicenceTypeMapping>();
            VolumeDiscounts = new List<VolumeDiscount>();
        }
    }

    // NotificationOptOut
    public class NotificationOptOut
    {
        public string UserName { get; set; } // UserName (Primary key) (length: 256)
        public int NotificationTypeId { get; set; } // NotificationTypeId (Primary key)

        // Foreign keys

        /// <summary>
        /// Parent NotificationType pointed by [NotificationOptOut].([NotificationTypeId]) (FK_NotificationOptOut_NotificationType_NotificationTypeId)
        /// </summary>
        public NotificationType NotificationType { get; set; } // FK_NotificationOptOut_NotificationType_NotificationTypeId
    }

    // NotificationType
    public class NotificationType
    {
        public int Id { get; set; } // Id (Primary key)
        public string Description { get; set; } // Description (length: 50)
        public bool Active { get; set; } // Active

        // Reverse navigation

        /// <summary>
        /// Child NotificationOptOuts where [NotificationOptOut].[NotificationTypeId] point to this entity (FK_NotificationOptOut_NotificationType_NotificationTypeId)
        /// </summary>
        public ICollection<NotificationOptOut> NotificationOptOuts { get; set; } // NotificationOptOut.FK_NotificationOptOut_NotificationType_NotificationTypeId

        /// <summary>
        /// Child OrderNotificationSents where [OrderNotificationSent].[NotificationTypeId] point to this entity (FK_OrderNotificationSent_NotificationType_NotificationTypeId)
        /// </summary>
        public ICollection<OrderNotificationSent> OrderNotificationSents { get; set; } // OrderNotificationSent.FK_OrderNotificationSent_NotificationType_NotificationTypeId

        public NotificationType()
        {
            NotificationOptOuts = new List<NotificationOptOut>();
            OrderNotificationSents = new List<OrderNotificationSent>();
        }
    }

    // Order
    public class Order
    {
        public int Id { get; set; } // Id (Primary key)
        public DateTime CreatedAt { get; set; } // CreatedAt
        public string UserName { get; set; } // UserName (length: 256)
        public int CountryId { get; set; } // CountryId
        public int? DiscountId { get; set; } // DiscountId
        public string TransactionId { get; set; } // TransactionId (length: 40)
        public string FirstName { get; set; } // FirstName (length: 100)
        public string LastName { get; set; } // LastName (length: 100)
        public string Address1 { get; set; } // Address1 (length: 100)
        public string Address2 { get; set; } // Address2 (length: 100)
        public string City { get; set; } // City (length: 100)
        public string Region { get; set; } // Region (length: 100)
        public string PostalCode { get; set; } // PostalCode (length: 20)
        public string Company { get; set; } // Company (length: 256)
        public string CustomerRef { get; set; } // CustomerRef (length: 80)
        public string VatNumber { get; set; } // VatNumber (length: 20)
        public decimal? VatRate { get; set; } // VatRate
        public decimal SubTotal { get; set; } // SubTotal
        public decimal VatTotal { get; set; } // VatTotal
        public decimal Total { get; set; } // Total
        public decimal UkVatRate { get; set; } // UkVatRate
        public decimal ReverseChargeVatTotal { get; set; } // ReverseChargeVatTotal
        public bool NotificationsComplete { get; set; } // NotificationsComplete
        public byte Status { get; set; } // Status
        public DateTime? PaymentReceivedDate { get; set; } // PaymentReceivedDate

        // Reverse navigation

        /// <summary>
        /// Child OrderItems where [OrderItem].[OrderId] point to this entity (FK_OrderItem_Order_OrderId)
        /// </summary>
        public ICollection<OrderItem> OrderItems { get; set; } // OrderItem.FK_OrderItem_Order_OrderId

        /// <summary>
        /// Child OrderLogs where [OrderLog].[OrderId] point to this entity (FK_OrderLog_Order_OrderId)
        /// </summary>
        public ICollection<OrderLog> OrderLogs { get; set; } // OrderLog.FK_OrderLog_Order_OrderId

        // Foreign keys

        /// <summary>
        /// Parent Country pointed by [Order].([CountryId]) (FK_Order_Country_CountryId)
        /// </summary>
        public Country Country { get; set; } // FK_Order_Country_CountryId

        /// <summary>
        /// Parent Discount pointed by [Order].([DiscountId]) (FK_Order_Discount_DiscountId)
        /// </summary>
        public Discount Discount { get; set; } // FK_Order_Discount_DiscountId

        public Order()
        {
            UkVatRate = 0.2m;
            ReverseChargeVatTotal = 0.0m;
            NotificationsComplete = true;
            OrderItems = new List<OrderItem>();
            OrderLogs = new List<OrderLog>();
        }
    }

    // OrderItem
    public class OrderItem
    {
        public int Id { get; set; } // Id (Primary key)
        public int SignatureUsedId { get; set; } // SignatureUsedId
        public int OrderId { get; set; } // OrderId
        public int ProductId { get; set; } // ProductId
        public int LicenceTypeId { get; set; } // LicenceTypeId
        public int Qty { get; set; } // Qty
        public string RegisteredTo { get; set; } // RegisteredTo (length: 256)
        public DateTime LicenceExpiry { get; set; } // LicenceExpiry
        public decimal UnitPrice { get; set; } // UnitPrice
        public decimal Discount { get; set; } // Discount
        public decimal SubTotal { get; set; } // SubTotal
        public decimal Vat { get; set; } // Vat
        public decimal Total { get; set; } // Total
        public bool Notify30DaysComplete { get; set; } // Notify30DaysComplete
        public bool Notify7DaysComplete { get; set; } // Notify7DaysComplete

        // Reverse navigation

        /// <summary>
        /// Child OrderNotificationSents where [OrderNotificationSent].[OrderItemId] point to this entity (FK_OrderNotificationSent_OrderItem_OrderItemId)
        /// </summary>
        public ICollection<OrderNotificationSent> OrderNotificationSents { get; set; } // OrderNotificationSent.FK_OrderNotificationSent_OrderItem_OrderItemId

        // Foreign keys

        /// <summary>
        /// Parent LicenceType pointed by [OrderItem].([LicenceTypeId]) (FK_OrderItem_LicenceType_LicenceTypeId)
        /// </summary>
        public LicenceType LicenceType { get; set; } // FK_OrderItem_LicenceType_LicenceTypeId

        /// <summary>
        /// Parent Order pointed by [OrderItem].([OrderId]) (FK_OrderItem_Order_OrderId)
        /// </summary>
        public Order Order { get; set; } // FK_OrderItem_Order_OrderId

        /// <summary>
        /// Parent Product pointed by [OrderItem].([ProductId]) (FK_OrderItem_Product_ProductId)
        /// </summary>
        public Product Product { get; set; } // FK_OrderItem_Product_ProductId

        /// <summary>
        /// Parent ProductLicenceTypeMapping pointed by [OrderItem].([ProductId], [LicenceTypeId]) (FK_OrderItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId)
        /// </summary>
        public ProductLicenceTypeMapping ProductLicenceTypeMapping { get; set; } // FK_OrderItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId

        /// <summary>
        /// Parent SignatureUsed pointed by [OrderItem].([SignatureUsedId]) (FK_OrderItem_SignatureUsed_SignatureUsedId)
        /// </summary>
        public SignatureUsed SignatureUsed { get; set; } // FK_OrderItem_SignatureUsed_SignatureUsedId

        public OrderItem()
        {
            Notify30DaysComplete = true;
            Notify7DaysComplete = true;
            OrderNotificationSents = new List<OrderNotificationSent>();
        }
    }

    // OrderLog
    public class OrderLog
    {
        public int Id { get; set; } // Id (Primary key)
        public DateTime CreatedAt { get; set; } // CreatedAt
        public byte Status { get; set; } // Status
        public string EmailedTo { get; set; } // EmailedTo (length: 256)
        public int OrderId { get; set; } // OrderId

        // Foreign keys

        /// <summary>
        /// Parent Order pointed by [OrderLog].([OrderId]) (FK_OrderLog_Order_OrderId)
        /// </summary>
        public Order Order { get; set; } // FK_OrderLog_Order_OrderId
    }

    // OrderNotificationSent
    public class OrderNotificationSent
    {
        public int OrderItemId { get; set; } // OrderItemId (Primary key)
        public int NotificationTypeId { get; set; } // NotificationTypeId (Primary key)
        public DateTime SentOn { get; set; } // SentOn

        // Foreign keys

        /// <summary>
        /// Parent NotificationType pointed by [OrderNotificationSent].([NotificationTypeId]) (FK_OrderNotificationSent_NotificationType_NotificationTypeId)
        /// </summary>
        public NotificationType NotificationType { get; set; } // FK_OrderNotificationSent_NotificationType_NotificationTypeId

        /// <summary>
        /// Parent OrderItem pointed by [OrderNotificationSent].([OrderItemId]) (FK_OrderNotificationSent_OrderItem_OrderItemId)
        /// </summary>
        public OrderItem OrderItem { get; set; } // FK_OrderNotificationSent_OrderItem_OrderItemId
    }

    // Product
    public class Product
    {
        public int Id { get; set; } // Id (Primary key)
        public string Description { get; set; } // Description (length: 80)
        public string ShortDescription { get; set; } // ShortDescription (length: 80)
        public bool Active { get; set; } // Active

        // Reverse navigation

        /// <summary>
        /// Child CartItems where [CartItem].[ProductId] point to this entity (FK_CartItem_Product_ProductId)
        /// </summary>
        public ICollection<CartItem> CartItems { get; set; } // CartItem.FK_CartItem_Product_ProductId

        /// <summary>
        /// Child OrderItems where [OrderItem].[ProductId] point to this entity (FK_OrderItem_Product_ProductId)
        /// </summary>
        public ICollection<OrderItem> OrderItems { get; set; } // OrderItem.FK_OrderItem_Product_ProductId

        /// <summary>
        /// Child ProductLicenceTypeMappings where [ProductLicenceTypeMapping].[ProductId] point to this entity (FK_ProductLicenceTypeMapping_Product_ProductId)
        /// </summary>
        public ICollection<ProductLicenceTypeMapping> ProductLicenceTypeMappings { get; set; } // ProductLicenceTypeMapping.FK_ProductLicenceTypeMapping_Product_ProductId

        /// <summary>
        /// Child VolumeDiscounts where [VolumeDiscount].[ProductId] point to this entity (FK_VolumeDiscount_Product_ProductId)
        /// </summary>
        public ICollection<VolumeDiscount> VolumeDiscounts { get; set; } // VolumeDiscount.FK_VolumeDiscount_Product_ProductId

        public Product()
        {
            CartItems = new List<CartItem>();
            OrderItems = new List<OrderItem>();
            ProductLicenceTypeMappings = new List<ProductLicenceTypeMapping>();
            VolumeDiscounts = new List<VolumeDiscount>();
        }
    }

    // ProductLicenceTypeMapping
    public class ProductLicenceTypeMapping
    {
        public int ProductId { get; set; } // ProductId (Primary key)
        public int LicenceTypeId { get; set; } // LicenceTypeId (Primary key)
        public bool Active { get; set; } // Active
        public decimal Price { get; set; } // Price
        public int Days { get; set; } // Days
        public string DurationText { get; set; } // DurationText (length: 20)
        public string MaxTables { get; set; } // MaxTables (length: 20)
        public string MaxTablesBadge { get; set; } // MaxTablesBadge (length: 20)
        public string MaxStoredProcs { get; set; } // MaxStoredProcs (length: 20)
        public string MaxStoredProcsBadge { get; set; } // MaxStoredProcsBadge (length: 20)

        // Reverse navigation

        /// <summary>
        /// Child CartItems where [CartItem].([LicenceTypeId], [ProductId]) point to this entity (FK_CartItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId)
        /// </summary>
        public ICollection<CartItem> CartItems { get; set; } // CartItem.FK_CartItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId

        /// <summary>
        /// Child OrderItems where [OrderItem].([LicenceTypeId], [ProductId]) point to this entity (FK_OrderItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId)
        /// </summary>
        public ICollection<OrderItem> OrderItems { get; set; } // OrderItem.FK_OrderItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId

        // Foreign keys

        /// <summary>
        /// Parent LicenceType pointed by [ProductLicenceTypeMapping].([LicenceTypeId]) (FK_ProductLicenceTypeMapping_LicenceType_LicenceTypeId)
        /// </summary>
        public LicenceType LicenceType { get; set; } // FK_ProductLicenceTypeMapping_LicenceType_LicenceTypeId

        /// <summary>
        /// Parent Product pointed by [ProductLicenceTypeMapping].([ProductId]) (FK_ProductLicenceTypeMapping_Product_ProductId)
        /// </summary>
        public Product Product { get; set; } // FK_ProductLicenceTypeMapping_Product_ProductId

        public ProductLicenceTypeMapping()
        {
            CartItems = new List<CartItem>();
            OrderItems = new List<OrderItem>();
        }
    }

    // SalesByWeek
    public class SalesByWeek
    {
        public int? Year { get; set; } // Year
        public int? Week { get; set; } // Week
        public string Description { get; set; } // Description (length: 50)
        public int? NumOrders { get; set; } // NumOrders
        public int? Qty { get; set; } // Qty
        public decimal? SubTotal { get; set; } // SubTotal
    }

    // SignatureUsed
    public class SignatureUsed
    {
        public int Id { get; set; } // Id (Primary key)
        public string Modulus { get; set; } // Modulus (length: 10)

        // Reverse navigation

        /// <summary>
        /// Child OrderItems where [OrderItem].[SignatureUsedId] point to this entity (FK_OrderItem_SignatureUsed_SignatureUsedId)
        /// </summary>
        public ICollection<OrderItem> OrderItems { get; set; } // OrderItem.FK_OrderItem_SignatureUsed_SignatureUsedId

        public SignatureUsed()
        {
            OrderItems = new List<OrderItem>();
        }
    }

    // database_firewall_rules
    public class sys_DatabaseFirewallRule
    {
        public int Id { get; set; } // id
        public string Name { get; set; } // name (length: 128)
        public string StartIpAddress { get; set; } // start_ip_address (length: 45)
        public string EndIpAddress { get; set; } // end_ip_address (length: 45)
        public DateTime CreateDate { get; set; } // create_date
        public DateTime ModifyDate { get; set; } // modify_date
    }

    // VolumeDiscount
    public class VolumeDiscount
    {
        public int Id { get; set; } // Id (Primary key)
        public bool Active { get; set; } // Active
        public int ProductId { get; set; } // ProductId
        public int LicenceTypeId { get; set; } // LicenceTypeId
        public string Description { get; set; } // Description (length: 150)
        public int MinQty { get; set; } // MinQty
        public int MaxQty { get; set; } // MaxQty
        public decimal? DiscountPercentage { get; set; } // DiscountPercentage

        // Foreign keys

        /// <summary>
        /// Parent LicenceType pointed by [VolumeDiscount].([LicenceTypeId]) (FK_VolumeDiscount_LicenceType_LicenceTypeId)
        /// </summary>
        public LicenceType LicenceType { get; set; } // FK_VolumeDiscount_LicenceType_LicenceTypeId

        /// <summary>
        /// Parent Product pointed by [VolumeDiscount].([ProductId]) (FK_VolumeDiscount_Product_ProductId)
        /// </summary>
        public Product Product { get; set; } // FK_VolumeDiscount_Product_ProductId
    }


    #endregion

    #region POCO Configuration

    // BadEmail
    public class BadEmailConfiguration : IEntityTypeConfiguration<BadEmail>
    {
        public void Configure(EntityTypeBuilder<BadEmail> builder)
        {
            builder.ToTable("BadEmail", "dbo");
            builder.HasKey(x => x.Email).HasName("PK_BadEmail").IsClustered();

            builder.Property(x => x.Email).HasColumnName(@"Email").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256).ValueGeneratedNever();
        }
    }

    // CartItem
    public class CartItemConfiguration : IEntityTypeConfiguration<CartItem>
    {
        public void Configure(EntityTypeBuilder<CartItem> builder)
        {
            builder.ToTable("CartItem", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_CartItem").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.CreatedAt).HasColumnName(@"CreatedAt").HasColumnType("datetime2").IsRequired();
            builder.Property(x => x.LastUpdatedAt).HasColumnName(@"LastUpdatedAt").HasColumnType("datetime2").IsRequired();
            builder.Property(x => x.UserName).HasColumnName(@"UserName").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256);
            builder.Property(x => x.ProductId).HasColumnName(@"ProductId").HasColumnType("int").IsRequired();
            builder.Property(x => x.LicenceTypeId).HasColumnName(@"LicenceTypeId").HasColumnType("int").IsRequired();
            builder.Property(x => x.Qty).HasColumnName(@"Qty").HasColumnType("int").IsRequired();
            builder.Property(x => x.RegisteredTo).HasColumnName(@"RegisteredTo").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256);
            builder.Property(x => x.RenewalExpiry).HasColumnName(@"RenewalExpiry").HasColumnType("datetime2").IsRequired(false);
            builder.Property(x => x.ReminderSent).HasColumnName(@"ReminderSent").HasColumnType("datetime2").IsRequired(false);

            // Foreign keys
            builder.HasOne(a => a.LicenceType).WithMany(b => b.CartItems).HasForeignKey(c => c.LicenceTypeId).HasConstraintName("FK_CartItem_LicenceType_LicenceTypeId");
            builder.HasOne(a => a.Product).WithMany(b => b.CartItems).HasForeignKey(c => c.ProductId).HasConstraintName("FK_CartItem_Product_ProductId");
            builder.HasOne(a => a.ProductLicenceTypeMapping).WithMany(b => b.CartItems).HasForeignKey(c => new { c.ProductId, c.LicenceTypeId }).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_CartItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId");

            builder.HasIndex(x => x.LicenceTypeId).HasDatabaseName("IX_CartItem_LicenceTypeId");
            builder.HasIndex(x => new { x.ProductId, x.LicenceTypeId }).HasDatabaseName("IX_CartItem_ProductId_LicenceTypeId");
            builder.HasIndex(x => x.UserName).HasDatabaseName("IX_CartItem_UserName");
        }
    }

    // Checkout
    public class CheckoutConfiguration : IEntityTypeConfiguration<Checkout>
    {
        public void Configure(EntityTypeBuilder<Checkout> builder)
        {
            builder.ToTable("Checkout", "dbo");
            builder.HasKey(x => x.UserName).HasName("PK_Checkout");

            builder.Property(x => x.UserName).HasColumnName(@"UserName").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256).ValueGeneratedNever();
            builder.Property(x => x.LastUpdatedAt).HasColumnName(@"LastUpdatedAt").HasColumnType("datetime2").IsRequired();
            builder.Property(x => x.CountryId).HasColumnName(@"CountryId").HasColumnType("int").IsRequired();
            builder.Property(x => x.DiscountId).HasColumnName(@"DiscountId").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.FirstName).HasColumnName(@"FirstName").HasColumnType("nvarchar(100)").IsRequired().HasMaxLength(100);
            builder.Property(x => x.LastName).HasColumnName(@"LastName").HasColumnType("nvarchar(100)").IsRequired().HasMaxLength(100);
            builder.Property(x => x.Address1).HasColumnName(@"Address1").HasColumnType("nvarchar(100)").IsRequired().HasMaxLength(100);
            builder.Property(x => x.Address2).HasColumnName(@"Address2").HasColumnType("nvarchar(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.Company).HasColumnName(@"Company").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256);
            builder.Property(x => x.CustomerRef).HasColumnName(@"CustomerRef").HasColumnType("nvarchar(80)").IsRequired(false).HasMaxLength(80);
            builder.Property(x => x.VatNumber).HasColumnName(@"VatNumber").HasColumnType("nvarchar(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.VatRate).HasColumnName(@"VatRate").HasColumnType("decimal(9,5)").HasPrecision(9,5).IsRequired(false);
            builder.Property(x => x.SubTotal).HasColumnName(@"SubTotal").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.VatTotal).HasColumnName(@"VatTotal").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Total).HasColumnName(@"Total").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Country).WithMany(b => b.Checkouts).HasForeignKey(c => c.CountryId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Checkout_Country_CountryId");
            builder.HasOne(a => a.Discount).WithMany(b => b.Checkouts).HasForeignKey(c => c.DiscountId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Checkout_Discount_DiscountId");

            builder.HasIndex(x => x.CountryId).HasDatabaseName("IX_Checkout_CountryId");
            builder.HasIndex(x => x.DiscountId).HasDatabaseName("IX_Checkout_DiscountId");
        }
    }

    // Country
    public class CountryConfiguration : IEntityTypeConfiguration<Country>
    {
        public void Configure(EntityTypeBuilder<Country> builder)
        {
            builder.ToTable("Country", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_Country").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.Name).HasColumnName(@"Name").HasColumnType("varchar(100)").IsRequired().IsUnicode(false).HasMaxLength(100);
            builder.Property(x => x.TwoLetterIsoCode).HasColumnName(@"TwoLetterIsoCode").HasColumnType("varchar(2)").IsRequired().IsUnicode(false).HasMaxLength(2);
            builder.Property(x => x.ThreeLetterIsoCode).HasColumnName(@"ThreeLetterIsoCode").HasColumnType("varchar(3)").IsRequired().IsUnicode(false).HasMaxLength(3);
            builder.Property(x => x.SubjectToVat).HasColumnName(@"SubjectToVat").HasColumnType("bit").IsRequired();
            builder.Property(x => x.VatRate).HasColumnName(@"VatRate").HasColumnType("decimal(9,5)").HasPrecision(9,5).IsRequired(false);
            builder.Property(x => x.Published).HasColumnName(@"Published").HasColumnType("bit").IsRequired();
            builder.Property(x => x.DisplayOrder).HasColumnName(@"DisplayOrder").HasColumnType("int").IsRequired();
            builder.Property(x => x.InEurope).HasColumnName(@"InEurope").HasColumnType("bit").IsRequired();

            builder.HasIndex(x => new { x.DisplayOrder, x.Name }).HasDatabaseName("IX_Country_DisplayOrder_Name");
        }
    }

    // Discount
    public class DiscountConfiguration : IEntityTypeConfiguration<Discount>
    {
        public void Configure(EntityTypeBuilder<Discount> builder)
        {
            builder.ToTable("Discount", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_Discount").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(150)").IsRequired().IsUnicode(false).HasMaxLength(150);
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
            builder.Property(x => x.StartDate).HasColumnName(@"StartDate").HasColumnType("datetime2").IsRequired(false);
            builder.Property(x => x.EndDate).HasColumnName(@"EndDate").HasColumnType("datetime2").IsRequired(false);
            builder.Property(x => x.RequiresCouponCode).HasColumnName(@"RequiresCouponCode").HasColumnType("bit").IsRequired();
            builder.Property(x => x.CouponCode).HasColumnName(@"CouponCode").HasColumnType("varchar(20)").IsRequired(false).IsUnicode(false).HasMaxLength(20);
            builder.Property(x => x.UsePercentage).HasColumnName(@"UsePercentage").HasColumnType("bit").IsRequired();
            builder.Property(x => x.DiscountPercentage).HasColumnName(@"DiscountPercentage").HasColumnType("decimal(9,5)").HasPrecision(9,5).IsRequired(false);
            builder.Property(x => x.DiscountAmount).HasColumnName(@"DiscountAmount").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired(false);
            builder.Property(x => x.AddDaysToLicence).HasColumnName(@"AddDaysToLicence").HasColumnType("int").IsRequired();
            builder.Property(x => x.MaxQty).HasColumnName(@"MaxQty").HasColumnType("int").IsRequired();
            builder.Property(x => x.DiscountLimitationId).HasColumnName(@"DiscountLimitationId").HasColumnType("int").IsRequired();
            builder.Property(x => x.LimitationTimes).HasColumnName(@"LimitationTimes").HasColumnType("int").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.DiscountLimitation).WithMany(b => b.Discounts).HasForeignKey(c => c.DiscountLimitationId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Discount_DiscountLimitation_DiscountLimitationId");

            builder.HasIndex(x => x.DiscountLimitationId).HasDatabaseName("IX_Discount_DiscountLimitationId");
        }
    }

    // DiscountLimitation
    public class DiscountLimitationConfiguration : IEntityTypeConfiguration<DiscountLimitation>
    {
        public void Configure(EntityTypeBuilder<DiscountLimitation> builder)
        {
            builder.ToTable("DiscountLimitation", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_DiscountLimitation").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(50)").IsRequired().IsUnicode(false).HasMaxLength(50);
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
        }
    }

    // LicenceType
    public class LicenceTypeConfiguration : IEntityTypeConfiguration<LicenceType>
    {
        public void Configure(EntityTypeBuilder<LicenceType> builder)
        {
            builder.ToTable("LicenceType", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_LicenceType").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(50)").IsRequired().IsUnicode(false).HasMaxLength(50);
            builder.Property(x => x.SubText).HasColumnName(@"SubText").HasColumnType("varchar(256)").IsRequired().IsUnicode(false).HasMaxLength(256);
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
        }
    }

    // NotificationOptOut
    public class NotificationOptOutConfiguration : IEntityTypeConfiguration<NotificationOptOut>
    {
        public void Configure(EntityTypeBuilder<NotificationOptOut> builder)
        {
            builder.ToTable("NotificationOptOut", "dbo");
            builder.HasKey(x => new { x.UserName, x.NotificationTypeId }).HasName("PK_NotificationOptOut");

            builder.Property(x => x.UserName).HasColumnName(@"UserName").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256).ValueGeneratedNever();
            builder.Property(x => x.NotificationTypeId).HasColumnName(@"NotificationTypeId").HasColumnType("int").IsRequired().ValueGeneratedNever();

            // Foreign keys
            builder.HasOne(a => a.NotificationType).WithMany(b => b.NotificationOptOuts).HasForeignKey(c => c.NotificationTypeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_NotificationOptOut_NotificationType_NotificationTypeId");

            builder.HasIndex(x => x.NotificationTypeId).HasDatabaseName("IX_NotificationOptOut_NotificationTypeId");
            builder.HasIndex(x => x.UserName).HasDatabaseName("IX_NotificationOptOut_UserName");
        }
    }

    // NotificationType
    public class NotificationTypeConfiguration : IEntityTypeConfiguration<NotificationType>
    {
        public void Configure(EntityTypeBuilder<NotificationType> builder)
        {
            builder.ToTable("NotificationType", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_NotificationType").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(50)").IsRequired().IsUnicode(false).HasMaxLength(50);
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
        }
    }

    // Order
    public class OrderConfiguration : IEntityTypeConfiguration<Order>
    {
        public void Configure(EntityTypeBuilder<Order> builder)
        {
            builder.ToTable("Order", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_Order").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.CreatedAt).HasColumnName(@"CreatedAt").HasColumnType("datetime2").IsRequired();
            builder.Property(x => x.UserName).HasColumnName(@"UserName").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256);
            builder.Property(x => x.CountryId).HasColumnName(@"CountryId").HasColumnType("int").IsRequired();
            builder.Property(x => x.DiscountId).HasColumnName(@"DiscountId").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.TransactionId).HasColumnName(@"TransactionId").HasColumnType("varchar(40)").IsRequired().IsUnicode(false).HasMaxLength(40);
            builder.Property(x => x.FirstName).HasColumnName(@"FirstName").HasColumnType("nvarchar(100)").IsRequired().HasMaxLength(100);
            builder.Property(x => x.LastName).HasColumnName(@"LastName").HasColumnType("nvarchar(100)").IsRequired().HasMaxLength(100);
            builder.Property(x => x.Address1).HasColumnName(@"Address1").HasColumnType("nvarchar(100)").IsRequired().HasMaxLength(100);
            builder.Property(x => x.Address2).HasColumnName(@"Address2").HasColumnType("nvarchar(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.City).HasColumnName(@"City").HasColumnType("nvarchar(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.Region).HasColumnName(@"Region").HasColumnType("nvarchar(100)").IsRequired(false).HasMaxLength(100);
            builder.Property(x => x.PostalCode).HasColumnName(@"PostalCode").HasColumnType("nvarchar(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.Company).HasColumnName(@"Company").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256);
            builder.Property(x => x.CustomerRef).HasColumnName(@"CustomerRef").HasColumnType("nvarchar(80)").IsRequired(false).HasMaxLength(80);
            builder.Property(x => x.VatNumber).HasColumnName(@"VatNumber").HasColumnType("nvarchar(20)").IsRequired(false).HasMaxLength(20);
            builder.Property(x => x.VatRate).HasColumnName(@"VatRate").HasColumnType("decimal(9,5)").HasPrecision(9,5).IsRequired(false);
            builder.Property(x => x.SubTotal).HasColumnName(@"SubTotal").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.VatTotal).HasColumnName(@"VatTotal").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Total).HasColumnName(@"Total").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.UkVatRate).HasColumnName(@"UkVatRate").HasColumnType("decimal(9,5)").HasPrecision(9,5).IsRequired();
            builder.Property(x => x.ReverseChargeVatTotal).HasColumnName(@"ReverseChargeVatTotal").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.NotificationsComplete).HasColumnName(@"NotificationsComplete").HasColumnType("bit").IsRequired();
            builder.Property(x => x.Status).HasColumnName(@"Status").HasColumnType("tinyint").IsRequired();
            builder.Property(x => x.PaymentReceivedDate).HasColumnName(@"PaymentReceivedDate").HasColumnType("datetime2").IsRequired(false);

            // Foreign keys
            builder.HasOne(a => a.Country).WithMany(b => b.Orders).HasForeignKey(c => c.CountryId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Order_Country_CountryId");
            builder.HasOne(a => a.Discount).WithMany(b => b.Orders).HasForeignKey(c => c.DiscountId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_Order_Discount_DiscountId");

            builder.HasIndex(x => x.CountryId).HasDatabaseName("IX_Order_CountryId");
            builder.HasIndex(x => x.DiscountId).HasDatabaseName("IX_Order_DiscountId");
            builder.HasIndex(x => x.Status).HasDatabaseName("IX_Order_Status");
            builder.HasIndex(x => x.UserName).HasDatabaseName("IX_Order_UserName");
        }
    }

    // OrderItem
    public class OrderItemConfiguration : IEntityTypeConfiguration<OrderItem>
    {
        public void Configure(EntityTypeBuilder<OrderItem> builder)
        {
            builder.ToTable("OrderItem", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_OrderItem").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.SignatureUsedId).HasColumnName(@"SignatureUsedId").HasColumnType("int").IsRequired();
            builder.Property(x => x.OrderId).HasColumnName(@"OrderId").HasColumnType("int").IsRequired();
            builder.Property(x => x.ProductId).HasColumnName(@"ProductId").HasColumnType("int").IsRequired();
            builder.Property(x => x.LicenceTypeId).HasColumnName(@"LicenceTypeId").HasColumnType("int").IsRequired();
            builder.Property(x => x.Qty).HasColumnName(@"Qty").HasColumnType("int").IsRequired();
            builder.Property(x => x.RegisteredTo).HasColumnName(@"RegisteredTo").HasColumnType("nvarchar(256)").IsRequired().HasMaxLength(256);
            builder.Property(x => x.LicenceExpiry).HasColumnName(@"LicenceExpiry").HasColumnType("datetime2").IsRequired();
            builder.Property(x => x.UnitPrice).HasColumnName(@"UnitPrice").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Discount).HasColumnName(@"Discount").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.SubTotal).HasColumnName(@"SubTotal").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Vat).HasColumnName(@"Vat").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Total).HasColumnName(@"Total").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Notify30DaysComplete).HasColumnName(@"Notify30DaysComplete").HasColumnType("bit").IsRequired();
            builder.Property(x => x.Notify7DaysComplete).HasColumnName(@"Notify7DaysComplete").HasColumnType("bit").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.LicenceType).WithMany(b => b.OrderItems).HasForeignKey(c => c.LicenceTypeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_OrderItem_LicenceType_LicenceTypeId");
            builder.HasOne(a => a.Order).WithMany(b => b.OrderItems).HasForeignKey(c => c.OrderId).HasConstraintName("FK_OrderItem_Order_OrderId");
            builder.HasOne(a => a.Product).WithMany(b => b.OrderItems).HasForeignKey(c => c.ProductId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_OrderItem_Product_ProductId");
            builder.HasOne(a => a.ProductLicenceTypeMapping).WithMany(b => b.OrderItems).HasForeignKey(c => new { c.ProductId, c.LicenceTypeId }).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_OrderItem_ProductLicenceTypeMapping_ProductId_LicenceTypeId");
            builder.HasOne(a => a.SignatureUsed).WithMany(b => b.OrderItems).HasForeignKey(c => c.SignatureUsedId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_OrderItem_SignatureUsed_SignatureUsedId");

            builder.HasIndex(x => x.LicenceTypeId).HasDatabaseName("IX_OrderItem_LicenceTypeId");
            builder.HasIndex(x => x.OrderId).HasDatabaseName("IX_OrderItem_OrderId");
            builder.HasIndex(x => new { x.ProductId, x.LicenceTypeId }).HasDatabaseName("IX_OrderItem_ProductId_LicenceTypeId");
            builder.HasIndex(x => x.SignatureUsedId).HasDatabaseName("IX_OrderItem_SignatureUsedId");
        }
    }

    // OrderLog
    public class OrderLogConfiguration : IEntityTypeConfiguration<OrderLog>
    {
        public void Configure(EntityTypeBuilder<OrderLog> builder)
        {
            builder.ToTable("OrderLog", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_OrderLog").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.CreatedAt).HasColumnName(@"CreatedAt").HasColumnType("datetime2").IsRequired();
            builder.Property(x => x.Status).HasColumnName(@"Status").HasColumnType("tinyint").IsRequired();
            builder.Property(x => x.EmailedTo).HasColumnName(@"EmailedTo").HasColumnType("nvarchar(256)").IsRequired(false).HasMaxLength(256);
            builder.Property(x => x.OrderId).HasColumnName(@"OrderId").HasColumnType("int").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.Order).WithMany(b => b.OrderLogs).HasForeignKey(c => c.OrderId).HasConstraintName("FK_OrderLog_Order_OrderId");

            builder.HasIndex(x => x.OrderId).HasDatabaseName("IX_OrderLog_OrderId");
        }
    }

    // OrderNotificationSent
    public class OrderNotificationSentConfiguration : IEntityTypeConfiguration<OrderNotificationSent>
    {
        public void Configure(EntityTypeBuilder<OrderNotificationSent> builder)
        {
            builder.ToTable("OrderNotificationSent", "dbo");
            builder.HasKey(x => new { x.OrderItemId, x.NotificationTypeId }).HasName("PK_OrderNotificationSent");

            builder.Property(x => x.OrderItemId).HasColumnName(@"OrderItemId").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.NotificationTypeId).HasColumnName(@"NotificationTypeId").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.SentOn).HasColumnName(@"SentOn").HasColumnType("datetime2").IsRequired();

            // Foreign keys
            builder.HasOne(a => a.NotificationType).WithMany(b => b.OrderNotificationSents).HasForeignKey(c => c.NotificationTypeId).HasConstraintName("FK_OrderNotificationSent_NotificationType_NotificationTypeId");
            builder.HasOne(a => a.OrderItem).WithMany(b => b.OrderNotificationSents).HasForeignKey(c => c.OrderItemId).HasConstraintName("FK_OrderNotificationSent_OrderItem_OrderItemId");

            builder.HasIndex(x => x.NotificationTypeId).HasDatabaseName("IX_OrderNotificationSent_NotificationTypeId");
        }
    }

    // Product
    public class ProductConfiguration : IEntityTypeConfiguration<Product>
    {
        public void Configure(EntityTypeBuilder<Product> builder)
        {
            builder.ToTable("Product", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_Product").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(80)").IsRequired().IsUnicode(false).HasMaxLength(80);
            builder.Property(x => x.ShortDescription).HasColumnName(@"ShortDescription").HasColumnType("varchar(80)").IsRequired().IsUnicode(false).HasMaxLength(80);
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
        }
    }

    // ProductLicenceTypeMapping
    public class ProductLicenceTypeMappingConfiguration : IEntityTypeConfiguration<ProductLicenceTypeMapping>
    {
        public void Configure(EntityTypeBuilder<ProductLicenceTypeMapping> builder)
        {
            builder.ToTable("ProductLicenceTypeMapping", "dbo");
            builder.HasKey(x => new { x.ProductId, x.LicenceTypeId }).HasName("PK_ProductLicenceTypeMapping").IsClustered();

            builder.Property(x => x.ProductId).HasColumnName(@"ProductId").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.LicenceTypeId).HasColumnName(@"LicenceTypeId").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
            builder.Property(x => x.Price).HasColumnName(@"Price").HasColumnType("decimal(19,4)").HasPrecision(19,4).IsRequired();
            builder.Property(x => x.Days).HasColumnName(@"Days").HasColumnType("int").IsRequired();
            builder.Property(x => x.DurationText).HasColumnName(@"DurationText").HasColumnType("nvarchar(20)").IsRequired().HasMaxLength(20);
            builder.Property(x => x.MaxTables).HasColumnName(@"MaxTables").HasColumnType("nvarchar(20)").IsRequired().HasMaxLength(20);
            builder.Property(x => x.MaxTablesBadge).HasColumnName(@"MaxTablesBadge").HasColumnType("nvarchar(20)").IsRequired().HasMaxLength(20);
            builder.Property(x => x.MaxStoredProcs).HasColumnName(@"MaxStoredProcs").HasColumnType("nvarchar(20)").IsRequired().HasMaxLength(20);
            builder.Property(x => x.MaxStoredProcsBadge).HasColumnName(@"MaxStoredProcsBadge").HasColumnType("nvarchar(20)").IsRequired().HasMaxLength(20);

            // Foreign keys
            builder.HasOne(a => a.LicenceType).WithMany(b => b.ProductLicenceTypeMappings).HasForeignKey(c => c.LicenceTypeId).HasConstraintName("FK_ProductLicenceTypeMapping_LicenceType_LicenceTypeId");
            builder.HasOne(a => a.Product).WithMany(b => b.ProductLicenceTypeMappings).HasForeignKey(c => c.ProductId).HasConstraintName("FK_ProductLicenceTypeMapping_Product_ProductId");

            builder.HasIndex(x => x.LicenceTypeId).HasDatabaseName("IX_ProductLicenceTypeMapping_LicenceTypeId");
        }
    }

    // SalesByWeek
    public class SalesByWeekConfiguration : IEntityTypeConfiguration<SalesByWeek>
    {
        public void Configure(EntityTypeBuilder<SalesByWeek> builder)
        {
            builder.ToView("SalesByWeek", "dbo");
            builder.HasNoKey();

            builder.Property(x => x.Year).HasColumnName(@"Year").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.Week).HasColumnName(@"Week").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(50)").IsRequired().IsUnicode(false).HasMaxLength(50);
            builder.Property(x => x.NumOrders).HasColumnName(@"NumOrders").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.Qty).HasColumnName(@"Qty").HasColumnType("int").IsRequired(false);
            builder.Property(x => x.SubTotal).HasColumnName(@"SubTotal").HasColumnType("decimal(38,4)").HasPrecision(38,4).IsRequired(false);
        }
    }

    // SignatureUsed
    public class SignatureUsedConfiguration : IEntityTypeConfiguration<SignatureUsed>
    {
        public void Configure(EntityTypeBuilder<SignatureUsed> builder)
        {
            builder.ToTable("SignatureUsed", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_SignatureUsed").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Modulus).HasColumnName(@"Modulus").HasColumnType("varchar(10)").IsRequired().IsUnicode(false).HasMaxLength(10);
        }
    }

    // database_firewall_rules
    public class sys_DatabaseFirewallRuleConfiguration : IEntityTypeConfiguration<sys_DatabaseFirewallRule>
    {
        public void Configure(EntityTypeBuilder<sys_DatabaseFirewallRule> builder)
        {
            builder.ToView("database_firewall_rules", "sys");
            builder.HasNoKey();

            builder.Property(x => x.Id).HasColumnName(@"id").HasColumnType("int").IsRequired().ValueGeneratedOnAdd().UseIdentityColumn();
            builder.Property(x => x.Name).HasColumnName(@"name").HasColumnType("nvarchar(128)").IsRequired().HasMaxLength(128);
            builder.Property(x => x.StartIpAddress).HasColumnName(@"start_ip_address").HasColumnType("varchar(45)").IsRequired().IsUnicode(false).HasMaxLength(45);
            builder.Property(x => x.EndIpAddress).HasColumnName(@"end_ip_address").HasColumnType("varchar(45)").IsRequired().IsUnicode(false).HasMaxLength(45);
            builder.Property(x => x.CreateDate).HasColumnName(@"create_date").HasColumnType("datetime").IsRequired();
            builder.Property(x => x.ModifyDate).HasColumnName(@"modify_date").HasColumnType("datetime").IsRequired();
        }
    }

    // VolumeDiscount
    public class VolumeDiscountConfiguration : IEntityTypeConfiguration<VolumeDiscount>
    {
        public void Configure(EntityTypeBuilder<VolumeDiscount> builder)
        {
            builder.ToTable("VolumeDiscount", "dbo");
            builder.HasKey(x => x.Id).HasName("PK_VolumeDiscount").IsClustered();

            builder.Property(x => x.Id).HasColumnName(@"Id").HasColumnType("int").IsRequired().ValueGeneratedNever();
            builder.Property(x => x.Active).HasColumnName(@"Active").HasColumnType("bit").IsRequired();
            builder.Property(x => x.ProductId).HasColumnName(@"ProductId").HasColumnType("int").IsRequired();
            builder.Property(x => x.LicenceTypeId).HasColumnName(@"LicenceTypeId").HasColumnType("int").IsRequired();
            builder.Property(x => x.Description).HasColumnName(@"Description").HasColumnType("varchar(150)").IsRequired().IsUnicode(false).HasMaxLength(150);
            builder.Property(x => x.MinQty).HasColumnName(@"MinQty").HasColumnType("int").IsRequired();
            builder.Property(x => x.MaxQty).HasColumnName(@"MaxQty").HasColumnType("int").IsRequired();
            builder.Property(x => x.DiscountPercentage).HasColumnName(@"DiscountPercentage").HasColumnType("decimal(9,5)").HasPrecision(9,5).IsRequired(false);

            // Foreign keys
            builder.HasOne(a => a.LicenceType).WithMany(b => b.VolumeDiscounts).HasForeignKey(c => c.LicenceTypeId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_VolumeDiscount_LicenceType_LicenceTypeId");
            builder.HasOne(a => a.Product).WithMany(b => b.VolumeDiscounts).HasForeignKey(c => c.ProductId).OnDelete(DeleteBehavior.ClientSetNull).HasConstraintName("FK_VolumeDiscount_Product_ProductId");

            builder.HasIndex(x => x.LicenceTypeId).HasDatabaseName("IX_VolumeDiscount_LicenceTypeId");
            builder.HasIndex(x => x.ProductId).HasDatabaseName("IX_VolumeDiscount_ProductId");
        }
    }


    #endregion

}
// </auto-generated>
