﻿using System.Text;

namespace Efrpg.Generators
{
    public class FileHeaderFooter
    {
        public readonly string Header;
        public readonly string Namespace;
        public readonly string Footer;

        public FileHeaderFooter(string subNamespace)
        {
            var header = new StringBuilder(1024);
            header.AppendLine("// <auto-generated>");
           
            if (Settings.UseResharper)
                header.AppendLine("// ReSharper disable All");

            if (Settings.AllowNullStrings)
                header.AppendLine("#nullable enable");
            
            if (Settings.UsePragma)
                header.AppendLine("#pragma warning disable 1591    //  Ignore \"Missing XML Comment\" warning");
            
            foreach (var additionalHeader in Settings.AdditionalFileHeaderText)
            {
                header.AppendLine(additionalHeader);
            }

            Header = header.ToString();

            header = new StringBuilder(500);
            if (Settings.UseNamespace)
            {
                var name = Settings.Namespace + subNamespace;
                header.AppendLine("namespace " + name.Trim().Replace(' ', '_'));
                header.Append("{");
            }

            Namespace = header.ToString();

            var footer = new StringBuilder(30);
            if (Settings.UseNamespace)
                footer.AppendLine("}");
            foreach (var additionalHeader in Settings.AdditionalFileFooterText)
            {
                footer.AppendLine(additionalHeader);
            }
            footer.Append("// </auto-generated>");
            Footer = footer.ToString();
        }
    }
}